#include "StdAfx.h"
#include "Camera.h"


Camera::Camera(void)
{
	m_ViewType = Perspective;
	ResetView();
}

Camera::~Camera(void)
{
}


//=============================================================
// void ToggleViewType(char nChar)
// 
// This function toggles the type of viewport
//
//=============================================================
void Camera::ToggleViewType(char nChar)
{
		/*
		|| (tolower(nChar) == 'r')
		|| (tolower(nChar) == 'f')
		|| (tolower(nChar) == 't'))*/
	if ((tolower(nChar) == 'l'))
		m_ViewType = Left;
	else if ((tolower(nChar) == 'r'))
		m_ViewType = Right;
	else if ((tolower(nChar) == 'f'))
		m_ViewType = Front;
	else if ((tolower(nChar) == 't'))
		m_ViewType = Top;
	else if ((tolower(nChar) == 'b'))
		m_ViewType = Back;
	else if ((tolower(nChar) == 'p'))
		m_ViewType = Perspective;

	ResetView();

}




//==============================================================
// ResetView()
//
// Resets the view of the screen
//==============================================================
void Camera::ResetView()
{
	At = D3DXVECTOR3(-53,166,-243);
	Orientation = D3DXVECTOR3(0,1,0); // y is up (most of the time)	
    XAngle =  36;
    ZAngle = 193;
	PanX = 0;
	PanY = 0;
	ZoomIn = 0;
	TotalZoom = 1.0f;

	if (m_ViewType == Right)
	{
		sprintf_s(m_ViewTypeText,"Right");
		XAngle =  0;
		ZAngle = 90;
		At = D3DXVECTOR3(150,50,0);
	}
	else if (m_ViewType == Left)
	{
		sprintf_s(m_ViewTypeText,"Left");
		XAngle =  0;
		ZAngle = -90;
		At = D3DXVECTOR3(-150,50,0);
	}
	else if (m_ViewType == Front)
	{
		sprintf_s(m_ViewTypeText,"Front");
		XAngle =  0;
		ZAngle = 0;
		At = D3DXVECTOR3(0,50,150);
	}
	else if (m_ViewType == Back)
	{
		sprintf_s(m_ViewTypeText,"Back");
		XAngle = 0;
		ZAngle = 180;
		At = D3DXVECTOR3(0,50,-150);
	}
	else if (m_ViewType == Top)
	{
		sprintf_s(m_ViewTypeText,"Top");
		XAngle =  90;
		ZAngle = 0;
		At = D3DXVECTOR3(0,100,0);
	}
	else if (m_ViewType == Perspective)
	{
		sprintf_s(m_ViewTypeText,"Perspective");
	}
	AdjustCameraPosition(); // puts the changes thru.. otherwise it waits till the next render cycle to change the coordinates
	// only changed due to use for the robottrackers where it isn't in a rendering cycle
}

//==============================================================
// AdjustCameraPosition()
//
// This function is called during a rendering run to adjust the camera
// position based on where the new camera position user based on user 
// input.
//
//==============================================================
void Camera::AdjustCameraPosition()
{
	float Movement = 0.1f; // constant to change movement speed


	float dx,dy,dz;		

	// check if there is any new mouse input to move the camera
	if ( PanX != 0)
	{
		if ( PanX < 0)
		{
			// pan right
			AdjustCameraPosition(dx,dy,dz, XAngle, ZAngle+90,Movement* PanX);

			float adx = dx;
			if (dx < 0)
				adx = -dx;

			float adz = dz;
			if (dz < 0)
				adz = -dz;

			float NSum = adx + adz;

			dx = dx/NSum*Movement* PanX;
			dz = dz/NSum*Movement* PanX;
		}
		else
		{
			// pan left
			AdjustCameraPosition(dx,dy,dz, XAngle, ZAngle-90,-Movement* PanX);		  

			float adx = dx;
			if (dx < 0)
				adx = -dx;

			float adz = dz;
			if (dz < 0)
				adz = -dz;

			float NSum = adx + adz;
			dx = dx/NSum*Movement*- PanX;
			dz = dz/NSum*Movement*- PanX;

		}	
	
		 At.x += dx;
		 At.z += dz;
		 PanX = 0;
	}
	if ( PanY != 0)
	{
		if ( PanY < 0)
		{
			// pan up
			AdjustCameraPosition(dx,dy,dz, XAngle+90, ZAngle,-Movement* PanY);

		}
		else
		{
			// pan down
			AdjustCameraPosition(dx,dy,dz, XAngle-90, ZAngle,Movement* PanY);		  
		}
		 At.x += dx;
		 At.z += dz; 
		 At.y += dy;
		 PanY = 0;
	}
	if ( ZoomIn != 0)
	{
		if ( ZoomIn < 0)
		{
			// zoom out
			AdjustCameraPosition(dx,dy,dz, XAngle, ZAngle,Movement* ZoomIn);
			 At.x += dx;
			 At.y += dy;
			 At.z += dz; 
		}	   
		else 
		{
			// zoom in
			AdjustCameraPosition(dx,dy,dz, XAngle, ZAngle,Movement* ZoomIn);
			 At.x += dx;
			 At.y += dy;
			 At.z += dz; 
		}
		 TotalZoom -=  ZoomIn/350.0f;
		 ZoomIn = 0;
	}


     Eye =  At;		

	AdjustCameraPosition(dx,dy,dz, XAngle, ZAngle,15);

	// adjust eye position
     Eye.x =  At.x + dx;
     Eye.y =  At.y + dy;
     Eye.z =  At.z + dz;	

}


//==============================================================
// AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
//
// This function is a helper function which chooses the dx dy dz from a point based on 
// two angles and a radius
//==============================================================
void Camera::AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
{
	// new way
    // first resolve the y and z coordinate and then backtrack to resolve the x coordinate
    dy = Radius*(float)sin(AngleX*PI/180);
    dz = Radius*(float)cos(AngleX*PI/180);    
    
    // o.k resolve dz and dx using the old dx as the radius
    Radius = dz;
    dx = Radius*(float)sin(AngleY*PI/180);
    dz = Radius*(float)cos(AngleY*PI/180);
 
}


void Camera::OnMouseMove(UINT nFlags, CPoint Point)
{
	float AngleRatio = 0.3f;
	float ZoomRatio = 10.0f;
	float PanRatio = 3.0f;

	if (MK_CONTROL & nFlags)
	{

		if (nFlags & MK_LBUTTON) // left mouse button down, perform rotation
		{
			// well we are perspective now I guess
			if (m_ViewType != Perspective)
			{
				sprintf_s(m_ViewTypeText,"Perspective");
				m_ViewType = Perspective;
			}
			float DeltaX = (float)(OldMousePoint.x - Point.x);
			float DeltaY = (float)(OldMousePoint.y - Point.y);
                        
			XAngle += DeltaY*AngleRatio;
			ZAngle += DeltaX*AngleRatio;        
		
			if (XAngle < -89)
				XAngle = -89;
			if (XAngle > 89)
				XAngle = 89;
		}
		else if (nFlags & MK_RBUTTON) // right mouse button down, perform pan
		{
			PanX = (long)(PanRatio*(OldMousePoint.x - Point.x));
			PanY = (long)(PanRatio*(OldMousePoint.y - Point.y));
		}
		else if (nFlags & MK_MBUTTON) // middle mouse button, perform zoom
		{
			ZoomIn = -ZoomRatio*(float)(OldMousePoint.y - Point.y);
		}
	}
	else
	{
		/*if (EnableAxisMove)
		{
			if (AxisMove.OnMouseMove(nFlags,Point))
			{
				Point3 movement = AxisMove.MouseMovement();
				movement = -movement;
				theInterface.OnChangeXYZValues(movement,false,false);
				
			}
		}*/
		// check if we are selecting object if so it should be displayed on the 
		// window		
	}		
	
    OldMousePoint = Point;

}