#ifndef S3DWINDOW_H
#define S3DWINDOW_H
#include "stddef.h"
#include <d3dx9.h>
#include "D3dx9core.h"
#include "Camera.h"
#include "fish.h"



class S3DWindow :
	public CWnd
{

public:
	// define the 3d devices
	LPDIRECT3D m_pD3D;
	LPDIRECT3DDEVICE m_pd3dDevice; 

	CWnd *m_pParent; // stores the parent pointer
	CRect m_WindowRect; // stores the location of the window

	// does all the camera work
	Camera m_Camera;

	LPD3DXFONT  m_pFont;   // font used for drawing text

	// display name of object that the mouse is over
	int m_FontWidth;
	bool m_RenderMouseOverObject;

	void RenderWindowEffects(); // just a function to put misc rendering stuff in

	bool m_RunSimulation;

	
	// for the nice border
	DWORD m_InFocusBorderColor;
	TRANSLITVERTEX m_InFocusVB[24]; // border window vertex buffer
	void ResetBorder(DWORD color);
	void DirectXFormRect(TRANSLITVERTEX *&pVertex, CRect rect, DWORD color); // helper function
	void DirectXFormLineSquare(LINEVERTEX *&pVertex, int &VertexCount, D3DXVECTOR3 v1, D3DXVECTOR3 v2, D3DXVECTOR3 v3, D3DXVECTOR3 v4, DWORD Color);


	// init the 3D window
	void Init(CWnd *Parent, CRect WindowRect);

	void Render(); // render the window

	bool m_bEnableView;

	LPDIRECT3DTEXTURE m_FishTexture;
	

public:
	S3DWindow(void);
	~S3DWindow(void);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
public:
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);	

	
public:
	afx_msg void OnTimer(UINT_PTR nIDEvent);
};

#endif