#include "StdAfx.h"
#include "fish.h"

fish::fish(void)
{	
	init();
}

fish::~fish(void)
{
}

void fish::init()
{
	m_Movement = D3DXVECTOR3(0,0,0);
	c_Maxmovement = MAXFISHMOVEMENTSPEED;
	c_maxmovementleft = MAXFISHMOVEMENTTIME; // 20 seconds
	m_MovementLeft = 0;

	c_MaxBounds = MAXWORLDBOUND;
	c_MinBounds = MINWORLDBOUND;

	float xbound = c_MaxBounds.x - c_MinBounds.x;
	float ybound = c_MaxBounds.y - c_MinBounds.y;
	float zbound = c_MaxBounds.z - c_MinBounds.z;

	m_Location.x = xbound*rand()/(RAND_MAX+1) + c_MinBounds.x;
	m_Location.y = ybound*rand()/(RAND_MAX+1) + c_MinBounds.y;
	m_Location.z = zbound*rand()/(RAND_MAX+1) + c_MinBounds.z;

	int pickcolor = 10*rand()/(RAND_MAX+1);

	m_Color = ColorLut[pickcolor];
}

void fish::MoveFish()
{
	D3DXVECTOR3 prevlocation = m_Location;

	if (m_MovementLeft <= 0)
	{
		// make a new random movement;
		m_Movement.x = c_Maxmovement.x*rand()/(RAND_MAX+1)-c_Maxmovement.x/2;
		m_Movement.y = c_Maxmovement.y*rand()/(RAND_MAX+1)-c_Maxmovement.y/2;
		m_Movement.z = c_Maxmovement.z*rand()/(RAND_MAX+1)-c_Maxmovement.z/2;

		m_MovementLeft = c_maxmovementleft*rand()/(RAND_MAX+1);
		MoveFish(); // might as well move this turn
	}
	else
	{
		// just move the fish
		m_Location += m_Movement;

		// check the bounds
		if (c_MaxBounds.x < m_Location.x)
			m_Location.x = c_MaxBounds.x;
		if (c_MaxBounds.y < m_Location.y)
			m_Location.y = c_MaxBounds.y;
		if (c_MaxBounds.z < m_Location.z)
			m_Location.z = c_MaxBounds.z;
		if (c_MinBounds.x > m_Location.x)
			m_Location.x = c_MinBounds.x;
		if (c_MinBounds.y > m_Location.y)
			m_Location.y = c_MinBounds.y;
		if (c_MinBounds.z > m_Location.z)
			m_Location.z = c_MinBounds.z;

		m_MovementLeft--;
	}



}