#include "StdAfx.h"
#include "fishmanager.h"

// global reference
fishmanager TheFishManager;

fishmanager::fishmanager(void)
{
	// randomize
	srand( (unsigned)time( NULL ) );

	m_NumFishes = NUMBEROFFISH;

	for (int ix = 0; ix < m_NumFishes; ix++)
	{
		m_Fishes[ix].init();
	}
}

fishmanager::~fishmanager(void)
{
}

void fishmanager::RenderFishes(LPDIRECT3DDEVICE pd3dDevice)
{
	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE2X );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

	for (int ix = 0; ix < m_NumFishes; ix++)
	{
		// now render it;
		TEXTUREDVERTEXSTRUCT fishvertex[36];
		DirectXFormBox(fishvertex,m_Fishes[ix].m_Location,FISHRENDERSIZE,FISHRENDERSIZE,FISHRENDERSIZE,m_Fishes[ix].m_Color);

	/*	m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE);
		m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
		m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA); */
		

		pd3dDevice->SetFVF(TEXTUREDVERTEX);
		pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLELIST,12,fishvertex,sizeof(TEXTUREDVERTEXSTRUCT)); 

	//	m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE);


	}

}

 void fishmanager::MoveFishes()
 {
	for (int ix = 0; ix < m_NumFishes; ix++)
	{
		m_Fishes[ix].MoveFish();
	}
 }

void fishmanager::DirectXFormBox(TEXTUREDVERTEXSTRUCT Vertex[36], D3DXVECTOR3 orig, float xsize,float ysize, float zsize, DWORD color)
{

	D3DXVECTOR3 Vertices[8];

	Vertices[0].x = + xsize + orig.x;
	Vertices[0].y = + ysize + orig.y;
	Vertices[0].z = + zsize + orig.z;

	Vertices[1].x = + xsize + orig.x;
	Vertices[1].y = + ysize + orig.y;
	Vertices[1].z = - zsize + orig.z;

	Vertices[2].x = - xsize + orig.x;
	Vertices[2].y = + ysize + orig.y;
	Vertices[2].z = - zsize + orig.z;

	Vertices[3].x = - xsize + orig.x;
	Vertices[3].y = + ysize + orig.y;
	Vertices[3].z = + zsize + orig.z;

	// do the bottoms ones going clockwise
	Vertices[4].x = + xsize + orig.x;
	Vertices[4].y = - ysize + orig.y;
	Vertices[4].z = + zsize + orig.z;

	Vertices[5].x = + xsize + orig.x;
	Vertices[5].y = - ysize + orig.y;
	Vertices[5].z = - zsize + orig.z;

	Vertices[6].x = - xsize + orig.x;
	Vertices[6].y = - ysize + orig.y;
	Vertices[6].z = - zsize + orig.z;

	Vertices[7].x = - xsize + orig.x;
	Vertices[7].y = - ysize + orig.y;
	Vertices[7].z = + zsize + orig.z;

	TEXTUREDVERTEXSTRUCT *pVertex = Vertex;
	int VertexCount = 0;

	// form top box
	DirectXFormSquare(pVertex,VertexCount
		,Vertices[0],Vertices[1],Vertices[2],Vertices[3],color);

	// form bottom box
	DirectXFormSquare(pVertex,VertexCount
		,Vertices[7],Vertices[6],Vertices[5],Vertices[4],color);
	
	DirectXFormSquare(pVertex,VertexCount
		,Vertices[1],Vertices[0],Vertices[4],Vertices[5],color);

	DirectXFormSquare(pVertex,VertexCount
		,Vertices[2],Vertices[1],Vertices[5],Vertices[6],color);

	DirectXFormSquare(pVertex,VertexCount
		,Vertices[3],Vertices[2],Vertices[6],Vertices[7],color);

	DirectXFormSquare(pVertex,VertexCount
		,Vertices[0],Vertices[3],Vertices[7],Vertices[4],color);



}
//////////////////////////////////////////////////////////////////////
// DirectXFormSquare(TLNVERTEXSTRUCT *&pVertex, int &VertexCount, Point3 v1, Point3 v2, Point3 v3, Point3 v4)
//
// Helper function forms a square out of 4 vertices
// Render the box using direct x
//
//
// by convention for texturing (x,y) = (u,v)
// v1 is top left (0,0)
// v2 is top right (1,0)
// v3 is bottom right (1,1)
// v4 is bottom left (0,1)
//////////////////////////////////////////////////////////////////////
void fishmanager::DirectXFormSquare(TEXTUREDVERTEXSTRUCT *&pVertex, int &VertexCount, D3DXVECTOR3 v1, D3DXVECTOR3 v2, D3DXVECTOR3 v3, D3DXVECTOR3 v4, DWORD Color)
{


	// render the box here as 
	pVertex[0].x = (float)v1.x;
	pVertex[0].y = (float)v1.y;
	pVertex[0].z = (float)v1.z;
	pVertex[0].tu = 0.0f;
	pVertex[0].tv = 0.0f;
	pVertex[0].color = Color;

	pVertex[1].x = (float)v2.x;
	pVertex[1].y = (float)v2.y;
	pVertex[1].z = (float)v2.z;
	pVertex[1].tu = 1.0f;
	pVertex[1].tv = 0.0f;
	pVertex[1].color = Color;

	pVertex[2].x = (float)v3.x;
	pVertex[2].y = (float)v3.y;
	pVertex[2].z = (float)v3.z;
	pVertex[2].tu = 1.0f;
	pVertex[2].tv = 1.0f;
	pVertex[2].color = Color;

	pVertex[3].x = (float)v3.x;
	pVertex[3].y = (float)v3.y;
	pVertex[3].z = (float)v3.z;
	pVertex[3].tu = 1.0f;
	pVertex[3].tv = 1.0f;
	pVertex[3].color = Color;

	pVertex[4].x = (float)v4.x;
	pVertex[4].y = (float)v4.y;
	pVertex[4].z = (float)v4.z;
	pVertex[4].tu = 0.0f;
	pVertex[4].tv = 1.0f;
	pVertex[4].color = Color;

	pVertex[5].x = (float)v1.x;
	pVertex[5].y = (float)v1.y;
	pVertex[5].z = (float)v1.z;
	pVertex[5].tu = 0.0f;
	pVertex[5].tv = 0.0f;
	pVertex[5].color = Color;

	VertexCount += 2;
	pVertex+=6;
	

}
