using System;
using System.Collections.Generic;
using System.Text;

using System.Net;
using System.Threading;
using System.IO;
using System.Collections;


namespace FTPBackup
{

    class FTPInterface
    {

       
        public Form1 Form1ref; // this is here so we could access the form1 writeline function if need be
    
        // just some date members to display the upload status
        public long TotalBytes;
        public long TotalBytesLeft;

        // this is kind of a lock that form1 uses to see if we should send out another file
        public bool CurrentlySending;

        // base directory of the ftp that is added to the directory names to form the complete directory name
        public String FTPBaseDirectory;
      
        /// <summary>
        ///  From the ms-help://MS.VSCC.v80/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref10/html/T_System_Net_FtpWebRequest.htm
        ///  this is used to store variables to send files asyncronously
        /// </summary>
        public class AsyncState
        {

            public ManualResetEvent wait;
            public FtpWebRequest request;
            public string fileName;
            public Exception operationException;
            public string status;
            public FTPInterface theInterface;

            public AsyncState()
            {
                wait = new ManualResetEvent(false);
                operationException = null;
            }
                
        };

        AsyncState theAsyncState;

        public FTPInterface()
        {
           
            TotalBytesLeft = 0;
            TotalBytes = 0;
            CurrentlySending = false;
        }

        /// <summary>
        /// This should be called when starting a ftp backup
        /// It setups up the parent backup directory (named by the date)
        /// </summary>
        public bool SetupFTP()
        {        
            FTPBaseDirectory = "ftp://" + XMLStorage.FTPName + "/" + XMLStorage.FTPBackupDirectory + "/";
         
            // now add the date directory
            DateTime today;
            today = DateTime.Now;
         

            string[] todays = today.GetDateTimeFormats();

            FTPBaseDirectory += todays[15] + "/";           

  
            try
            {
                Uri siteUri = new Uri(FTPBaseDirectory);
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(siteUri);
                request.Credentials = new NetworkCredential(XMLStorage.FTPUserName, XMLStorage.FTPPassword);
                request.Method = WebRequestMethods.Ftp.MakeDirectory;
                request.UsePassive = false;
                //request.
                FtpWebResponse response = (FtpWebResponse)request.GetResponse();

                // WebRequestMethods.Ftp.
                StreamReader reader = null;
                reader = new StreamReader(response.GetResponseStream());
                Console.WriteLine(reader.ReadToEnd());
                Console.WriteLine(response.StatusDescription);

                string list = response.ToString();
                Console.WriteLine(list);
                Console.WriteLine(response.ContentLength);
            }
            catch (Exception e)
            {
                Console.Write(e);
                Console.WriteLine("Probably trying to overright a directory");
                Form1ref.WriteLine("Error, probably ftp misconfiguration");
                return false;

            }
            return true;
        }

        /// <summary>
        /// Writes a directory to the ftp site
        /// </summary>
        /// <param name="Directory">Name of the directory to write</param>
        public void WriteDirectory(String Directory)
        {
          
            String newdirectory = FTPBaseDirectory + Directory;

            try
            {
                Uri siteUri = new Uri(newdirectory);
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(siteUri);
                request.Credentials = new NetworkCredential(XMLStorage.FTPUserName, XMLStorage.FTPPassword);
                request.Method = WebRequestMethods.Ftp.MakeDirectory;

                request.UsePassive = false;
                //request.
                FtpWebResponse response = (FtpWebResponse)request.GetResponse();

                // WebRequestMethods.Ftp.
                StreamReader reader = null;
                reader = new StreamReader(response.GetResponseStream());
                Console.WriteLine(reader.ReadToEnd());
                Console.WriteLine(response.StatusDescription);

                string list = response.ToString();
                Console.WriteLine(list);
                Console.WriteLine(response.ContentLength);
            }
            catch (Exception e)
            {
                Console.Write(e);

            }
        }

        /// <summary>
        ///  From the ms-help://MS.VSCC.v80/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref10/html/T_System_Net_FtpWebRequest.htm
        /// sents up a async request.  I did not change much
        /// </summary>
        /// <param name="fullName">The file name as saved on the local disk</param>
        /// <param name="fileName">The file name as saved on the ftp site</param>
        public void WriteFileAsnyc(String fullName, String fileName)
        {           
             CurrentlySending = true;

            TotalBytes = 0;
            TotalBytesLeft = 0;

           // ManualResetEvent waitObject;
            theAsyncState = new AsyncState();
            theAsyncState.theInterface = this;
            FtpWebRequest request;

            String fullname = FTPBaseDirectory + fileName;
           

            try
            {
                //request = (FtpWebRequest)WebRequest.Create(writedirectory + fileName);
                request = (FtpWebRequest)WebRequest.Create(fullname);
                request.Method = WebRequestMethods.Ftp.UploadFile;
            }
            catch (Exception e)
            {
                Console.Write(e);
                CurrentlySending = false;
                Form1ref.WriteLine("Warning error in sending");
                return;
            }


            // This example uses anonymous logon.
            // The request is anonymous by default; the credential does not have to be specified. 
            // The example specifies the credential only to
            // control how actions are logged on the server.

            request.Credentials = new NetworkCredential(XMLStorage.FTPUserName, XMLStorage.FTPPassword);

            // Store the request in the object that we pass into the
            // asynchronous operations.
            theAsyncState.request = request;
            theAsyncState.fileName = fullName;

            // Get the event to wait on.
           //waitObject = theAsyncState.wait;

            // Asynchronously get the stream for the file contents.
            request.BeginGetRequestStream(
                new AsyncCallback(EndGetStreamCallback),
                theAsyncState
            );

            // Block the current thread until all operations are complete.
            //waitObject.WaitOne();

            // The operations either completed or threw an exception.
            if (theAsyncState.operationException != null)
            {
                CurrentlySending = false;
                throw theAsyncState.operationException;
               
            }
            else
            {
                Console.WriteLine("The operation completed - {0}", theAsyncState.status);
              
            }


        }

        /// <summary>
        ///  From the ms-help://MS.VSCC.v80/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref10/html/T_System_Net_FtpWebRequest.htm
        /// When a request places its event this is called.  It does the actual file sending
        /// </summary>
        /// <param name="ar"></param>
        private static void EndGetStreamCallback(IAsyncResult ar)
        {
            AsyncState state = (AsyncState)ar.AsyncState;

            Stream requestStream = null;
            // End the asynchronous call to get the request stream.
            try
            {
                requestStream = state.request.EndGetRequestStream(ar);
                // Copy the file contents to the request stream.
                const int bufferLength = 2048;
                byte[] buffer = new byte[bufferLength];
                long count = 0;
                int readBytes = 0;
                FileStream stream = File.OpenRead(state.fileName);
                state.theInterface.TotalBytesLeft = stream.Length;
                do
                {
                    state.theInterface.TotalBytesLeft = stream.Length;
                    readBytes = stream.Read(buffer, 0, bufferLength);
                    requestStream.Write(buffer, 0, readBytes);
                    count += readBytes;
                    state.theInterface.TotalBytes += (long)readBytes; 
                    //state.theInterface.Form1ref.EnterState(" " + state.theInterface.TotalBytes + " / " + state.theInterface.TotalBytesLeft);
                 //   Form1ref = " " + TotalBytes + " / " + TotalBytesLeft;
                }
                while (readBytes != 0);
                Console.WriteLine("Writing {0} bytes to the stream.", count);
                // IMPORTANT: Close the request stream before sending the request.
                requestStream.Close();
                // Asynchronously get the response to the upload request.
                state.request.BeginGetResponse(
                    new AsyncCallback(EndGetResponseCallback),
                    state
                );
            }
            // Return exceptions to the main application thread.
            catch (Exception e)
            {
                Console.WriteLine("Could not get the request stream.");
                state.operationException = e;
                state.theInterface.CurrentlySending = false;
                state.wait.Set();
                return;
            }
            state.theInterface.TotalBytesLeft = 0;

        }

        /// <summary>
        /// From the ms-help://MS.VSCC.v80/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref10/html/T_System_Net_FtpWebRequest.htm
        /// When a request is done this is the event that gets called
        /// </summary>
        /// <param name="ar"></param>
        private static void EndGetResponseCallback(IAsyncResult ar)
        {
            AsyncState state = (AsyncState)ar.AsyncState;
            FtpWebResponse response = null;
            try
            {
                response = (FtpWebResponse)state.request.EndGetResponse(ar);
                response.Close();
                state.status = response.StatusDescription;
                // Signal the main application thread that 
                // the operation is complete.
                state.wait.Set();
                state.theInterface.CurrentlySending = false;
            }
            // Return exceptions to the main application thread.
            catch (Exception e)
            {
                Console.WriteLine("Error getting response.");
                state.operationException = e;
                state.wait.Set();
                state.theInterface.CurrentlySending = false;
            }
        }



        //==========================================================================
        // This could be used to write a file to the ftp directory 
        //
        // note fullName is used to get the local file, filename is used to save the file
        // not used anymore, since it is the syncronous version
        //==========================================================================
        public void WriteFile(String fullName, String fileName)
        {
            // copy in the file

            /*String writedirectory = (String)directoryStack.Peek();

            try
            {
                FtpWebRequest request = (FtpWebRequest)WebRequest.Create(writedirectory + fileName);
                request.Method = WebRequestMethods.Ftp.UploadFile;

                StreamReader sourceStream = new StreamReader(fullName);
                byte[] fileContents = Encoding.UTF8.GetBytes(sourceStream.ReadToEnd());
                sourceStream.Close();
                request.ContentLength = fileContents.Length;

                // This example assumes the FTP site uses anonymous logon.
                request.Credentials = new NetworkCredential(XMLStorage.FTPUserName, XMLStorage.FTPPassword);
                Stream requestStream = request.GetRequestStream();
                requestStream.Write(fileContents, 0, fileContents.Length);
                requestStream.Close();
                FtpWebResponse response = (FtpWebResponse)request.GetResponse();

                Console.WriteLine("Append status: {0}", response.StatusDescription);

                response.Close();
            }
            catch
            {
            }*/

        }
    }

       

}
