using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;

using FTPBackup;

namespace FTPBackup
{
    public partial class Form1 : Form
    {
        FTPInterface m_FTPInterface;
        int linecount = 0;        

        /// <summary>
        /// Backuplist is used to store all the directories and files that are to be backuped
        /// Used in the timer_tick function
        /// </summary>
        public class BackupList
        {
            public bool DirectoryCreated;
            public ArrayList fileinfo;
            public int NumberofFiles;
            public int FileIndex;
            public DirectoryInfo dirinfo;
            public String writeDirectory;
            public bool PopDirectory;
            public BackupList()
            {
                DirectoryCreated = false;
                NumberofFiles = 0;
                FileIndex = 0;
                writeDirectory = "";
                PopDirectory = false;
            }
        };
        public ArrayList backupList;
        int NumberofDirectories;
        int DirectoriesSendIndex;

        public Form1()
        {

            // do the basic configuration here
            InitializeComponent();
            m_FTPInterface = new FTPInterface();
            m_FTPInterface.Form1ref = this;
            XMLStorage.ConfigXMLStorage();
             
            // add the directories stored in the xml to the listview
            XMLStorage.dirInfo enumadd;          
            for (int ix = 0; ix < XMLStorage.saveDirectories.Count; ix++)
            {
                enumadd = (XMLStorage.dirInfo)XMLStorage.saveDirectories[ix];
                ListViewItem listItem = new ListViewItem(enumadd.directory);
                listItem.SubItems.Add(enumadd.recursesub);
                DirectoryList.Items.Add(listItem);
            }
            this.dateTimePicker1.Value = XMLStorage.BackupTime;
            this.dateTimePicker1.CustomFormat = "h:mm tt MMMM dd, yyyy - dddd";
            this.dateTimePicker1.Format = DateTimePickerFormat.Custom;
            this.timer1.Interval = 100;
            this.timer1.Enabled = true;
            
            
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        // setup the ftp information
        private void save_Click(object sender, EventArgs e)
        {          
           FTPSetup setup = new FTPSetup();
           setup.ShowDialog();
        }

        // add a directory to the backup list (and the list view and xml)
        private void btnAddDirectory_Click(object sender, EventArgs e)
        {

            String SelectedPath;
            FolderBrowserDialog tdialog = new FolderBrowserDialog();
            if (tdialog.ShowDialog() == DialogResult.OK)
            {
                SelectedPath = tdialog.SelectedPath;
              
                ListViewItem listItem = new ListViewItem(SelectedPath);
                listItem.SubItems.Add("true");
                DirectoryList.Items.Add(listItem);

                SaveDirectoriestoXML();
            }
        }

        // remove a directory to the backup list (and the list view and xml)
        private void btnDelDirectory_Click(object sender, EventArgs e)
        {
            ListView.SelectedIndexCollection list = DirectoryList.SelectedIndices;
            if (list.Count == 1)
            {
                DirectoryList.Items.RemoveAt(list[0]);
               // ListViewItem listItem = new ListViewItem(list[0]);
               // DirectoryList.Items.Remove(listItem);
            }
        }

        // toggle a directory settings to the backup list (and the list view and xml)
        private void btnToggleSubDir_Click(object sender, EventArgs e)
        {
            ListView.SelectedIndexCollection list = DirectoryList.SelectedIndices;
            if (list.Count == 1)
            {
                if (DirectoryList.Items[list[0]].SubItems[1].Text == "false")
                    DirectoryList.Items[list[0]].SubItems[1].Text = "true";
                else
                    DirectoryList.Items[list[0]].SubItems[1].Text = "false";

                SaveDirectoriestoXML();

            }

        }

        // util function to update the xml file
        private void SaveDirectoriestoXML()
        {
            // this saves the directory information to the xml file
            XMLStorage.dirInfo enumadd;
            XMLStorage.saveDirectories.Clear();
            for (int ix = 0; ix < DirectoryList.Items.Count; ix++)
            {
                enumadd.directory = DirectoryList.Items[ix].Text;
                enumadd.recursesub = DirectoryList.Items[ix].SubItems[1].Text;
                XMLStorage.saveDirectories.Add(enumadd);
            }
            XMLStorage.SaveXML();       
   

        }

        /// <summary>
        /// This function does the work of creating the list of files and directoies that are used
        /// to backup the files.
        /// </summary>
        /// <remarks>
        /// 1) Setups up the ftp (writes a new directory) and creates the list that stores the files and directories
        /// 2) Iterate each directory in the list
        /// 3) Do a top down recursive iteration by using a queue
        /// 4) add all the files for each directory and add the subdirectories to the queue and recurse till
        ///    there isn't any subdirectories left
        /// </remarks>
        private void CreateBackupList()
        {
            if (XMLStorage.FTPName == "Need ftp name")
            {
                WriteLine("Cannot backup, you need to input ftp information");
                return;
            }

            //1 do the initial setup  
            WriteLine("Backing up right now");

            // make sure the ftp info is correct
            bool isvalid = m_FTPInterface.SetupFTP();
            if (isvalid == false)
                return;

            backupList = new ArrayList();
            NumberofDirectories = 0;
            DirectoriesSendIndex = 0;
            Stack directoryStack; // stores information of what directory to write to t
           

            // 2)  
            for (int idirectory = 0; idirectory < DirectoryList.Items.Count; idirectory++)
            {

                // 3) to a top down tree walk
                String directory = DirectoryList.Items[idirectory].Text;
                String recursesub = DirectoryList.Items[idirectory].SubItems[1].Text;

                // add the first directory into the queue to get things going
                Queue subdirectories = new Queue();
                DirectoryInfo search = new DirectoryInfo(directory);
                subdirectories.Enqueue(search);

                directoryStack = new Stack();
                directoryStack.Push("");
              
                DirectoryInfo enumdir;
                int prevcount = subdirectories.Count;

                // 4) now traverse the queue
                while (subdirectories.Count > 0)
                {
                    // spit out the files
                    enumdir = (DirectoryInfo)subdirectories.Dequeue();

                    // create the backup structure
                    BackupList tobackup = new BackupList();
                    tobackup.dirinfo = enumdir;
                    // create the file list structure
                    tobackup.fileinfo = new ArrayList();


                    String basename = (String)directoryStack.Peek();
                    tobackup.writeDirectory = basename + enumdir.Name + "/";
                    directoryStack.Push(tobackup.writeDirectory);

                    FileInfo[] fileinfo;
                    fileinfo = enumdir.GetFiles();

                    // add each file that is the correct backup time
                    for (int ifile = 0; ifile < fileinfo.Length; ifile++)
                    {
                        if (fileinfo[ifile].LastWriteTime > XMLStorage.BackupTime)
                        {
                            tobackup.fileinfo.Add(fileinfo[ifile]);
                            tobackup.NumberofFiles++;
                        }
                    }

                    // now add any subdirectories
                    if (recursesub == "true")
                    {
                        DirectoryInfo[] dirinfo;
                        dirinfo = enumdir.GetDirectories();
                        // add to the queue
                        for (int iadd = 0; iadd < dirinfo.Length; iadd++)
                        {
                            subdirectories.Enqueue(dirinfo[iadd]);
                        }
                    }

                    // this only happens when we are going up the queue so pop the stack
                    // on the other end
                    if (prevcount > subdirectories.Count)
                    {
                        directoryStack.Pop();
                    }
                    backupList.Add(tobackup);
                    NumberofDirectories++;

                    prevcount = subdirectories.Count;

                }
            }

            // update the last backup time
            XMLStorage.BackupTime = DateTime.Now;
            dateTimePicker1.Value = DateTime.Now;

            XMLStorage.SaveXML();
        }

        // event handler for doing the backup
        private void btnDoBackup_Click(object sender, EventArgs e)
        {
            CreateBackupList();
        }

       /// <summary>
       /// Writes a line to the console display (actually just a textbox that scrolls)
       /// </summary>
       /// <param name="text">A line of text to be displayed</param>
        public void WriteLine(String text)
        {
            tbConsole.Text = linecount + ": " + text + Environment.NewLine + tbConsole.Text;
            tbConsole.ScrollToCaret();    
            linecount++;
            tbConsole.Update();
        }

        // saves the new date to the xml file
        private void dateTimePicker1_ValueChanged(object sender, EventArgs e)
        {
            String text = dateTimePicker1.Text;
            XMLStorage.BackupTime = dateTimePicker1.Value;
            XMLStorage.SaveXML();

        }
        
        /// <summary>
        /// Uses the tick to check if we should send over a file, if so send it over
        /// </summary>
        /// <remarks>
        /// the function which actually does the backing up.  This checks the backup list which is stores
        /// each backup directory and all the files in that directory.  The directory are stored in recurse order
        /// so it matches up with the directory stack in the FtpInterface.  I could probably have pulled that out,
        /// and simply put in the full directory name information here but it was already working so I left it.  
        /// </remarks>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            // this code outputs the upload status
            if (m_FTPInterface.TotalBytesLeft != 0)
                txtStatus.Text = m_FTPInterface.TotalBytes + " / " + m_FTPInterface.TotalBytesLeft;
            else
                txtStatus.Text = " ";

            if (m_FTPInterface.CurrentlySending == false)
            {
                if (DirectoriesSendIndex != NumberofDirectories)
                {
                    // k send something
                    BackupList enumList;
                    enumList = (BackupList)backupList[DirectoriesSendIndex];                   
                    if (enumList.DirectoryCreated == false)
                    {
                        WriteLine("Creating Directory: " + enumList.writeDirectory);
                        m_FTPInterface.WriteDirectory(enumList.writeDirectory);
                        enumList.DirectoryCreated = true;
                    }
                    // send a file
                    // this happens if the directory doesn't contain any files
                    if (enumList.FileIndex == enumList.NumberofFiles)                        
                    {
                        DirectoriesSendIndex++;
                        return;
                    }
                    FileInfo enumFile = (FileInfo)(enumList.fileinfo[enumList.FileIndex]);
                    WriteLine("Writing file : " + enumFile.FullName);
                    //WriteLine(enumFile.ToString());
                   // m_FTPInterface.WriteFile(enumFile.FullName, fileinfo[ifile].Name);
                    m_FTPInterface.WriteFileAsnyc(enumFile.FullName, enumList.writeDirectory + enumFile.Name);
                    enumList.FileIndex++;
                    if (enumList.FileIndex == enumList.NumberofFiles)
                    {                   
                        // this is sort of the iterator on a for loop
                        DirectoriesSendIndex++;
                        if (DirectoriesSendIndex == NumberofDirectories)
                            WriteLine("Backup Done!");
                    }

                }
            }

        }

        // event handler
        private void btnAbout_Click(object sender, EventArgs e)
        {
            About tform = new About();
            tform.ShowDialog();
        }

    }
}