#include "StdAfx.h"
#include "MainClass.h"
#include <stdlib.h>


MainClass::MainClass(void)
{
	m_numPeople = 0;
	m_SpeedMultiplier = 1;
	m_Longevity = 5;
	m_aPeople = NULL;
}

MainClass::~MainClass(void)
{
	m_numPeople = 0;
	if (m_aPeople != NULL)
		delete m_aPeople;
}

//==========================================================================
// void Init(int numpeople)
//
//
// Inits the main class
//
//
// This function inits the other two classes also
//==========================================================================
void MainClass::Init(int numpeople)
{
	m_numPeople = numpeople;

	if (m_aPeople != NULL)
		delete m_aPeople;

	m_aPeople = new People[m_numPeople];


	m_maxx = 400;
	m_maxy = 400;
	m_Space.Init(m_maxx,m_maxy);

	// makes sure we don't try to seed more people then we have space
	if (m_maxx*m_maxy < m_numPeople*0.95)
		m_numPeople = (int)(m_maxx*m_maxy*.95);


	int ix;
	for (ix = 0; ix < m_numPeople; ix++)
	{
		int randomx = m_maxx*rand()/RAND_MAX;
		int randomy = m_maxy*rand()/RAND_MAX;

		// make sure only one per space
		if (!(m_Space.IsFree(randomx,randomy)))
			ix--;
		else
		{
			m_aPeople[ix].Init(ix,randomx,randomy);
			m_Space.SetPerson(randomx,randomy,ix);
		}
		
	}
}


//==========================================================================
// void Render(CDC &dc)
//
//
// Renders the simulation
//
// Renders the border and the people inside it
//==========================================================================
void MainClass::Render(CDC &dc)
{
	int offestx = 10;
	int offsety = 10;
	CBrush redbrush,bluebrush,yellowbrush;

	redbrush.CreateSolidBrush(RGB(255,0,0));
	bluebrush.CreateSolidBrush(RGB(0,0,255));
	yellowbrush.CreateSolidBrush(RGB(226,230,81));
	
	
	// draw a thick 5 pixel border
	int ix;
	for (ix = 0; ix < 5; ix++)
	{
		CRect frame;
		frame.left = offestx-ix-1;
		frame.right = offestx+m_maxx+ix+1;
		frame.top = offsety-ix-1;
		frame.bottom = offsety+m_maxy+ix+1;
		
		dc.FrameRect(&frame,&redbrush);
	
	}

	// k now draw each person
	for (ix = 0; ix < m_numPeople; ix++)
	{
		int x,y;
		m_aPeople[ix].GetLocation(x,y);
		
		
		CRect frame;
		frame.left = offestx + x;
		frame.right = offestx + x+2;
		frame.top = offsety + y;
		frame.bottom = offsety + y+2;

		int Type = m_aPeople[ix].GetType();
		if (Type == ONFIRE)
			dc.FrameRect(&frame,&redbrush);
		else if (Type == NOTONFIRE)
			dc.FrameRect(&frame,&bluebrush);
		else if (Type == BURNEDOUT)
			dc.FrameRect(&frame,&yellowbrush);
	}


}


//==========================================================================
// void RunSimulation()
//
//
// This shoudl be called to perform an iteration
//==========================================================================
void MainClass::RunSimulation()
{
	int ix;
	for (ix = 0; ix < m_numPeople; ix++)
	{
		int oldx,oldy,newx,newy;
		// just some code that moves the person.. checks to see if the space is available... and if not
		//   then move the person back to its old location
		m_aPeople[ix].GetLocation(oldx,oldy);
		m_aPeople[ix].MovePerson(m_SpeedMultiplier);

		// now move the person in the space
		m_aPeople[ix].GetLocation(newx,newy);
		if (m_Space.MovePerson(oldx,oldy,newx,newy))
			// this reflects the corrected space
			m_aPeople[ix].SetLocation(newx,newy);		
		else
			m_aPeople[ix].SetLocation(oldx,oldy);
	
			// do the perculation here
		int LUTX[] = {-1,-1,-1,0,0,1,1,1};
		int LUTY[] = {-1,0,-1,-1,1,-1,0,-1};
 

		if (m_aPeople[ix].GetType() == NOTONFIRE)
		{
			m_aPeople[ix].GetLocation(newx,newy);
			int iy;
			for (iy = 0; iy < 8; iy++)
			{		
				int index;
				if (m_Space.GetIndex(newx+LUTX[iy],newy+LUTY[iy],index))
				{
					if (m_aPeople[index].GetType() == ONFIRE)
					{
						m_aPeople[ix].SetType(ONFIRE,m_Longevity);
					}				

				}
			}
		}

	}

	



}

// basic set function
void MainClass::SetLongevity(int longevity)
{
	m_Longevity = longevity;
}

// basic set function
void MainClass::SetSpeedMultiplier(int multiplier)
{
	m_SpeedMultiplier = multiplier;
}

//==========================================================================
// void StartFire(RECT Rect)
//
//
// Given a rectangle.. it sets everyone in that rectangle on fire
//==========================================================================
void MainClass::StartFire(RECT Rect)
{
	int ix,iy;
	for (ix = Rect.left; ix < Rect.right; ix++)
	{
		for (iy = Rect.top; iy < Rect.bottom; iy++)
		{
			int index;
			if (m_Space.GetIndex(ix,iy,index))
			{
				m_aPeople[index].SetType(ONFIRE,m_Longevity);
			}
		}
	}

}
