#include "StdAfx.h"
#include "People.h"
#include <stdlib.h>

People::People(void)
{
	m_x = 0;
	m_y = 0;
	m_mx=m_my = 0;
	m_tleft = 0;
	m_index = 0;
	m_longevity = 0;
	m_PersonType = NOTONFIRE;
}


//==========================================================================
// bool Init(int index,int x, int y)
//
//
// inits a person
//
//==========================================================================
void People::Init(int index,int x, int y)
{
	m_index = index;
	m_x = x;
	m_y = y;
	m_mx=m_my = 0;
	m_tleft = 0;
	m_PersonType  = NOTONFIRE;
}

// returns the location of a person
void People::GetLocation(int &x, int &y)
{
	x = m_x;
	y = m_y;
}

// sets the location of a person
void People::SetLocation(int x, int y)
{
	m_x = x;
	m_y = y;
}


// returns the type of person
COLORREF People::GetType()
{
	return m_PersonType;
}

//==========================================================================
// bool Init(int index,int x, int y)
//
//
// sets the type of person and how long is stays as that person
//
// note: longevity really only applies to ONFIRE type
//==========================================================================

void People::SetType(COLORREF type, int Longevity)
{
	m_PersonType = type;
	if (type == ONFIRE)
		m_longevity = Longevity;
}

//==========================================================================
// void MovePerson(int SpeedMultiplier)
//
//
// This function is called to move a person.. 
//
// Basically called once per simulation iteration
//
// note: Burnedout people don't move
//==========================================================================
void People::MovePerson(int SpeedMultiplier)
{

	if (m_PersonType == BURNEDOUT)
		return;

	int t1,t2,t3;
	if (SpeedMultiplier == 1)
	{
		t1 = 8; t2 = 9; t3 = 10;
	}
	else if (SpeedMultiplier == 2)
	{
		t1 = 6; t2 = 8; t3 = 10;
	}
	else if (SpeedMultiplier == 3)
	{
		t1 = 4; t2 = 7; t3 = 10;
	}
	else if (SpeedMultiplier == 4)
	{
		t1 = 0; t2 = 5; t3 = 10;
	}


	if (m_tleft <= 0)
	{	
		m_mx = (int)(10.0f*rand()/RAND_MAX);
		m_my = (int)(10.0f*rand()/RAND_MAX);
		if (m_my < t1)
			m_my = 0;
		else if (m_my < t2)
			m_my = -1;
		else if (m_my < t3)
			m_my = 1;
		if (m_mx < t1)
			m_mx = 0;
		else if (m_mx < t2)
			m_mx = -1;
		else if (m_mx < t3)
			m_mx = 1;


		m_tleft = (int)(8*rand()/RAND_MAX)+1;
	}
	m_x = m_x + m_mx;
	m_y = m_y + m_my;
	m_tleft--;

	if (m_PersonType == ONFIRE)
	{
		m_longevity--;
		if (m_longevity <= 0)
		{
			m_PersonType = BURNEDOUT;
		}
	}
}