// DisplayTable.cpp: implementation of the DisplayTable class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "DisplayTable.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

DisplayTable::DisplayTable()
{
	m_NumEntries = 0;
	m_Width = 1;

}

DisplayTable::~DisplayTable()
{

}

void DisplayTable::DrawTable(CDC *pDC, CPoint &Offset)
{
	int YSpacing = 15;
	pDC->TextOut(Offset.x,Offset.y,m_Title);
	Offset.y+= YSpacing;

	int NameSpace = 20;
	int EntryWidth = 200;
	int ValueWidth = 80;
	int ValueSpace = 10;

	char TruncValues[10][40];

	strcpy(TruncValues[0],m_Desc[0]);
	TruncValues[0][NameSpace-1] = '\0';

	pDC->TextOut(Offset.x,Offset.y,TruncValues[0]);

	for (int ix =0 ; ix < m_Width; ix++)
	{
		strcpy(TruncValues[ix],m_Desc[ix+1]);
		TruncValues[ix][ValueSpace-1] = '\0';

		RECT Rect;
		Rect.left = Offset.x;
		Rect.right = Offset.x+EntryWidth + ValueWidth*(ix);
		Rect.top = Offset.y;
		Rect.bottom = Offset.y + YSpacing;
		pDC->DrawText(TruncValues[ix],-1,&Rect,DT_RIGHT);		
		
	}
	Offset.y+= YSpacing;

	for (ix = 0; ix < m_NumEntries; ix++)
	{
		strcpy(TruncValues[0],m_aNames[ix]);
		TruncValues[0][NameSpace-1] = '\0';

		pDC->TextOut(Offset.x,Offset.y,TruncValues[0]);

		for (int iy =0 ; iy < m_Width; iy++)
		{
			char tValue[50];
			sprintf(tValue,"%d",m_aValuesI[ix][iy]);
			strcpy(TruncValues[iy],tValue);
			TruncValues[iy][ValueSpace-1] = '\0';
			int Spacing = ValueSpace - strlen(TruncValues[iy]);
			char Tempo[50];
			memset(Tempo,' ',Spacing);
			Tempo[Spacing] = '\0';
			strcat(Tempo,TruncValues[iy]);
			strcpy(TruncValues[iy],Tempo);

			RECT Rect;
			Rect.left = Offset.x;
			Rect.right = Offset.x+EntryWidth + ValueWidth*(iy);
			Rect.top = Offset.y;
			Rect.bottom = Offset.y + YSpacing;
			pDC->DrawText(TruncValues[iy],-1,&Rect,DT_RIGHT);		
			
		}
		Offset.y+= YSpacing;
	
	}
}

void DisplayTable::EnterTitle(char *pBuffer)
{
	strcpy(m_Title,pBuffer);

}

void DisplayTable::EnterDesc(char *pBuffer1, char *pBuffer2)
{
	strcpy(m_Desc[0],pBuffer1);
	strcpy(m_Desc[1],pBuffer2);
}

void DisplayTable::EnterDesc(char *pBuffer1, char *pBuffer2, char *pBuffer3)
{
	strcpy(m_Desc[0],pBuffer1);
	strcpy(m_Desc[1],pBuffer2);
	strcpy(m_Desc[2],pBuffer3);
}

void DisplayTable::EnterValue(char *ValueName, int Value)
{
	strcpy(m_aNames[m_NumEntries],ValueName);
	m_aValuesI[m_NumEntries][0] = Value;
	m_NumEntries++;

}

void DisplayTable::EnterValue(char *ValueName, int Value, int Value2)
{
	strcpy(m_aNames[m_NumEntries],ValueName);
	m_aValuesI[m_NumEntries][0] = Value;
	m_aValuesI[m_NumEntries][1] = Value2;
	m_NumEntries++;

}

void DisplayTable::SetWidth(int Width)
{
	m_Width = Width;
}
