// GraphDisplay.cpp : implementation file
//

#include "stdafx.h"
#include "ProtocalSim.h"
#include "GraphDisplay.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// GraphDisplay

GraphDisplay::GraphDisplay()
{
	m_Size.x = 200;
	m_Size.y = 200;

	m_BorderOffset.x = 10;
	m_BorderOffset.y = 10;
	
	for (int ix = 0; ix < MAXPIXELS; ix++)
		m_aValues[ix] = 0.0f;
	m_XScale = 2000.0f;
	m_YScale = 100.0f;

	m_bValid = false;
	m_PrevValue = 0;

	FillBrush.CreateSolidBrush(RGB(255,255,255));
}

GraphDisplay::~GraphDisplay()
{
}


BEGIN_MESSAGE_MAP(GraphDisplay, CWnd)
	//{{AFX_MSG_MAP(GraphDisplay)
	ON_WM_CHAR()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// GraphDisplay message handlers

//============================================================================
// void SetValue(float XAxis, float YAxis)
//
// Adds a value to the graph
// ALgorithm
//   We only want to add a value and scroll it across if the XAxis value
//   Is suffieceint far away from the prev value.  So we calculate it
//   1) If the new value is just enough far away, we scroll the graph and add the
//      new value
//   2) If the new value is more then 1 pixel away we scroll the graph and interprolate
//      the value in between
//   3) Three the value is not large enough so we just ignore
//============================================================================
void GraphDisplay::SetValue(float XAxis, float YValue)
{
	float MinDiff = m_XScale/m_Size.x;
	if (m_PrevValue + MinDiff > XAxis)
		return;
	
	// k now see how many pixels we can allocate
	int nPixels = (int)((XAxis - m_PrevValue)/MinDiff);
	ASSERT(nPixels > 0);
	if (nPixels > 20)
		int adf = 23;
	// scroll the array by this ammount
	for (int ix = 0; ix < m_Size.x - nPixels; ix++)
	{
		m_aValues[ix] = m_aValues[ix+nPixels];
	}

	// k now add the new values
	if (nPixels == 1)
		m_aValues[m_Size.x-1] = YValue;
	else
	{
		// linear interpolate
		int StartingValue = m_Size.x - nPixels;
		ASSERT(StartingValue - 1 > 0);
		float PrevValue = m_aValues[StartingValue - 1];
		for (int ix = 0; ix < nPixels; ix++)
		{
			float Percent = (float)(ix+1)/(float)nPixels;
			float Range = YValue - PrevValue;
			m_aValues[ix + StartingValue] = PrevValue + Range*Percent;
		}
	}

	m_PrevValue = XAxis;





}

//============================================================================
// void InitDisplay(CPoint GraphSize, CWnd *Parent)
//
// should be called before anything else to init it (create window)
//
//============================================================================
void GraphDisplay::InitDisplay(CPoint GraphSize, CWnd *Parent)
{
	m_Size = GraphSize;

	char windowname[100]; 

     strcpy(windowname,
		 AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		    ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Set the window's initial style
    DWORD m_dwWindowStyle = WS_BORDER|
                      WS_VISIBLE ;//| WS_CHILD ;


	int ExtraY = GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYFRAME)*2;
	int ExtraX = GetSystemMetrics(SM_CXFRAME)*2;

	CRect WindowRect;
	WindowRect.top = 0;
	WindowRect.left = 0;
	WindowRect.right = GraphSize.x + m_BorderOffset.x*2;
	WindowRect.bottom = GraphSize.y  + m_BorderOffset.y*2;
	
		 
		

    if (!CreateEx(WS_EX_TOPMOST,windowname,"GraphWindow",m_dwWindowStyle,WindowRect,NULL,NULL,NULL))
		return;

	CRect ClientRect;
	GetClientRect(&ClientRect);

	int DeltaX = ClientRect.Width() - WindowRect.Width();
	int DeltaY = ClientRect.Height() - WindowRect.Height();
	MoveWindow(0,0,WindowRect.Width() - DeltaX, WindowRect.Height() - DeltaY,true);

	m_bValid = true;

	ShowWindow(SW_HIDE);
	m_Visible = false;

}

void GraphDisplay::ToggleDisplay()
{

	if (m_Visible)
	{
		m_Visible = false;
		ShowWindow(SW_HIDE);
	}
	else
	{
		m_Visible = true;
		ShowWindow(SW_SHOW);
	}
}

void GraphDisplay::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	if (nChar == 'g')
		ToggleDisplay();
	CWnd::OnChar(nChar, nRepCnt, nFlags);
}

void GraphDisplay::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// clear the window first
	CRect FillRect;
	FillRect.top = 0;
	FillRect.left = 0;
	FillRect.right = m_Size.x + m_BorderOffset.x*2;
	FillRect.bottom = m_Size.y + m_BorderOffset.y*2;
	CPoint p1 = m_BorderOffset;
	CPoint p2 = m_Size;

	dc.FillRect(&FillRect,&FillBrush);
	dc.MoveTo(p1.x,p1.y);
	dc.LineTo(p1.x,p1.y+p2.y);
	dc.LineTo(p1.x+p2.x,p1.y+p2.y);

	// draw the pixels
	int XOffset = m_BorderOffset.x;
	int iy = m_Size.y - (m_aValues[0]/m_YScale)*m_Size.y + m_BorderOffset.y;
	dc.MoveTo(XOffset,iy);
	for (int ix = 1; ix < m_Size.x; ix++)
	{		
		iy = m_Size.y - (m_aValues[ix]/m_YScale)*m_Size.y + m_BorderOffset.y;
		dc.LineTo(ix+XOffset,iy);
		//dc.SetPixel(ix + XOffset,iy,0xffff0000);/
	}



}
