// Network.cpp: implementation of the Network class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "Network.h"
#include "CSMACA.h"
#include "ServerProcess.h"
#include "TClient1.h"
#include "TServer1.h"
#include "NetworkStats.h"
#include "APProcess.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

PhysicalLayer *pPhysicalLayer;
Network *pNetwork; // for global function

 // get the ticks in milleseconds since the start of the network
ULONGLONG NGetTicks()
{
	return pNetwork->NGetTicks();
}

ULONGLONG NGetUTicks()
{
	return pNetwork->NGetUTicks();
}
	
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Network::Network()
{
	
}

Network::~Network()
{
	delete pPhysicalLayer;
	for (int ix = 0; ix < m_NumProcesses; ix++)
	{
		delete m_aProcess[ix];
	}
}

//================================================================
// void Run()
//
// Called to simulate the network running for a certain amount of time
//================================================================
void Network::Run()
{
	// first thing to do is run the physical layer
	pPhysicalLayer->Run();

	bool RunStats = false;
	if (m_PrevStatsTime - NGetTicks() >= 1000)
		RunStats = true;

	// next run all of the process (e.g)
	for (int ix = 0; ix < m_NumProcesses; ix++)
	{
		m_aProcess[ix]->Run();
	}

}

//================================================================
// int SGetSeconds()
//
// Stats function returns the sim time
//================================================================
int Network::SGetSeconds()
{
	if (pPhysicalLayer != NULL)
		return pPhysicalLayer->SGetTime();
	return 0;
}

void Network::SGetStats(PhysicalLayer::STATISTICS &Stats)
{
	if (pPhysicalLayer != NULL)
		pPhysicalLayer->SGetStats(Stats);

	// now figure out the avg wait time and the avg resend time
	Stats.n_AvgWaitTime = 0;
	Stats.n_AvgResends = 0;
	Stats.n_AvgSent = 0;
	Stats.n_AvgMissed = 0;
	Stats.n_AvgDropped = 0;
	for (int ix =0 ; ix < m_NumProcesses; ix++)
	{
		float tAvgWaitTime,tAvgResends,tMissed,tDropped,tSend;
		m_aProcess[ix]->GetStats(tAvgWaitTime,tAvgResends,tSend,tMissed,tDropped);
		Stats.n_AvgWaitTime += tAvgWaitTime;
		Stats.n_AvgResends += tAvgResends;
		Stats.n_AvgSent += tSend;
		Stats.n_AvgMissed += tMissed;
		Stats.n_AvgDropped += tDropped;
	}

	Stats.n_AvgWaitTime = Stats.n_AvgWaitTime/m_NumProcesses;
	Stats.n_AvgResends = Stats.n_AvgResends/m_NumProcesses;
	Stats.n_AvgSent = Stats.n_AvgSent/m_NumProcesses;
	Stats.n_AvgMissed = Stats.n_AvgMissed/m_NumProcesses;
	Stats.n_AvgDropped = Stats.n_AvgDropped/m_NumProcesses;



}

ULONGLONG prevValue = 0;
//================================================================
// DWORD NGetTicks()
//
// Get the MS ticks since the start of the network mostly from the physical layer
//================================================================
ULONGLONG Network::NGetTicks()
{
	ULONGLONG tReturn;
//	ASSERT(75409390 != pPhysicalLayer->m_USecondsTicks && pPhysicalLayer->m_USecondsTicks != 75409374);
//	ASSERT (pPhysicalLayer->m_USecondsTicks >= prevValue);
	prevValue = pPhysicalLayer->m_USecondsTicks;
//	ASSERT(75409390 != prevValue && prevValue != 75409374);
	tReturn = pPhysicalLayer->m_USecondsTicks/1000;
	return tReturn;

}


//================================================================
// unsigned long NGetUTicks()
//
// Get the U ticks since the start of the network mostly from the physical layer
//================================================================
ULONGLONG Network::NGetUTicks()
{
//	ASSERT (pPhysicalLayer->m_USecondsTicks >= prevValue);
	prevValue = pPhysicalLayer->m_USecondsTicks;
//	ASSERT(75409390 != prevValue && prevValue != 75409374);
	return pPhysicalLayer->m_USecondsTicks;
}

//================================================================
// void SetupNetwork()
//
// Configures the network to run in batch testing
// virutal function does nothing, configs the network though in real life
//================================================================
void Network::SetupNetwork()
{
	for (int ix = 0; ix < m_NumProcesses; ix++)
	{
		m_aProcess[ix]->OnStart();
	}	
}


//================================================================
// void RunNextTest()
//
// Called to run the next test
//
// returns true if we should keep on running false to stop and save info
//================================================================
bool Network::RunNextTest()
{
	// first save the stats
//	m_bReady = false;


	if (m_nSaveStats < m_NumMultiRuns)
	{
		m_nSaveStats++;
		g_NetworkStats.ArchiveStats();

		// now delete everything
		for (int ix = 0; ix < m_NumProcesses; ix++)
		{
			delete m_aProcess[ix];
		}
		m_NumProcesses = 0;

		pPhysicalLayer->Reset();

	
		// now recreate everything
		SetupNetwork();
	//	m_bReady = true;
		return true;
	}
	else
	{
	//	g_NetworkStats.ArchiveStats();
		g_NetworkStats.ArchiveStats(false);
		SaveNetworkStats();
	//	m_bReady = true;
		return false;
	}

	

}

//================================================================
// void SaveNetworkStats()
//
// Save the stats to a file
// virtual function, base does nothing
//================================================================
/*void Network::SaveNetworkStats()
{

}*/

//================================================================
// void CanDraw()
//
// return false if busy
//================================================================
bool Network::CanDraw()
{
	return m_bReady;
}

//================================================================
// void RunTestingCycle()
//
// This function is run by the main thread.  It allows the network to 
// do a testing run, e.g change the config of the network and returns
// false is the network is done its current run
//================================================================
bool Network::RunTestingCycle()
{
	if (TType == ContRun)
	{
		return true;
	}
	else if (TType == MultiRun)
	{
		if (SGetSeconds() > RunsPerRun)
		{		
			return RunNextTest();	
		}

		return true;
	}
	return false;
}

//================================================================
// int DNSGetIPAddress(char *&Name)
//
// Gets a unique IP address for a given name, if the name is the same
// then append a number to it.
//================================================================
int Network::DNSGetIPAddress(char *&Name)
{
	bool NotFound = true;
	char tName[200];
	int Counter = 0;
	strcpy(tName,Name);
	while (NotFound)
	{
		ASSERT(Counter < 100);
		if (DNSFindAddress(tName) != -1)
		{
			Counter++;
			sprintf(tName,"%s%d",Name,Counter);
			
		}
		else
			NotFound = false;
	}
	for (int ix = 0; ix < MAXPROCESS; ix++)
	{
		if (ix != ACCESSPOINTIP)
		{
			if (m_aDNSAddress[ix].Valid == false)
			{
				strcpy(m_aDNSAddress[ix].Name,tName);
				m_aDNSAddress[ix].IPAddress = ix; // redundant I guess for now
				m_aDNSAddress[ix].Valid = true;
				strcpy(Name,tName); // in case name was changed
				return ix;
			}
		}
	}
	return -1;
}

//================================================================
// int DNSGetIPAddress(char *&Name)
//
// Finds the IP address for a given name, if the name is the same
// then append a number to it.
//================================================================
int Network::DNSFindAddress(char *Name)
{
	for (int ix = 0; ix < MAXPROCESS; ix++)
	{
		if (m_aDNSAddress[ix].Valid == true)
		{
			if (!strcmp(m_aDNSAddress[ix].Name,Name))
			{
				return ix;
			}			
		}
	}
	return -1;

}

//================================================================
// void Init()
//
// Does all of the initialization
//================================================================
void Network::Init()
{
	srand( (unsigned)time( NULL ) );

	pPhysicalLayer = new CSMACA;
	pNetwork = this;
	m_NumProcesses = 0;
	m_nSaveStats = 0;
	m_bReady = true;

	RunsPerRun = 100;
	m_PrevStatsTime = 0;
//	TType = ContRun;

	for (int ix = 0; ix < MAXPROCESS; ix++)
	{
		m_aDNSAddress[ix].Valid = false;
	}

	SetupNetwork();
}
