#ifndef NETWORKDEF_H
#define NETWORKDEF_H

#define BITRATE 11000000
#define MAXRESEND 16 // maximum number of resends
#define MAXNUMPACKETS 50 // maximum number of packets the OS/NIC can store
#define MESSAGEDROPPED 01 // message has been dropped

#define MAXBUFFERS 10 // incoming maximum amount of buffers

#define MAXSOCKET 10 // maximum amount of sockets per OS

#define IPTYPE int
#define MACTYPE int
#define BROADCASTIP 255 // the IP used to specify broadcast
#define BROADCAST 0x0001 // used for set socket options

#define MINISLOTTIME 52 // the minislot time for CDMA-CD
#define DIFFUTICKSBITRATE 11 // the amount of ticks per uSecond
#define MAXNIC 100 // maximum amount of nics per physical layer
#define NOMESSAGETOSEND -1 // a very long time, the return of a nic when it has nothing to send

#define PACKETSIZE 1478 // the payload portion of the packet size
#define EXTRAPACKETSTUFF 80 // the extra size just used for array definitions
#define MAXPACKETSIZE (PACKETSIZE+EXTRAPACKETSTUFF)
#define MAXPACKETS 200 // the maximu packets per single message
#define MAXMESSAGESIZE PACKETSIZE*MAXPACKETS // the maximum data per packet

#define RTSFrame 01
#define CTSFrame 02
#define ACKFrame 03
#define DataFrame 04
#define FRAMECONTROL int

// to determine if the message is from the AP or from a device for AP routing
#define FROMDS 1 // from the distrubution system
#define TODS 0 // to the distribution system (for distribution)

#define ACCESSPOINTIP 10000 // fixed IP note no other process should have this one

#define BER 1000000 // 1/BER is the prob per bit
#define PHYPREABLE 0 // number of preambe bits per frame

#define PHYPREABLEB 0 // number of preambe bits per frame

//CSMA-CA Stuff
#define SIFS 28 // Short Inter frame Space is 28uS
#define SLOTTIME 50 // slot time for CSMA is 50 us
#define PIFS (SIFS+SLOTTIME) // Point Coordination is used by the access point to gain control
#define DIFS (PIFS+SLOTTIME) // Distributed IFS packet contention could start here

typedef enum InterFraceSpaces {SIFSFrame, PIFSFrame,DIFSFrame};

#endif