// OS.h: interface for the OS class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OS_H__ACC995F6_1D18_448C_B8DA_8F86D82F121F__INCLUDED_)
#define AFX_OS_H__ACC995F6_1D18_448C_B8DA_8F86D82F121F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "NetworkDef.h"
#include "NIC.h"
#include "Packets.h"
#include "Process.h"
#include "IncomingBuffer.h"




class Process;

struct SOCKET
{

	IPINFO IPInfo;
	bool Free;

	IncomingBuffer Buffer;

	// call backs to be loaded with functions
	Process *pProcess;
};

class NIC;

class OS  
{
public:
	

	// interal function
	bool SocketIsValid(int SockIndex);


	// called by the nic, event handling
	void OnPacketSent(LANINFO LanInfo,IPINFO IPInfo);
	void SendData(char *Buffer, int &nBytes);
	

	struct OSSTATS
	{		
		int n_AvgWaitTime;
		int n_nSentPackets;
		int n_NumDroppedPackets;	
		float n_AvgResendTime; // packets that are confirmed to be sent out
		int n_NumPackQueueFull; // can't send out because nic is full of data
	} OSStats;
	void GetStats(OSSTATS& OSStats);

	void Init(char *&ProcessName, bool m_bIsAccessPoint = false);
	void SetSockOpt(int Socket, int Option);

	// OS Style Functions
	bool Send(int Socket, char *lpBuf, int nBufLen);
	bool SendTo(int Socket, int DestIP, char *lpBuf, int nBufLen);
	int CreateSocket(int PortNumber, SOCKETTYPE SocketType, Process *pProcess = NULL);
	int Receive(int Socket, char *lpBuf, int nBufLen);

	// OS Data
	SOCKET *m_pSockets[MAXSOCKET];
	IPTYPE m_IPAddress;
	Packets Packetizer;

	NIC *m_NIC;

	OS();
	virtual ~OS();

};

#endif // !defined(AFX_OS_H__ACC995F6_1D18_448C_B8DA_8F86D82F121F__INCLUDED_)
