// OutgoingQueue.cpp: implementation of the OutgoingQueue class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "OutgoingQueue.h"
#include "Network.h"
#include "NetworkStats.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OutgoingQueue::OutgoingQueue()
{
	m_StartQueue = m_EndQueue = 0;
	b_DataQueue = false;

}

OutgoingQueue::~OutgoingQueue()
{

}

//=========================================================
// bool QueueEmpty()
//
// return true if the queue is empty
//
//=========================================================
bool OutgoingQueue::QueueEmpty()
{
	if (m_StartQueue == m_EndQueue)
		return true;

	return false;

}

//=========================================================
// void GetData(char *&pBuffer, int &nBytes);
//
// Gets data from the queue
//
//=========================================================
void OutgoingQueue::GetData(char *&pBuffer, int &nBytes, bool DontIncrement)
{
	if (QueueEmpty())
	{
		nBytes = 0;
		return;
	}
	memcpy(pBuffer,m_aPackets[m_StartQueue],m_aNumBytes[m_StartQueue]*sizeof(char));
	nBytes = m_aNumBytes[m_StartQueue];

	if (!DontIncrement)
	{
		m_StartQueue++;
		if (m_StartQueue >=MAXNUMPACKETS)
			m_StartQueue = 0;

		if (b_DataQueue)
		{
			g_NetworkStats.PhyLayerStats.tWaitTimes += NGetUTicks() - m_PacketReadyToSendTime;
			m_PacketReadyToSendTime = NGetUTicks();
			g_NetworkStats.PhyLayerStats.nWaitTimes++;
		}
	}



}

//=========================================================
// bool PeakData(char *&pBuffer, int &nBytes)
//
// Peak at the data but don't copy it out
//
//=========================================================
void OutgoingQueue::PeakData(char *&pBuffer, int &nBytes)
{
	if (QueueEmpty())
	{
		nBytes = 0;
		return;
	}

	pBuffer = m_aPackets[m_StartQueue];
	nBytes = m_aNumBytes[m_StartQueue];
}

//=========================================================
// bool AddData(char *pBuffer, int nBytes)
//
// add data into the queue, returns false if the queue is full
//
//=========================================================
int OutgoingQueue::AddData(char *pBuffer, int nBytes)
{
	int tNextEnd = m_EndQueue + 1;
	if (tNextEnd >= MAXNUMPACKETS)
		tNextEnd = 0;

	if (tNextEnd == m_StartQueue)
	{
		return QUEUEFULL;
	}

	// k we can add it do so then
	ASSERT(nBytes < MAXPACKETSIZE);
	memcpy(m_aPackets[m_EndQueue],pBuffer,nBytes*sizeof(char));
	m_aNumBytes[m_EndQueue] = nBytes;	


	// if there is nothing in the queue then reset the time etc.
	if (m_StartQueue == m_EndQueue)
	{		
		if (b_DataQueue)
			m_PacketReadyToSendTime = NGetUTicks();
		m_EndQueue = tNextEnd;
		return QFIRSTENTRY;	
	}

	m_EndQueue = tNextEnd;
	return QNORMAL;


}

//=========================================================
// void AdvanceQueue()
//
// Advance the queue one
//
//=========================================================
void OutgoingQueue::AdvanceQueue()
{
	m_StartQueue++;
	if (m_StartQueue >=MAXNUMPACKETS)
		m_StartQueue = 0;

	if (b_DataQueue)
	{
		g_NetworkStats.PhyLayerStats.tWaitTimes += NGetUTicks() - m_PacketReadyToSendTime;
		g_NetworkStats.PhyLayerStats.nWaitTimes++;
		m_PacketReadyToSendTime = NGetUTicks();
	}

}
