// OutgoingQueue.h: interface for the OutgoingQueue class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OUTGOINGQUEUE_H__0E13E1F6_1BBB_43A1_8C15_15EDC0EA2B8A__INCLUDED_)
#define AFX_OUTGOINGQUEUE_H__0E13E1F6_1BBB_43A1_8C15_15EDC0EA2B8A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "NetworkDef.h"

#define QUEUEFULL 1
#define QFIRSTENTRY 2
#define QNORMAL 3

class OutgoingQueue  
{
public:

	// advance the queue, e.g a packet has been succefully sent
	void AdvanceQueue();

	// add data
	int AddData(char *pBuffer, int nBytes);
	// get the data and copy it out, increment the queue depending on dontincrement
	void GetData(char *&pBuffer, int &nBytes, bool DontIncrement = false);
	// peak at the data but don't copy is out
	void PeakData(char *&pBuffer, int &nBytes);

	bool QueueEmpty();

	// the data members
	char m_aPackets[MAXNUMPACKETS][MAXPACKETSIZE];
	int m_aNumBytes[MAXNUMPACKETS];
	bool b_DataQueue;
	ULONGLONG m_PacketReadyToSendTime; // to generate stats
	int m_StartQueue;
	int m_EndQueue;

	OutgoingQueue();
	virtual ~OutgoingQueue();

};

#endif // !defined(AFX_OUTGOINGQUEUE_H__0E13E1F6_1BBB_43A1_8C15_15EDC0EA2B8A__INCLUDED_)
