// Packets.cpp: implementation of the Packets class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "Packets.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Packets::Packets()
{
	m_LastPacket = 0;
	m_MessageNumber = 0;
}

Packets::~Packets()
{

}

//============================================================
// LoadPackets(char *pBuffer, int MessageSize)
//
// Load the packet chain given a message, called by a socket call
//
// returns false is the number of bytes is too large
//============================================================
bool Packets::LoadPackets(char *pBuffer, int nBytes, IPINFO IPInfo, FRAMECONTROL DataType)
{
	if (nBytes > MAXMESSAGESIZE)
		return false;

	// k load the packets up
	m_LastPacket = 0;
	int mIndex = 0;	

	LANINFO LanInfo;
	if (IPInfo.DestIP == BROADCASTIP)
		LanInfo.LanType = BroadcastType;
	else
		LanInfo.LanType = ConnectionType;

	// derive the LanInfo from the IPInfo	
	if (IPInfo.SourceIP != ACCESSPOINTIP)
	{
		LanInfo.SourceMac = IPInfo.SourceIP;
		LanInfo.DestMac = ACCESSPOINTIP;
		LanInfo.TrueDestMac = IPInfo.DestIP;
		LanInfo.DSFlags = TODS;
	}
	else
	{
		LanInfo.SourceMac = IPInfo.SourceIP;
		LanInfo.DestMac = IPInfo.DestIP;
		if (LanInfo.LanType == BroadcastType)
			LanInfo.TrueDestMac = BROADCASTIP;
		else
			LanInfo.TrueDestMac = IPInfo.DestIP;
		LanInfo.DSFlags = FROMDS;
	}



	LanInfo.FrameControl = DataType;
	IPInfo.MessageNumber = m_MessageNumber;
	m_MessageNumber++;
	// arbitrary
	if (m_MessageNumber > 10000)
		m_MessageNumber= 0;

	while (nBytes > 0)
	{
		int nCopyBytes = PACKETSIZE;
		IPInfo.bLastPacket = FALSE;
		if (nCopyBytes > nBytes)
		{
			nCopyBytes = nBytes;
			IPInfo.bLastPacket = TRUE;
		}

		char *tBuffer = m_aPacket[m_LastPacket];
		IPInfo.PacketIndex = m_LastPacket;			



		g_Protocals.L0CatInfo(tBuffer,LanInfo);
	//	char *oldBuffer = tBuffer;
		g_Protocals.L1CatInfo(tBuffer,IPInfo);		
	//	IPINFO IPInfo2;
	//	g_Protocals.L1GetInfo(oldBuffer,IPInfo2);

		memcpy(tBuffer,pBuffer + mIndex,nCopyBytes);

		m_PacketSize[m_LastPacket] = nCopyBytes +
			g_Protocals.L1GetHeaderSize() + g_Protocals.L0GetHeaderSize();
		mIndex += nCopyBytes;
		nBytes -= nCopyBytes;
		m_LastPacket++;
	}
	m_CurrentPacket = 0;
	return true;

}

//============================================================
// GetNextPacket(char *pBuffer, int &nBytes)
//
// called by the physical layer call to get bytes to send
//
// returns false if last packet in the message chain
//============================================================
bool Packets::GetNextPacket(char *&pBuffer, int &nBytes)
{
//	ASSERT(m_CurrentPacket <m_LastPacket);
	if (m_CurrentPacket == m_LastPacket)
		return false;
	pBuffer = m_aPacket[m_CurrentPacket];
	nBytes = m_PacketSize[m_CurrentPacket];
	m_CurrentPacket++;
	ASSERT(nBytes > 0);

	return true;
}
