// Process.cpp: implementation of the Process class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "Process.h"
#include "Network.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Process::Process()
{
	strcpy(m_ProcessName,"NeedAName");
	m_pOS = new OS;
	m_bIsAccessPoint = false;

}

Process::~Process()
{
	delete m_pOS;
}

//====================================================
// void Init()
//
// Base init function
//====================================================
void Process::Init()
{
	char *tPtr = m_ProcessName;
	m_pOS->Init(tPtr,m_bIsAccessPoint);
}

//====================================================
// void Init()
//
// Base init function
//====================================================
void Process::Run()
{
}

//====================================================
// void uSleep(int MicroSeconds)
//
// Sleeps the process for a certain amount of time
//====================================================
void Process::uSleep(int MicroSeconds)
{

}


//====================================================
// void UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size)
//
// User override to draw extra stuff
//====================================================
void Process::UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size)
{
	return;
}
//====================================================
// void DrawStats(CDC *pDC, CPoint Offset)
//
// Draw the stats of this process on the screen
//====================================================
void Process::DrawStats(CDC *pDC, CPoint &Offset)
{
	int YOffset = Offset.y+5;

	pDC->TextOut(Offset.x+2,YOffset,m_ProcessName);
	unsigned int tLength = 0;

	char tempo[400];
	YOffset += 15;

	OS::OSSTATS OSStats;
	m_pOS->GetStats(OSStats);

	sprintf(tempo,"Avg Wait Time in uS: %d   AvgResendTime: %5.2f "
		,OSStats.n_AvgWaitTime,OSStats.n_AvgResendTime);
	pDC->TextOut(Offset.x+2,YOffset,tempo);
	if (strlen(tempo) > tLength)
		tLength = strlen(tempo);
	YOffset += 15;

	sprintf(tempo,"Sent: %d   Dropped: %d  Missed: %d   "
		,OSStats.n_nSentPackets,OSStats.n_NumDroppedPackets,OSStats.n_NumPackQueueFull);
	pDC->TextOut(Offset.x+2,YOffset,tempo);
	YOffset += 15;
	if (strlen(tempo) > tLength)
		tLength = strlen(tempo);

	CPoint Size;
	Size.x = tLength*7;
	Size.y = YOffset;

	UserDrawStats(pDC,Offset,Size);

	RECT FRect;
	FRect.top = Offset.y;
	FRect.bottom = Size.y + 5;
	FRect.left = Offset.x;
	FRect.right =  Size.x + 5;
	pDC->DrawEdge(&FRect,EDGE_RAISED,BF_RECT);

	Offset.y = Size.y;

	ASSERT(tLength < 200);


}



//====================================================
// void GetStats(float &AvgWaitTime, float &AvgResends)
//
// Get the stats
// ttemp call though
//====================================================
void Process::GetStats(float &AvgWaitTime, float &AvgResends, float &SendPackets, float &MissedPackets, float &DroppedPackets)
{
	OS::OSSTATS OSStats;
	m_pOS->GetStats(OSStats);

	AvgWaitTime = (float)OSStats.n_AvgWaitTime;
	AvgResends = (float)OSStats.n_AvgResendTime;
	SendPackets = (float)OSStats.n_nSentPackets;
	DroppedPackets = (float)OSStats.n_NumDroppedPackets;
	MissedPackets = (float)OSStats.n_NumPackQueueFull;
}

void Process::OnMessageSent(int Port)
{}