// Process.h: interface for the Process class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROCESS_H__C463F84D_FEB4_4C3A_B840_B65FF82900C9__INCLUDED_)
#define AFX_PROCESS_H__C463F84D_FEB4_4C3A_B840_B65FF82900C9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// a process or device that uses a network
#include "NetworkDef.h"
#include "OS.h"


class OS;



class Process  
{
public:
	// should be overridden
	virtual void OnMessageReceived(int SourceIP, int Port){};
	virtual void OnMessageSent(int Port);
	virtual void OnSaveStats() {}; // called once a second to generate stats

	
	void GetStats(float &AvgWaitTime, float &AvgResends, float &SendPackets, float &MissedPackets, float &DroppedPackets);
	void DrawStats(CDC *pDC, CPoint &Offset);
	virtual void UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size);
	void uSleep(int MicroSeconds);
	virtual void Run();
	virtual void Init(); // called to do basic init (e.g setup the IP)
	virtual void OnStart() {}; // called to do stuff right before running, e.g get ip addresses
	Process();
	virtual ~Process();

	char m_ProcessName[200];

	bool m_bIsAccessPoint;

	OS *m_pOS;

};
typedef void (Process::*pt2Func)(void);

#endif // !defined(AFX_PROCESS_H__C463F84D_FEB4_4C3A_B840_B65FF82900C9__INCLUDED_)
