// Protocals.cpp: implementation of the Protocals class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "Protocals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


Protocals g_Protocals;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Protocals::Protocals()
{

}

Protocals::~Protocals()
{

}

//==========================================================
// void L1CatInfo(char *&buffer, IPINFO IPInfo)
//
// Add the L1 Header info to the buffer
//
//
//==========================================================
void Protocals::L1CatInfo(char *&buffer, IPINFO IPInfo)
{
	WRITE_DWORD(buffer,IPInfo.SourceIP);
	WRITE_DWORD(buffer,IPInfo.DestIP);
	WRITE_DWORD(buffer,IPInfo.Port);
	WRITE_DWORD(buffer,IPInfo.PacketIndex);
	WRITE_DWORD(buffer,IPInfo.MessageNumber);
	WRITE_DWORD(buffer,IPInfo.bLastPacket);
	WRITE_DWORD(buffer,IPInfo.SocketType);
	
}

//==========================================================
// void L1GetInfo(char *&buffer, IPINFO IPInfo)
//
// Get the L1 Header from the buffer//
//
//==========================================================
void Protocals::L1GetInfo(char *&buffer, IPINFO &IPInfo)
{
	DWORD tempo;

	READ_DWORD(buffer,IPInfo.SourceIP);
	READ_DWORD(buffer,IPInfo.DestIP);
	READ_DWORD(buffer,IPInfo.Port);	
	READ_DWORD(buffer,IPInfo.PacketIndex);
	READ_DWORD(buffer,IPInfo.MessageNumber);
	READ_DWORD(buffer,IPInfo.bLastPacket);
	READ_DWORD(buffer,tempo);
	IPInfo.SocketType = (SOCKETTYPE)tempo;
}

//==========================================================
// int L1GetHeaderSize
//
// return the size of the header
//
//==========================================================
int Protocals::L1GetHeaderSize()
{
	return sizeof(DWORD)*7;
}

//==========================================================
// int L0GetHeaderSize
//
// return the size of the header
//
//==========================================================
int Protocals::L0GetHeaderSize()
{
	return sizeof(DWORD)*6;
}

//==========================================================
// void L0CatInfo(char *&buffer, LANINFO IPInfo)
//
// Add the L0 Header info to the buffer
//
//==========================================================
void Protocals::L0CatInfo(char *&buffer, LANINFO IPInfo)
{
	WRITE_DWORD(buffer,IPInfo.FrameControl);
	WRITE_DWORD(buffer,IPInfo.SourceMac);
	WRITE_DWORD(buffer,IPInfo.DestMac);
	WRITE_DWORD(buffer,IPInfo.TrueDestMac);
	WRITE_DWORD(buffer,IPInfo.LanType);
	WRITE_DWORD(buffer,IPInfo.DSFlags);

}

//==========================================================
// void L0GetInfo(char *&buffer, LANINFO IPInfo)
//
// Get the L0 Header info to the buffer
//
//
//==========================================================
void Protocals::L0GetInfo(char *&buffer, LANINFO &IPInfo)
{
	DWORD tempo;

	READ_DWORD(buffer,IPInfo.FrameControl);
	READ_DWORD(buffer,IPInfo.SourceMac);
	READ_DWORD(buffer,IPInfo.DestMac);
	READ_DWORD(buffer,IPInfo.TrueDestMac);
	READ_DWORD(buffer,tempo);
	IPInfo.LanType = (LANTYPE)tempo;
	READ_DWORD(buffer,IPInfo.DSFlags);
	
}


//==========================================================
// void L0CatRTSInfo(char *&buffer, LANINFO IPInfo)
//
// Create a RTS packet
//==========================================================
void Protocals::L0CatRTSInfo(char *&buffer, LANINFO &LanInfo, bool fromDS)
{
	LanInfo.FrameControl = RTSFrame;
	WRITE_DWORD(buffer,LanInfo.FrameControl);
	WRITE_DWORD(buffer,LanInfo.SourceMac);
	WRITE_DWORD(buffer,LanInfo.DestMac);
	WRITE_DWORD(buffer,LanInfo.TrueDestMac);
	WRITE_DWORD(buffer,LanInfo.LanType);
	if (fromDS)
		LanInfo.DSFlags = FROMDS;
	else
		LanInfo.DSFlags = TODS;
	WRITE_DWORD(buffer,LanInfo.DSFlags);

}
//==========================================================
// void L0CatCTSInfo(char *&buffer, LANINFO IPInfo)
//
// Create a CTS packet
//==========================================================
void Protocals::L0CatCTSInfo(char *&buffer, LANINFO &LanInfo)
{
	LanInfo.FrameControl = CTSFrame;
	// reverse the source and dest
	MACTYPE tAddress;
	tAddress = LanInfo.SourceMac;
	LanInfo.SourceMac = LanInfo.DestMac;
	LanInfo.DestMac = tAddress;
	WRITE_DWORD(buffer,LanInfo.FrameControl);
	WRITE_DWORD(buffer,LanInfo.SourceMac);
	WRITE_DWORD(buffer,LanInfo.DestMac);
	WRITE_DWORD(buffer,LanInfo.TrueDestMac);
	WRITE_DWORD(buffer,LanInfo.LanType);
	WRITE_DWORD(buffer,LanInfo.DSFlags);

}
//==========================================================
// void L0CatACKInfo(char *&buffer, LANINFO IPInfo)
//
// Create a ACK packet
//==========================================================
void Protocals::L0CatACKInfo(char *&buffer, LANINFO &LanInfo)
{
	LanInfo.FrameControl = ACKFrame;
	// reverse the source and dest
	MACTYPE tAddress;
	tAddress = LanInfo.SourceMac;
	LanInfo.SourceMac = LanInfo.DestMac;
	LanInfo.DestMac = tAddress;
	WRITE_DWORD(buffer,LanInfo.FrameControl);
	WRITE_DWORD(buffer,LanInfo.SourceMac);
	WRITE_DWORD(buffer,LanInfo.DestMac);
	WRITE_DWORD(buffer,LanInfo.TrueDestMac);	
	WRITE_DWORD(buffer,LanInfo.LanType);
	WRITE_DWORD(buffer,LanInfo.DSFlags);
}
//==========================================================
// void L0GetRTSInfo(char *&buffer, LANINFO IPInfo)
//
// Get a RTS packet Info
//==========================================================
void Protocals::L0GetRTSInfo(char *&buffer, LANINFO &LanInfo)
{
	DWORD tempo;

	READ_DWORD(buffer,LanInfo.FrameControl);
	READ_DWORD(buffer,LanInfo.SourceMac);
	READ_DWORD(buffer,LanInfo.DestMac);
	READ_DWORD(buffer,LanInfo.TrueDestMac);
	READ_DWORD(buffer,tempo);
	LanInfo.LanType = (LANTYPE)tempo;
	READ_DWORD(buffer,LanInfo.DSFlags);

}
//==========================================================
// void L0GetCTSInfo(char *&buffer, LANINFO IPInfo)
//
// Get a CTS packet Info
//==========================================================
void Protocals::L0GetCTSInfo(char *&buffer, LANINFO &LanInfo)
{
	DWORD tempo;

	READ_DWORD(buffer,LanInfo.FrameControl);
	READ_DWORD(buffer,LanInfo.SourceMac);
	READ_DWORD(buffer,LanInfo.DestMac);
	READ_DWORD(buffer,LanInfo.TrueDestMac);
	READ_DWORD(buffer,tempo);
	READ_DWORD(buffer,LanInfo.DSFlags);

	LanInfo.LanType = (LANTYPE)tempo;
}
//==========================================================
// void L0GetACKInfo(char *&buffer, LANINFO IPInfo)
//
// Get a ACK packet Info
//==========================================================
void Protocals::L0GetACKInfo(char *&buffer, LANINFO &LanInfo)
{
	DWORD tempo;

	READ_DWORD(buffer,LanInfo.FrameControl);
	READ_DWORD(buffer,LanInfo.SourceMac);
	READ_DWORD(buffer,LanInfo.DestMac);
	READ_DWORD(buffer,LanInfo.TrueDestMac);
	READ_DWORD(buffer,tempo);
	LanInfo.LanType = (LANTYPE)tempo;
	READ_DWORD(buffer,LanInfo.DSFlags);
	
}
//==========================================================
// void L0GetRTSSize(char *&buffer, LANINFO IPInfo)
//
// Get a RTS packet size
//==========================================================
int Protocals::L0GetRTSSize()
{
	return sizeof(DWORD)*6;
}
//==========================================================
// void L0GetCTSSize(char *&buffer, LANINFO IPInfo)
//
// Get a CTS packet size
//==========================================================
int Protocals::L0GetCTSSize()
{
	return sizeof(DWORD)*6;
}
//==========================================================
// void L0GetACKSize()
//
// Get a ACK packet size
//==========================================================
int Protocals::L0GetACKSize()
{
	return sizeof(DWORD)*6;
}

//==========================================================
// void GetRTPInfo(char *&buffer, RTPINFO &RTPinfo)
//
// Get the rtp info
//==========================================================
void Protocals::GetRTPInfo(char *&buffer, RTPINFO &RTPInfo)
{
	READ_LWORD(buffer,RTPInfo.TimeStamp);
	READ_DWORD(buffer,RTPInfo.FrameNumber);
}

//==========================================================
// void CatRTPInfo(char *&buffer, RTPINFO RTPInfo)
//
// Cat the RTP info
//==========================================================
void Protocals::CatRTPInfo(char *&buffer, RTPINFO RTPInfo)
{
	WRITE_LWORD(buffer,RTPInfo.TimeStamp);
	WRITE_DWORD(buffer,RTPInfo.FrameNumber);
}

//==========================================================
// void GetRTPSize()
//
// Get the rtp header size
//==========================================================
int Protocals::GetRTPSize()
{
	return sizeof(ULONGLONG) + sizeof(DWORD);
}