// StreamingNetwork.cpp: implementation of the StreamingNetwork class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "StreamingNetwork.h"
#include "VideoServerProcess.h"
#include "VideoClientProcess.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

StreamingNetwork::StreamingNetwork()
{

}

StreamingNetwork::~StreamingNetwork()
{

}

//================================================================
// void SetupNetwork()
//
// Configures the network to run in batch testing
//================================================================
void StreamingNetwork::SetupNetwork()
{

	RunsPerRun = 50; // sim done in 1 second set it as such
	TType = MultiRun;
	m_NumMultiRuns = 10;

	m_aProcess[m_NumProcesses] = new VideoServerProcess;
	m_aProcess[m_NumProcesses]->Init();
	m_NumProcesses++;

	m_aProcess[m_NumProcesses] = new VideoClientProcess;
	m_aProcess[m_NumProcesses]->Init();
	m_NumProcesses++;

	m_aProcess[m_NumProcesses] = new APProcess;
	m_aProcess[m_NumProcesses]->Init();
	m_NumProcesses++;

	Network::SetupNetwork();


}

//================================================================
// void SaveNetworkStats()
//
// Save the stats to a file
//================================================================
void StreamingNetwork::SaveNetworkStats()
{
	FILE *SaveFile = fopen("NetworkStats.txt","w+t");

	if (SaveFile == NULL)
	{
		AfxMessageBox("Can't save file");
		return;
	}



	// generate the custom stats
	char tempo[500];
	char *ptempo = tempo;
	tempo[0] = '\0';
	g_NetworkStats.GetCustomHeader(ptempo);

	fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);

	for (int ix = 0; ix <= m_nSaveStats; ix++)
	{
		tempo[0] = '\0';
		g_NetworkStats.GetCustomData(ptempo,ix);
		fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);
	}



/*	char tempo[500];
	sprintf(tempo,"RunNumber MaxBitRate DataBitRate OverHeadBitRate ErrorBitRate CollisionBitRate IdleBitRate \
		IFSBitRate eDataFrames eAvgResends eWaitTimes\n");


	
	fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);


	for (int ix = 0; ix < m_nSaveStats; ix++)
	{
		NetworkStats::PHYLAYERSTATS *PStats = &g_NetworkStats.SPhy[ix];
		
		int OverHeadBR = PStats->avgAllFrames - PStats->avgDataFrames - PStats->avgErrorFrames;
		sprintf(tempo,"%d %d %d %d %d %d ",ix+1,
			PStats->brMax, PStats->avgDataFrames,OverHeadBR,PStats->avgErrorFrames,
			PStats->avgCollisionFrames);

		fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);		

		sprintf(tempo,"%d %d %8.2f %8.2f %d\n",
			PStats->avgIdleFrames,PStats->avgIFSFrames,PStats->eDataFrames,
			PStats->eAvgResends,PStats->eWaitTime);

		fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);

		
	}*/

	fclose(SaveFile);

}