// TClient1.cpp: implementation of the TClient1 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "TClient1.h"
#include "Network.h"
#include "TServer1.h"
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TClient1::TClient1()
{
	m_FTPServerIP = -1;
	m_bOnce = false;

}

TClient1::~TClient1()
{

}

void TClient1::Init()
{
	strcpy(m_ProcessName,"FTPClient");
	// init create the socket
	Process::Init();
	m_DataSocket = m_pOS->CreateSocket(DATAPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_DataSocket,BROADCAST);
	m_ControlSocket = m_pOS->CreateSocket(CONTROLPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_ControlSocket,BROADCAST);

}


void TClient1::OnMessageReceived(int SourceIP, int Port)
{
	if (SourceIP == m_FTPServerIP && Port == DATAPORT)
	{
		// append to file
		m_CurrBufferLen += m_pOS->Receive(m_DataSocket,m_ReceiveBuffer+m_CurrBufferLen,200000);
		char tempo[200];
		sprintf(tempo,"Ack");
		m_pOS->SendTo(m_ControlSocket,m_FTPServerIP,tempo,strlen(tempo));
		// send out an ack
	}
	else if (SourceIP == m_FTPServerIP && Port == CONTROLPORT)
	{
		char tempo[200];
		m_pOS->Receive(m_ControlSocket,tempo,200);
		if (!strcmp(tempo,"EOF"))
		{
			// write out file
			FILE *tFile = fopen("ReceivedFile.jpg","w+b");
		//	FILE *tFile = fopen("ReceivedFile.txt","w+b");
			fwrite(m_ReceiveBuffer,sizeof(char),m_CurrBufferLen,tFile);
			fclose(tFile);
		}
	}

		


}

void TClient1::OnStart()
{
	m_FTPServerIP = pNetwork->DNSFindAddress("FTPServer");
}

void TClient1::Run()
{
	if (!m_bOnce)
	{
		m_bOnce = true;
		if (m_FTPServerIP != -1)
		{
			// send a request for file
			char tempo[100];
			sprintf(tempo,"Send File");
			m_CurrBufferLen = 0;
			m_pOS->SendTo(m_ControlSocket,m_FTPServerIP,tempo,strlen(tempo));			
		}
	}


}
