// TestNetwork.cpp: implementation of the TestNetwork class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "TestNetwork.h"
#include "CSMACA.h"
#include "ServerProcess.h"
#include "TClient1.h"
#include "TServer1.h"
#include "NetworkStats.h"
#include "APProcess.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TestNetwork::TestNetwork()
{

}


TestNetwork::~TestNetwork()
{

}

//================================================================
// void SetupNetwork()
//
// Configures the network to run in batch testing
//================================================================
void TestNetwork::SetupNetwork()
{

	TType = MultiRun;
	m_NumMultiRuns = 17;

//	m_nSaveStats = 0;
//	for (int ix = 0; ix <= m_nSaveStats; ix++)
//	{
		m_aProcess[m_NumProcesses] = new ServerProcess;
		m_aProcess[m_NumProcesses]->Init();
		ServerProcess *tSProcess = (ServerProcess *)m_aProcess[m_NumProcesses];
		tSProcess->SetDataRate((m_nSaveStats+1)*40000);
		m_NumProcesses++;
//	}

		m_aProcess[m_NumProcesses] = new APProcess;
		m_aProcess[m_NumProcesses]->Init();
		m_NumProcesses++;


	/*	m_aProcess[m_NumProcesses] = new TClient1;
		m_aProcess[m_NumProcesses]->Init();
		m_NumProcesses++;

			m_aProcess[m_NumProcesses] = new TServer1;
		m_aProcess[m_NumProcesses]->Init();
		m_NumProcesses++;*/

}

//================================================================
// void SaveNetworkStats()
//
// Save the stats to a file
//================================================================
void TestNetwork::SaveNetworkStats()
{
	FILE *SaveFile = fopen("NetworkStats.txt","w+t");
	char tempo[500];
	sprintf(tempo,"RunNumber MaxBitRate DataBitRate OverHeadBitRate ErrorBitRate CollisionBitRate IdleBitRate \
		IFSBitRate eDataFrames eAvgResends eWaitTimes\n");

	if (SaveFile == NULL)
	{
		AfxMessageBox("Can't save file");
		return;
	}

	fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);


	for (int ix = 0; ix < m_nSaveStats; ix++)
	{
		NetworkStats::PHYLAYERSTATS *PStats = &g_NetworkStats.SPhy[ix];
		
		int OverHeadBR = PStats->avgAllFrames - PStats->avgDataFrames - PStats->avgErrorFrames;
		sprintf(tempo,"%d %d %d %d %d %d ",ix+1,
			PStats->brMax, PStats->avgDataFrames,OverHeadBR,PStats->avgErrorFrames,
			PStats->avgCollisionFrames);

		fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);		

		sprintf(tempo,"%d %d %8.2f %8.2f %d\n",
			PStats->avgIdleFrames,PStats->avgIFSFrames,PStats->eDataFrames,
			PStats->eAvgResends,PStats->eWaitTime);

		fwrite(tempo,sizeof(char),strlen(tempo),SaveFile);

		
	}

	fclose(SaveFile);

}
