// VideoBuffer.cpp: implementation of the VideoBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "VideoBuffer.h"
#include "Protocals.h"
#include "Network.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VideoBuffer::VideoBuffer()
{
	m_BufferSize = 100;

	m_StatsSkippedFrames =0;
	m_StatsGoodFrames = 0;	
	m_HighestFrame = 0;
	m_LargestFrameDifference = 50;
	
	ResetBuffer();
	m_StatsNumResetBuffer = 0;
}

VideoBuffer::~VideoBuffer()
{

}

//====================================================
// void AddData(char *pBuffer)
//
// Add incoming data to the buffer
// This function parses the RTP header and adds the rest
// of the data to the buffer
//====================================================
void VideoBuffer::AddData(char *pBuffer)
{
	// first thing figure out the data we have
	RTPINFO RTPInfo;
	g_Protocals.GetRTPInfo(pBuffer,RTPInfo);

	if ((RTPInfo.FrameNumber - m_HighestFrame) > m_LargestFrameDifference)
	{
		ResetBuffer();
		m_HighestFrame = RTPInfo.FrameNumber;
	}
	else
	{
		if (RTPInfo.FrameNumber > m_HighestFrame)
			m_HighestFrame = RTPInfo.FrameNumber;
	}

	// search for the proper place
	int CurrFrame = m_PlayIndex;

	bool FirstFrame = false;
	// check for the just starting case
	if (CurrFrame == -1)
	{
		CurrFrame = 0;
		m_PlayIndex = 0;
		FirstFrame = true;
	}
	else
	{
		// now calculate the frame where this one is in
		// search for the next valid frame
		while (!s_VideoFrames[CurrFrame].Valid)
		{
			CurrFrame++;
			if (CurrFrame == m_BufferSize)
				CurrFrame = 0;
		}
		if (RTPInfo.FrameNumber == s_VideoFrames[CurrFrame].FrameNumber)
		{
			// duplicate frame just return
			return;
		}

		int PutFrame = RTPInfo.FrameNumber - s_VideoFrames[CurrFrame].FrameNumber;
		
		CurrFrame += PutFrame;
		int OnceOnly = 0;
		while (CurrFrame >= m_BufferSize)
		{
			CurrFrame -= m_BufferSize;
			OnceOnly++;
		}
		ASSERT(OnceOnly <= 1); // should not rap around twice unless buffer is tiny
		if (CurrFrame == m_PlayIndex)
		{
			// wehave a rap around so have play index = Currframe + 1;
			m_PlayIndex++;
			if (m_PlayIndex == m_BufferSize)
				m_PlayIndex = 0;
			s_VideoFrames[CurrFrame].Valid = false;
		}
		ASSERT(CurrFrame != m_PlayIndex);
	}

//	ASSERT(s_VideoFrames[CurrFrame].Valid == false); // buffer overrun
	s_VideoFrames[CurrFrame].FrameNumber = RTPInfo.FrameNumber;
	s_VideoFrames[CurrFrame].TimeStamp = RTPInfo.TimeStamp;
	s_VideoFrames[CurrFrame].ReceiveTime = NGetUTicks();	
	s_VideoFrames[CurrFrame].Valid = true;
	// get the time delay
	s_VideoFrames[CurrFrame].ReceiveDelay = (int)(NGetUTicks() - RTPInfo.TimeStamp);

	// copy over data here
	// memcpy(.....

	// now adjust the endplayindex and the endindex;
	bool DoneLoop = false;
	int Traverse = m_PlayIndex;
	int OldIndex = Traverse;

	// look for the endplayindex (continous buffer frames)
	while (!DoneLoop)
	{
		// keep on going until endindexhave been found
		if (!s_VideoFrames[Traverse].Valid)
		{
			DoneLoop = true;
			m_BufferEndPlayIndex = OldIndex;
		}
		else
		{
			OldIndex = Traverse;
			Traverse++;
			if (Traverse == m_BufferSize)
				Traverse = 0;
			if (Traverse == m_PlayIndex)
			{
				// we went completely around might as well consider -1 as the endplayindex
				m_BufferEndPlayIndex = OldIndex;
				DoneLoop = true;
			}
		}
	}
	// look for the bufferendindex search until going around for a valid index
	Traverse = m_PlayIndex;
	Traverse++;
	if (Traverse == m_BufferSize)
		Traverse = 0;

	// look for the endplayindex (continous buffer frames)
	while (Traverse != m_PlayIndex)
	{
		if (s_VideoFrames[Traverse].Valid)
		{			
			m_BufferEndIndex = Traverse;
		}
		Traverse++;
		if (Traverse == m_BufferSize)
				Traverse = 0;
	}

}

//====================================================
// bool GetData(char *&pBuffer)
//
// Gets the latest data from the video buffer
//
// returns false if next frame is unavailable
//====================================================
bool VideoBuffer::GetData(char *&pBuffer)
{
	if (m_PlayIndex == m_BufferEndIndex)
	{
		// we have no data available return false
		return false;
	}
	else if (s_VideoFrames[m_PlayIndex].Valid == false)
	{
		// we have a frame ready to play somewhere ahead but not here increment but don't mem cpy
		m_PlayIndex++;
		if (m_PlayIndex == m_BufferSize)
			m_PlayIndex = 0;
		m_StatsSkippedFrames++;
		return false;
	}
	else
	{
		// memcpy(......
		m_StatsGoodFrames++;
		s_VideoFrames[m_PlayIndex].Valid = false;
		m_PlayIndex++;
		if (m_PlayIndex == m_BufferSize)
			m_PlayIndex = 0;
		return true;
	}
}

//====================================================
// int GetNumFrames()
//
// Returns the number of playable frames in the video buffer
//====================================================
int VideoBuffer::GetNumFrames()
{
	int tIndex = m_PlayIndex;
	if (tIndex == -1)
		return 0;
	if (m_BufferEndIndex < tIndex)
		tIndex -= m_BufferSize;

	return m_BufferEndIndex - tIndex;
}

//====================================================
// int ResetBuffer()
//
// Reset the buffer
//====================================================
void VideoBuffer::ResetBuffer()
{	
	m_PlayIndex = -1;
	m_BufferEndIndex = 0;
	m_BufferEndPlayIndex = 0;
	for (int ix = 0; ix < MAXFRAMEBUFFERS; ix++)
	{
		s_VideoFrames[ix].FrameNumber = -1;
		s_VideoFrames[ix].TimeStamp = 0;
		s_VideoFrames[ix].Valid = false;
	}
	m_StatsNumResetBuffer++;

}
