// VideoBuffer.h: interface for the VideoBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIDEOBUFFER_H__74AA33EB_B14B_4599_B955_676655C91375__INCLUDED_)
#define AFX_VIDEOBUFFER_H__74AA33EB_B14B_4599_B955_676655C91375__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAXFRAMESIZE 50000 // a frame can be a max of 50000 bytes
#define MAXFRAMEBUFFERS 150
// the buffer for the video client
class VideoBuffer  
{
public:
	
	struct VideoFramesStruct
	{
		//char VideoFrames[MAXFRAMESIZE]; not used for now since we don't actually
									     // display video
		ULONGLONG TimeStamp;
		ULONGLONG ReceiveTime;
		int ReceiveDelay;
		int FrameNumber;
		bool Valid; // if it is valid and has not been played yet
	} s_VideoFrames[MAXFRAMEBUFFERS];

	int m_BufferSize; // the buffer size used
	int m_PlayIndex; // the index where the next play frame is
	int m_BufferEndIndex; // the index where the most foward frame is (might be discontinous)
	int m_BufferEndPlayIndex; // the index where the most foward frame is that can be play
	int m_HighestFrame; // highest frame index
	int m_LargestFrameDifference; // largest difference before reseting the buffer

	int m_StatsSkippedFrames; // number of frames played that weren't available
	int m_StatsGoodFrames; // number of frames that were played correctly	
	int m_StatsNumResetBuffer; // number of times the entire buffer was cleared
	
	bool GetData(char *&pBuffer);
	void AddData(char *pBuffer);
	int GetNumFrames();


	VideoBuffer();
	virtual ~VideoBuffer();

private:
	void ResetBuffer();
};

#endif // !defined(AFX_VIDEOBUFFER_H__74AA33EB_B14B_4599_B955_676655C91375__INCLUDED_)
