// VideoServerProcess.h: interface for the VideoServerProcess class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIDEOSERVERPROCESS_H__117C333F_231F_4830_B2CB_9C431059D48A__INCLUDED_)
#define AFX_VIDEOSERVERPROCESS_H__117C333F_231F_4830_B2CB_9C431059D48A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Process.h"
#include "NetworkDef.h"

#define VIDEODATAPORT 21
#define VIDEOCONTROLPORT 22
#define FRAMERATE 33 // in ms 1/Framerate = actual frame rate

class VideoServerProcess : public Process  
{
public:

	// virtual overrides
	void OnMessageReceived(int SourceIP, int Port);
	void OnMessageSent(int Port);
	void OnStart();
	void Run();
	void Init();
	void UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size);

	char m_SendBuffer[MAXMESSAGESIZE]; // just a dummy buffer to send messages
	bool m_ReadyToSend;
	int m_DataSocket;
	int m_ControlSocket;
	int m_SkippedSending; // if we want to send a frame but NIC not ready
						  // this should be incremented for stats

	// determines sending characteristics
	int m_SendTime;
	int m_SendIncTime;
	int m_FrameSize;
	int m_FrameNumber;

	VideoServerProcess();
	virtual ~VideoServerProcess();



};

#endif // !defined(AFX_VIDEOSERVERPROCESS_H__117C333F_231F_4830_B2CB_9C431059D48A__INCLUDED_)
