// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "Mapper.h"
#include "ChildView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{    
    ResetAllActions();
    E_SelectEnabled=true;
    E_SnapEnabled = false;

	OldScrollMousePoint.x = 0;
	OldScrollMousePoint.y = 0;



    // system resources resets
    lUsrRes = 0;
	lGdiRes = 0;
	lSysRes = 0;
    Once = false; // to kick of the timer

    LoadCursors();

    Draw.QuadTreePtr = &QuadTree;      

    Draw.FlushUndo();

    Popup.LoadMenu(IDR_POPUP);  

    SaveFileName = "";


}

CChildView::~CChildView()
{

}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(ID_ZOOM, OnZoom)
	ON_COMMAND(ID_PAN, OnPan)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_OPTIONS_ZOOMOUT, OnOptionsZoomout)
	ON_WM_SETCURSOR()
	ON_WM_TIMER()
	ON_COMMAND(ID_DRAWLINE, OnDrawline)
	ON_COMMAND(ID_SELECT, OnSelect)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_OPTIONS_DRAWINGOPTIONS, OnOptionsDrawingoptions)
	ON_COMMAND(ID_DRAWINGTOOLS_DRAWARC, OnDrawingtoolsDrawarc)
	ON_COMMAND(ID_DRAWINGTOOLS_GROUP, OnDrawingtoolsGroup)
	ON_COMMAND(ID_DRAWINGTOOLS_UNGROUP, OnDrawingtoolsUngroup)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_DRAWINGTOOLS_MOVEOBJECTS, OnDrawingtoolsMoveobjects)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_DRAWINGTOOLS_ADDDEPTH, OnDrawingtoolsAdddepth)
	ON_COMMAND(ID_DRAWINGTOOLS_ROTATE, OnDrawingtoolsRotate)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_POPUP_TOGGLEGRIDSNAP, OnPopupTogglegridsnap)
	ON_COMMAND(ID_POPUP_TOGGLEPOLARSNAP, OnPopupTogglepolarsnap)
	ON_COMMAND(ID_POPUP_TOGGLESNAPTOENDPOINT, OnPopupTogglesnaptoendpoint)
	ON_COMMAND(ID_MODELOPTIONS_ADDBUMPSENSOR, OnModeloptionsAddbumpsensor)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_COMMAND(ID_EDIT_REDO, OnEditRedo)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_MODELOPTIONS_EDITPROPERTIES, OnModeloptionsEditproperties)
	ON_COMMAND(ID_MODELOPTIONS_ADDIRSENSOR, OnModeloptionsAddirsensor)
	ON_COMMAND(ID_MODELOPTIONS_ADDSONARSENSOR, OnModeloptionsAddsonarsensor)
	ON_COMMAND(ID_FILE_SAVEWOARCS, OnFileSavewoarcs)
	ON_WM_MOUSEWHEEL()
    ON_MESSAGE(WM_SAVE_STATE, OnSaveState)
	ON_COMMAND(ID_PLACEROBOT, OnPlacerobot)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.x = 0;
    cs.y = 0;
    cs.cx = GetSystemMetrics(SM_CXFULLSCREEN);
    cs.cy = GetSystemMetrics(SM_CYFULLSCREEN);

	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
    cs.style |= WS_MAXIMIZE;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);



	return TRUE;
}


void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

    char tempo[50];

    // to time the rendering
    LARGE_INTEGER frequency,starttime,endtime;    
    ::QueryPerformanceFrequency(&frequency);
    ::QueryPerformanceCounter(&starttime);
    

    if (!Once)
    {
        SetTimer(SYSTEMRESOURCETIMER,100,NULL);
        Once = true;
        InitConsole();        
    
    }

    QuadTree.Render(dc,Draw.CurrentView,Draw.DrawingArea);

  

    ::QueryPerformanceCounter(&endtime);

    float RenderingTime = (float)(endtime.QuadPart-starttime.QuadPart)/(float)frequency.QuadPart;
    sprintf(tempo,"Rendering Time: %f",RenderingTime);
    dc.TextOut(410,70,tempo);

    sprintf(tempo,"Zoom Factor: %f%%    ",Draw.ZoomRatio);
    dc.TextOut(410,10,tempo); 

    sprintf(tempo,"System Resources: %d%%",lSysRes);
    dc.TextOut(410,25,tempo);
    sprintf(tempo,"User Resources: %d%%",lUsrRes);
    dc.TextOut(410,40,tempo);
    sprintf(tempo,"GDI Resources: %d%%",lGdiRes);
    dc.TextOut(410,55,tempo);

     /* draw the rendering stats*/
    sprintf(tempo,"RENDERING STATS");
    dc.TextOut(410,90,tempo);
    dc.MoveTo(405,105);
    dc.LineTo(550,105);

    sprintf(tempo,"Screen Shown in cm (base unit)");   
    dc.TextOut(410,110,tempo);
    sprintf(tempo,"x %d y %d Dx %d Dy %d          ",Draw.CurrentView.left,Draw.CurrentView.top,Draw.CurrentView.Width(),Draw.CurrentView.Height());   
    dc.TextOut(410,125,tempo);
    sprintf(tempo,"Number of Objects Rendered %d       ",QuadTree.RenderingStats.NRendered);
    dc.TextOut(410,140,tempo);
    sprintf(tempo,"Quadrants rendered");
    dc.TextOut(410,155,tempo);
    sprintf(tempo,"X %d to %d: Y %d to %d     ",QuadTree.RenderingStats.XQuadStart,QuadTree.RenderingStats.XQuadEnd,QuadTree.RenderingStats.YQuadStart,QuadTree.RenderingStats.YQuadEnd);
    dc.TextOut(410,170,tempo);

    int temp;
    temp = (QuadTree.RenderingStats.XQuadEnd-QuadTree.RenderingStats.XQuadStart+1)*(QuadTree.RenderingStats.YQuadEnd-QuadTree.RenderingStats.YQuadStart+1)-QuadTree.RenderingStats.NQuadRendered;
    sprintf(tempo,"Quads rendered: %d     ",QuadTree.RenderingStats.NQuadRendered);
    dc.TextOut(410,185,tempo);
    sprintf(tempo,"Quad rendering optimized out: %d     ",temp);
    dc.TextOut(410,200,tempo);

    
    CPoint QuadTreePoint = Draw.ScreentoReal(MousePoint);


    if (E_IsSelectingBox)
        QuadTree.RenderDrawRectangle(SelectingBox,dc);


    QuadTree.SelectPrintStats(dc,410,215);

    
    if (QuadTree.AddCheckifPointValid(MousePoint))
    {
        sprintf(tempo,"Mouse at (%d,%d)            ",QuadTreePoint.x,QuadTreePoint.y);
        dc.TextOut(410,350,tempo);
    }




	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}


void CChildView::OnZoom() 
{
    ResetAllActions();
	E_ZoomEnabled=true;	
    PrevCursor = CurCursor = 2;
    Draw.SetCenterCursorOffset();
}

void CChildView::OnPan() 
{
    ResetAllActions();
    E_PanEnabled=true;
    PrevCursor = CurCursor = 1;
    Draw.SetCenterCursorOffset();
  
}

void CChildView::ResetAllActions()
{
    E_SelectEnabled=false;
    E_PanEnabled=false;
    E_ZoomEnabled=false;
    E_DrawLineEnabled=false;
    E_DrawArcEnabled = false;
    LButtonDown=false;
    E_MoveObject = false;
    E_IsSelectingBox = false;
    E_BumpSensorEnabled = false;
    E_SonarSensorEnabled = false;
    E_IRSensorEnabled = false;
	E_RobotPlacementEnabled = false;
    CurCursor = 0;
    PrevCursor = 0;
    Draw.ZoomRatio = 1;
    Draw.ResetCursorOffset();   

}

void CChildView::OnMouseMove(UINT nFlags, CPoint point) 
{    

    MousePoint = point;

   // CurCursor = PrevCursor;
    // pan the view
    // so there is always the arrow when trying to scroll the log scroll bar
    if (point.y +50 > Console.ConsoleLogRect.top)
    {
        ::SetCursor( m_hCursor[0] );
    }
	if ((nFlags == MK_LBUTTON) && E_PanEnabled)
    {
        Draw.PanView(point);
       // Invalidate(false);
       // UpdateWindow();

    }
    // zoom in
    else if ((nFlags == MK_LBUTTON) && E_ZoomEnabled)
    {
        Draw.ZoomView(point);
       // Invalidate(false);
       // UpdateWindow();
      
    }
    else if ((nFlags == MK_LBUTTON) && E_IsSelectingBox)
    {
        if (point.x > Draw.DrawingArea.right)
        {
            point.x = Draw.DrawingArea.right;
        }
        else if (point.x < Draw.DrawingArea.left)
        {
            point.x = Draw.DrawingArea.left;
        }
        else
        {
            SelectingBox.right = point.x;
        }

        if (point.y > Draw.DrawingArea.bottom)
        {
            point.y = Draw.DrawingArea.bottom;
        }
        else if (point.y < Draw.DrawingArea.top)
        {
            point.y = Draw.DrawingArea.top;
        }
        else
        {
            SelectingBox.bottom = point.y;
        }

    }
    else if ((nFlags == MK_LBUTTON) && E_SelectEnabled)
    {
        Draw.OnMouseMove(point,false);
    }
    Draw.OnMouseMove(point,false); 

    Invalidate(false);
	
    Draw.PrevMousePos=point;

	CWnd ::OnMouseMove(nFlags, point);
}

void CChildView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	LButtonDown=true;
    char tempo[30];
    sprintf(tempo,"hi %d",MK_CONTROL | MK_LBUTTON );
    if (E_ZoomEnabled)
    {
        // needs to be done to have the zoom in stay on a constant center
        Draw.SetZoomCenter(point);
    }
    else if (E_DrawLineEnabled)
    {
     //   Draw.DrawLine(point,false);
        ConsoleClass.SM_Line(point);
        Invalidate(false);
    }
    else if (ConsoleClass.isRotateState())
    {
        ConsoleClass.SM_Rotate(point);
    }
    else if (E_SelectEnabled)
    {
        if (nFlags == (MK_CONTROL  | MK_LBUTTON))
        {
            Draw.SelectObject(point,false); // deselect
        }
        else
        {
            if (!Draw.SelectObject(point,true))
            {
                if ((point.x < Draw.DrawingArea.right) && (point.x > Draw.DrawingArea.left)
                    && (point.y < Draw.DrawingArea.bottom) && (point.y > Draw.DrawingArea.top))
                {
                    SelectingBox.top = SelectingBox.bottom= point.y;
                    SelectingBox.left = SelectingBox.right= point.x;
                    E_IsSelectingBox = true;
                }
            }
                // select
        }
    }
    else if (E_DrawArcEnabled)
    {
        ConsoleClass.SM_Arc(point);
    }
    else if (E_MoveObject)
    {
        ConsoleClass.SM_Move(point);
    }
    else if (E_BumpSensorEnabled)
    {
        ConsoleClass.SM_BumpSensor(point);
    }
    else if (E_IRSensorEnabled)
    {
        ConsoleClass.SM_IRSensor(point);
    }
    else if (E_SonarSensorEnabled)
    {
        ConsoleClass.SM_SonarSensor(point);
    }
    else if (E_RobotPlacementEnabled)
    {
        ConsoleClass.SM_RobotPlacement(point);
    }

 
    Draw.PrevMousePos=point;
    Invalidate(false);

	CWnd ::OnLButtonDown(nFlags, point);
}

void CChildView::OnLButtonUp(UINT nFlags, CPoint point) 
{

    if (E_IsSelectingBox)
    {
        SelectingBox.bottom = point.y;
        SelectingBox.right = point.x;
        E_IsSelectingBox = false;
        Draw.SelectBox(SelectingBox);
    }

	LButtonDown=false;
    Invalidate(false);

    Draw.OnLButtonUp();


	CWnd ::OnLButtonUp(nFlags, point);
}

void CChildView::OnOptionsZoomout() 
{
    ResetAllActions();
    E_SelectEnabled = true;
    Draw.ResetView();
    Invalidate(false);
    UpdateWindow();

    
	
}

BOOL CChildView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// TODO: Add your message handler code here and/or call default
    if (nHitTest == HTVSCROLL)
    {
        ::SetCursor( m_hCursor[0] );
    }
    else
    {
    ::SetCursor( m_hCursor[CurCursor] );
    }
    return true;
	return CWnd ::OnSetCursor(pWnd, nHitTest, message);
}


void CChildView::OnTimer(UINT nIDEvent) 
{
    if (nIDEvent == SYSTEMRESOURCETIMER)
    {
	    HINSTANCE hInst = LoadLibrary("RSRC32.dll");
	    if (hInst != NULL)
	    {
		    GETRES pGetRes = (GETRES) GetProcAddress(hInst, "_MyGetFreeSystemResources32@4");//); 

		    if (pGetRes)
		    {
			    lSysRes = (*pGetRes)(GFSR_SYSTEMRESOURCES);
			    lGdiRes = (*pGetRes)(GFSR_GDIRESOURCES);
			    lUsrRes = (*pGetRes)(GFSR_USERRESOURCES);
           	    return;
		    }
		    lSysRes = -1;
		    lGdiRes = -1;
		    lUsrRes = -1;
		    return;
	    }
	    lSysRes = -1;
	    lGdiRes = -1;
	    lUsrRes = -1;
        Invalidate(false);
        UpdateWindow();
    }

	CWnd ::OnTimer(nIDEvent);
}

void CChildView::OnDrawline() 
{
    ResetAllActions();
	E_DrawLineEnabled=true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}

void CChildView::LoadCursors()
{
        // loads cursor for drawing action
    m_hCursor[0] =::LoadCursor( NULL, IDC_ARROW );
    m_hCursor[1] = AfxGetApp( )->LoadCursor(IDC_PAN);
    m_hCursor[2] = AfxGetApp( )->LoadCursor(IDC_ZOOM);
    m_hCursor[3] = AfxGetApp( )->LoadCursor(IDC_LINE);
    m_hCursor[4] = AfxGetApp( )->LoadCursor(IDC_MOVE);
    


}

void CChildView::OnSelect() 
{
	ResetAllActions();
    E_SelectEnabled=true;
    PrevCursor = CurCursor=0;
	
}


// currently used to intercept the delete key.
BOOL CChildView::PreTranslateMessage(MSG* pMsg) 
{
	
    BOOL bHandleNow = FALSE;

    switch (pMsg->message)
    {
    case WM_KEYDOWN:
		Console.Console.SetFocus();
        switch (pMsg->wParam)
        {	
        case VK_UP:
        case VK_DOWN:
        case VK_LEFT:
        case 13: // the enter key, VK_ENTER does not exist for some reason
            bHandleNow = TRUE;
            break;
        case VK_DELETE:
            bHandleNow = TRUE;
            break;
        case VK_ESCAPE:
            bHandleNow = TRUE;
            break;
        }
        if (bHandleNow)
		{
            OnKeyDown(pMsg->wParam, LOWORD(pMsg 
                ->lParam), HIWORD(pMsg->lParam));
		}
		else
			::SendMessage(Console.Console.m_hWnd,WM_KEYDOWN 
			,pMsg->wParam,0);
		
        break;
	
	// I need to do this to get the mouse wheel to work
	case WM_MOUSEWHEEL:
		SetFocus();		
	}
    return bHandleNow;
	
	return CWnd ::PreTranslateMessage(pMsg);
}

void CChildView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd ::OnChar(nChar, nRepCnt, nFlags);
}

void CChildView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_DELETE)
    {
        Draw.DeleteSelectedObject();
        Invalidate(false);
    }
    else if (nChar == VK_ESCAPE)
    {
        ConsoleClass.CancelCommand();
        QuadTree.DraftingCancelCommand();
        Invalidate(false);
    }

    else if (nChar == 13)  // the enter key, VK_ENTER does not exist for some reason
    {
        ConsoleClass.OnEnter(Console);
        Console.Console.SetFocus();
        Invalidate(false);
    }
	
	CWnd ::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CChildView::OnOptionsDrawingoptions() 
{   
	Draw.OnDrawingOptions();
	
}

void CChildView::OnDrawingtoolsDrawarc() 
{
    ResetAllActions();
	E_DrawArcEnabled = true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}

void CChildView::OnDrawingtoolsGroup() 
{
	Draw.GroupObjects();
	
}

void CChildView::OnDrawingtoolsUngroup() 
{
	Draw.UngroupObjects();
	
}

void CChildView::OnFileSaveAs() 
{
    //static char BASED_CODE szFilter[] = "Chart Files (*.xlc)|*.xlc|Worksheet Files (*.xls)|*.xls|Data Files (*.xlc;*.xls)|*.xlc; *.xls|All Files (*.*)|*.*||";
    static char BASED_CODE szFilter[] = "Map Files (*.mpp)|*.mpp||";
 
    CFileDialog tempo(false,"*.mpp","default.mpp",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);

    if (tempo.DoModal() == IDOK)
    {
        CString FileName = tempo.GetPathName();
        QuadTree.FileSaveMap(FileName, Draw.CurrentView, false);
        SaveFileName = FileName;
    }

	
}

void CChildView::OnFileOpen() 
{
    // responsible for a -1 thread exit, nothing I could do about it.

    static char BASED_CODE szFilter[] = "Map Files (*.mpp)|*.mpp||";
	CFileDialog FileDialog(true,"*.mpp","*.mpp",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);

	       
    if (FileDialog.DoModal() == IDOK)
    {
        ResetAllActions();
        E_SelectEnabled = true;
        CString FileName = FileDialog.GetPathName();
        SaveFileName = FileName;
        Draw.CurrentView = QuadTree.FileOpenMap(FileName);
        Draw.FlushUndo();
    }





	
}

void CChildView::OnFileNew() 
{
    QuadTree._Destruct();
	QuadTree._Construct();
    Draw.FlushUndo();
    Invalidate();
	
}

void CChildView::OnDrawingtoolsMoveobjects() 
{

    ResetAllActions();
	E_MoveObject = true;
    PrevCursor = CurCursor = 4;
    Draw.SetCenterCursorOffset();
	
}

void CChildView::OnEditCopy() 
{
	Draw.CopyGroup();
    Invalidate(false);

	
}

void CChildView::OnEditPaste() 
{
    CPoint Dummy;
    Dummy.x = 0;
    Dummy.y = 0;
	Draw.PasteGroup(Dummy);
    Invalidate(false);
 
	
}

void CChildView::OnEditCut() 
{
	Draw.CutGroup();
    Invalidate(false);
    
	
}

void CChildView::InitConsole()
{
    CRect WindowRect;
    GetClientRect(&WindowRect);

    Console.ConsoleYSize = 30;
    Console.ConsoleYOffset = 1;
    Console.ConsoleLongYSize = 80;

    Console.ConsoleRect.left = Console.ConsoleLogRect.left = WindowRect.left;
    Console.ConsoleRect.right = Console.ConsoleLogRect.right = WindowRect.right;
    
    Console.ConsoleRect.bottom = WindowRect.bottom - Console.ConsoleYOffset;
    Console.ConsoleRect.top = Console.ConsoleRect.bottom - Console.ConsoleYSize; 

    Console.ConsoleLogRect.bottom = Console.ConsoleRect.top;
    Console.ConsoleLogRect.top = Console.ConsoleRect.top - Console.ConsoleLongYSize;

    Console.Console.Create(WS_CHILD | ES_MULTILINE |  ES_LEFT | WS_VISIBLE | WS_BORDER  ,Console.ConsoleRect,this,CONSOLEID);
    Console.ConsoleLog.Create(WS_CHILD | WS_EX_RIGHTSCROLLBAR     | WS_BORDER | ES_AUTOVSCROLL | ES_LEFT | ES_MULTILINE | ES_READONLY  | WS_VISIBLE,Console.ConsoleLogRect,this,CONSOLELOGID);

    Console.ConsoleLog.ShowScrollBar(SB_VERT);

    CFont temp;
    //temp.CreateFont(0,0,0,0,0,false,false,false,0,0,CLIP_CHARACTER_PRECIS,PROOF_QUALITY,FF_ROMAN,NULL);

   // Console.Console.SetFont(&temp);
    Console.Console.SetFocus();

    ConsoleClass.DrawPtr = &Draw;
    ConsoleClass.theConsole = &Console;
    ConsoleClass.ParentPtr = this;

}

int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{

	if (CWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;

    QuadTree.ParentHandle = this->m_hWnd;
	
	return 0;
}

void CChildView::OnSize(UINT nType, int cx, int cy) 
{
	CWnd ::OnSize(nType, cx, cy);

	if (Once)
    {
	    ResizeConsole();
    }
	
}

void CChildView::ResizeConsole()
{
    
    CRect WindowRect;
    GetClientRect(&WindowRect);

    Console.ConsoleRect.left = Console.ConsoleLogRect.left = WindowRect.left;
    Console.ConsoleRect.right = Console.ConsoleLogRect.right = WindowRect.right;
    
    Console.ConsoleRect.bottom = WindowRect.bottom - Console.ConsoleYOffset;
    Console.ConsoleRect.top = Console.ConsoleRect.bottom - Console.ConsoleYSize; 

    Console.ConsoleLogRect.bottom = Console.ConsoleRect.top;
    Console.ConsoleLogRect.top = Console.ConsoleRect.top - Console.ConsoleLongYSize;

    Console.Console.MoveWindow(&Console.ConsoleRect,false);
    Console.ConsoleLog.MoveWindow(&Console.ConsoleLogRect,false);

}





void CChildView::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd ::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here
	
}

void CChildView::OnFilePrint() 
{
    CPrintDialog  PrintDialog(false,PD_DISABLEPRINTTOFILE | PD_RETURNDC ,this);

    if (PrintDialog.DoModal() == IDOK)
    {
        CRect PrinterSize;
        PrinterSize.top = 10;
        PrinterSize.left = 10;
        PrinterSize.right = 2000;
        PrinterSize.bottom= 2000;
        HDC PrintHDC = PrintDialog.GetPrinterDC();   

        CDC *PrintDC;
        PrintDC = CDC::FromHandle(PrintHDC);



        DOCINFO DocInfo;
        DocInfo.cbSize = sizeof(DOCINFO);
        DocInfo.lpszDocName = "Mapper Output";
        DocInfo.lpszDatatype = NULL;
        DocInfo.lpszOutput = NULL;
        PrintDC->StartDoc(&DocInfo);
        PrintDC->StartPage();    

                  // clear the DC
        CBrush WhiteBrush(RGB(255,255,255));
        PrintDC->FillRect(&PrinterSize,&WhiteBrush); 
		QuadTree._CreatePrintPens();
        QuadTree.Render(*PrintDC,Draw.CurrentView,PrinterSize);
		QuadTree._CreateNormalPens();
        PrintDC->TextOut(0,0,"Mapper Output");
        
        Print(PrintDC,PRF_CHILDREN);   
        PrintDC->EndPage();
        PrintDC->EndDoc();
        DeleteDC(PrintHDC);

    }
	
}

void CChildView::OnDrawingtoolsAdddepth() 
{
    Console.Console.SetWindowText("Depth");
	ConsoleClass.OnEnter(Console);	
}

void CChildView::OnDrawingtoolsRotate() 
{
	Console.Console.SetWindowText("Rotate");
	ConsoleClass.OnEnter(Console);		
    PrevCursor = CurCursor = 0;
    Draw.ResetCursorOffset();
    Invalidate(false);
}

void CChildView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
    // make sure window is active
   GetParentFrame()->ActivateFrame();

   CPoint local = point;
   ScreenToClient(&local);

   UpdateWindow();

  CMenu* pPopup = Popup.GetSubMenu(0);
  ASSERT(pPopup != NULL);

  // make the check points the same as the dialog box settings
  PopupAlignChecks();

  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
     point.x, point.y,
  AfxGetMainWnd()); // use main window for cmds

	
}

void CChildView::OnPopupTogglegridsnap() 
{
	if (Draw.E_ForceGrid)
        Draw.E_ForceGrid = false;
    else
        Draw.E_ForceGrid = true;

    UINT Check;
    if (Draw.E_ForceGrid)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLEGRIDSNAP,Check);
	
}

void CChildView::OnPopupTogglepolarsnap() 
{
	if (Draw.E_ForcePolar)
        Draw.E_ForcePolar = false;
    else
        Draw.E_ForcePolar = true;

    UINT Check;
    if (Draw.E_ForcePolar)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLEPOLARSNAP,Check);
	
}

void CChildView::OnPopupTogglesnaptoendpoint() 
{
    if (Draw.E_SnapToEndPoint)
        Draw.E_SnapToEndPoint = false;
    else
        Draw.E_SnapToEndPoint = true;

    UINT Check;
    if (Draw.E_SnapToEndPoint)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLESNAPTOENDPOINT,Check);
	
}

void CChildView::PopupAlignChecks()
{
    UINT Check;
    if (Draw.E_SnapToEndPoint)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLESNAPTOENDPOINT,Check);

    if (Draw.E_ForcePolar)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLEPOLARSNAP,Check);

    if (Draw.E_ForceGrid)
        Check = MF_CHECKED;
    else
        Check = MF_UNCHECKED;

	Popup.CheckMenuItem(ID_POPUP_TOGGLEGRIDSNAP,Check);

}

void CChildView::OnModeloptionsAddbumpsensor() 
{
	ResetAllActions();
	E_BumpSensorEnabled = true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}

void CChildView::OnEditUndo() 
{
	Draw.OnUndo();
    Invalidate(true);
    UpdateWindow();
	
}

void CChildView::OnEditRedo() 
{
	Draw.OnRedo();
    Invalidate(true);	
    UpdateWindow();
}

LRESULT CChildView::OnSaveState(WPARAM, LPARAM)
{
    Draw.AddtoUndoState();
    return 0;
}

void CChildView::OnFileSave() 
{
     if (SaveFileName != "")
     {
         QuadTree.FileSaveMap(SaveFileName,Draw.CurrentView, false);
     }
     else
     {
         OnFileSaveAs();
     }
	
}

void CChildView::OnModeloptionsEditproperties() 
{
	QuadTree.DraftingEditProperties();
	
}

void CChildView::OnModeloptionsAddirsensor() 
{
	ResetAllActions();
	E_IRSensorEnabled = true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}

void CChildView::OnModeloptionsAddsonarsensor() 
{
    ResetAllActions();
	E_SonarSensorEnabled = true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}

void CChildView::OnFileSavewoarcs() 
{
	//static char BASED_CODE szFilter[] = "Chart Files (*.xlc)|*.xlc|Worksheet Files (*.xls)|*.xls|Data Files (*.xlc;*.xls)|*.xlc; *.xls|All Files (*.*)|*.*||";
    static char BASED_CODE szFilter[] = "Map Files (*.mpp)|*.mpp||";
 
    CFileDialog tempo(false,"*.mpp","default.mpp",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);

    if (tempo.DoModal() == IDOK)
    {
        CString FileName = tempo.GetPathName();
        QuadTree.FileSaveMap(FileName, Draw.CurrentView, true);
        SaveFileName = FileName;
    }

	
}

BOOL CChildView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// to lock on a point
	if ((abs(pt.x -OldScrollMousePoint.x) > 20) || (abs(pt.y - OldScrollMousePoint.y) > 20)) 
	{
		OldScrollMousePoint = pt;
		Draw.SetZoomCenter(pt);
	}

	Draw.PrevMousePos=pt;
	CPoint Point2 = pt;
	// zDelta is always in increments of 120 but it sign changed
	Point2.y += -zDelta/120;
	Draw.ZoomView(Point2);
	Point2.y += -zDelta/120;
	Draw.ZoomView(Point2);


	Invalidate(false);
	UpdateWindow();

	return CWnd ::OnMouseWheel(nFlags, zDelta, pt);

}

void CChildView::OnPlacerobot() 
{
	ResetAllActions();
	E_RobotPlacementEnabled = true;
    PrevCursor = CurCursor = 3;
    Draw.SetCenterCursorOffset();
    Invalidate(false);
	
}
