// UConsole.cpp: implementation of the UConsole class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Mapper.h"
#include "UConsole.h"
#include "ChildView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

UConsole::UConsole()
{
    ClearAllStates();
    // manually have to input enters.
    Enter.Format("%c%c",13,10);
}

UConsole::~UConsole()
{

}

// activated when the user presses the enter key.
void UConsole::OnEnter(UConsole::CONSOLESTRUCT &theConsole)
{
    // get the input character
    CString Instruction,OldInstruction,Log;
    theConsole.Console.GetWindowText(Instruction);
    OldInstruction = Instruction;
        

    // now do the action
    if (ParseInstruction(Instruction))
    {
        // enter the instruction in the log if valid, and clear the window
        theConsole.ConsoleLog.GetWindowText(Log); 
        Log += Enter + OldInstruction + Enter + Instruction;
        theConsole.ConsoleLog.SetWindowText(Log);
        theConsole.ConsoleLog.LineScroll(theConsole.ConsoleLog.GetLineCount());
    }
    // Instruction is a return value from the above function
    theConsole.Console.SetWindowText("");


}


BOOL UConsole::isInitialState()
{
    return !ConsoleState.Arc1 && !ConsoleState.Arc2 && !ConsoleState.line1
        && !ConsoleState.Arc3 && !ConsoleState.line2 && !ConsoleState.line4
        && !ConsoleState.line3 && !ConsoleState.Depth1 && !ConsoleState.Depth2
        && !ConsoleState.Rotate1 && !ConsoleState.Rotate2
        && !ConsoleState.Move1 && !ConsoleState.Move2
        && !ConsoleState.BumpSensor1 && !ConsoleState.BumpSensor2 && !ConsoleState.BumpSensor3
        && !ConsoleState.IRSensor1 && !ConsoleState.IRSensor2 && !ConsoleState.IRSensor3 && !ConsoleState.IRSensor4
        && !ConsoleState.SonarSensor1 && !ConsoleState.RobotPlacement1;


}

void UConsole::ClearAllStates()
{
    ConsoleState.Arc1 = ConsoleState.Arc2 = ConsoleState.line1 = false;
    ConsoleState.Arc3 = ConsoleState.line2 = false;
    ConsoleState.line3 = ConsoleState.line4 = false;
    ConsoleState.Depth1 = ConsoleState.Depth2 = false;
    ConsoleState.Rotate1 = ConsoleState.Rotate2 = false;
    ConsoleState.Move1 = ConsoleState.Move2 = false;
    ConsoleState.BumpSensor1 = ConsoleState.BumpSensor2 = ConsoleState.BumpSensor3 = false;
    ConsoleState.IRSensor1 = ConsoleState.IRSensor2 = ConsoleState.IRSensor3 = ConsoleState.IRSensor4 = false;
    ConsoleState.SonarSensor1 = false;
	ConsoleState.RobotPlacement1 = false;
}

BOOL UConsole::ParseInstruction(CString &Instruction)
{
    // make it all lower case
    Instruction.MakeLower();

    // next parse out the '>' character
    int Break = Instruction.Find(BREAKCHARACTER);

    // if '>' exists parse it out
    if (Break != -1)
    {
        int Size = Instruction.GetLength();
        char *ptr = Instruction.GetBuffer(300);
        strncpy(ptr,ptr+Break+1,Size-Break+1);
    }

    // get rid of extra white space
    Instruction.TrimLeft(' ');

    if (isInitialState())
    {
        if (Instruction == "line")
        {
            if (!isInitialState())
                ClearAllStates();

            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnDrawline();
            
            ConsoleState.line1 = true;
         
            Instruction = "Line start Coordinates (x,y)";
            return true;
        }  
        else if (Instruction == "arc")
        {
            if (!isInitialState())
                ClearAllStates();

            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnDrawingtoolsDrawarc();
            
            ConsoleState.Arc1 = true;
            
            Instruction = "Arc start Coordinates (x,y)";
            return true;
        }
        else if  (Instruction == "depth")
        {
            ConsoleState.Depth1 = true;
            Instruction = "Enter Depth";
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnDrawingtoolsAdddepth();
            return true;
        }
        else if (Instruction == "rotate")
        {
            ConsoleState.Rotate1 = true;
            Instruction = "Enter Center Point (x,y)";
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnDrawingtoolsRotate();
            return true;
        }
        else if (Instruction == "move")
        {
            ConsoleState.Move1 = true;
            Instruction = "Enter Start Point (x,y)";
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnDrawingtoolsMoveobjects();
            return true;
        }
        else if (Instruction == "bumper")
        {
            ConsoleState.BumpSensor1 = true;
            Instruction = "Enter Start Range for Bump Sensor (x,y)";
            
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnModeloptionsAddbumpsensor();
            return true;
        }
        else if (Instruction == "ir")
        {
            ConsoleState.IRSensor1 = true;
            Instruction = "Enter Display Point for IR Sensor (x,y)";
            
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnModeloptionsAddirsensor();
            return true;
        }
        else if (Instruction == "sonar")
        {
            ConsoleState.SonarSensor1 = true;
            Instruction = "Enter Display Point for Sonar Sensor (x,y)";
            
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnModeloptionsAddsonarsensor();
            return true;
        }
		else if (Instruction == "rp")
        {
            ConsoleState.RobotPlacement1 = true;
            Instruction = "Enter Display Point for Robot Placement (x,y)";
            
            CChildView *Ptr = (CChildView *)ParentPtr;
            Ptr->OnPlacerobot();
            return true;
        }

    }
    else if (isLineState())// is a continuation
    {
        return SM_Line(Instruction);       
    }
    else if (isArcState())
    {
        return SM_Arc(Instruction);
    }
    else if (isDepthState())
    {
        return SM_AddDepth(Instruction);
    }
    else if (isRotateState())
    {
        return SM_Rotate(Instruction);
    }
    else if (isMoveState())
    {
        return SM_Move(Instruction);
    }    
    else if (isBumpSensorState())
    {
        return SM_BumpSensor(Instruction);
    }
    else if (isIRSensorState())
    {
        return SM_IRSensor(Instruction);
    }
    else if (isSonarSensorState())
    {
        return SM_SonarSensor(Instruction);
    }
	else if (isRobotPlacementState())
	{
		return SM_RobotPlacement(Instruction);
	}



    Instruction = "";
    return false;

}

BOOL UConsole::IsValidNumber(int number)
{
    if (number >= 0 && number < 20000)
        return true;
    if (ConsoleState.line4) // delta coordinates
    {
        if (number >= -20000 && number < 20000)
            return true;
    }
    return false;

}

// if a mouse input is used.
BOOL UConsole::SM_Line(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.line1)
    {      
        ConsoleState.LineStart = Point;
        
        ClearAllStates();
        ConsoleState.line2 = true;
        DrawPtr->DrawLine(Point,true); 
        CString Instruction = "Line started at " + point + " Enter End Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.line2)
    {
        DrawPtr->OnMouseMove(Point,true);
        DrawPtr->DrawLine(Point,true);               
        ClearAllStates();
        CString Instruction = "Line ended at " + point;
        EnterText(Instruction);
        CreateUndoState();
        return true;
    }
    return false;
}
 
BOOL UConsole::SM_Line(CString &Instruction)
{
     if (ConsoleState.line1)
     {

        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
           // point = DrawPtr->ScreentoReal(point);
            ConsoleState.LineStart = point;
            DrawPtr->DrawLine(point,true); 
            DrawPtr->OnLButtonUp();
            ClearAllStates();
            ConsoleState.line2 = true;
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Line started at " + StartPoint + " Enter End Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    else if (ConsoleState.line2)
    {
        
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)
        {
            DrawPtr->OnMouseMove(point,true);
            DrawPtr->DrawLine(point,true);
            DrawPtr->OnLButtonUp();                    
            ClearAllStates();
            CString EndPoint;
            EndPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Line Ended at " + EndPoint;
            CreateUndoState();
            return true;
        }           
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }         
    }
    return false;
}

void UConsole::EnterText(CString Text)
{
    CString Log,Enter;

    Enter.Format("%c%c",13,10);

    theConsole->ConsoleLog.GetWindowText(Log); 
    Log += Enter + Text;
    theConsole->ConsoleLog.SetWindowText(Log);

    // Instruction is a return value from the above function
    theConsole->Console.SetWindowText("");
    theConsole->ConsoleLog.LineScroll(theConsole->ConsoleLog.GetLineCount( )); // make sure the last text is the one being seen

}



BOOL UConsole::isLineState()
{
    return ConsoleState.line1 || ConsoleState.line2 || ConsoleState.line3 || ConsoleState.line4;

}

BOOL UConsole::isArcState()
{
    return ConsoleState.Arc1 || ConsoleState.Arc2 || ConsoleState.Arc3;

}

BOOL UConsole::isIRSensorState()
{
    return ConsoleState.IRSensor1 || ConsoleState.IRSensor2 || ConsoleState.IRSensor3
            || ConsoleState.IRSensor4;

}

BOOL UConsole::isSonarSensorState()
{
    return ConsoleState.SonarSensor1;

}

BOOL UConsole::isRobotPlacementState()
{
    return ConsoleState.RobotPlacement1;

}

BOOL UConsole::SM_Arc(CString &Instruction)
{
     if (ConsoleState.Arc1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->DrawArc(point,true); 
            DrawPtr->OnMouseMove(point,true);
            DrawPtr->OnLButtonUp();
            ClearAllStates();
            ConsoleState.Arc2 = true;
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Arc started at " + StartPoint + " Enter Middle Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    else if (ConsoleState.Arc2)
    {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->OnMouseMove(point,true);
            DrawPtr->DrawArc(point,true);
            DrawPtr->OnLButtonUp();
            ClearAllStates();
            ConsoleState.Arc3 = true;
            CString EndPoint;
            EndPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Arc End Point at " + EndPoint + " Enter End Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            CreateUndoState();
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
   }

    else if (ConsoleState.Arc3)
    {
        
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)
        {
            DrawPtr->OnMouseMove(point,true);
            DrawPtr->DrawArc(point,true);
            DrawPtr->OnLButtonUp();                    
            ClearAllStates();
            CString MiddlePoint;
            MiddlePoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Arc Middle point " + MiddlePoint;
            return true;
        }           
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }         
    }
    return false;
}

BOOL UConsole::SM_Arc(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.Arc1)
    {      
        ConsoleState.LineStart = Point;
        
        ClearAllStates();
        ConsoleState.Arc2 = true;
        DrawPtr->DrawArc(Point,true); 
        CString Instruction = "Arc started at " + point + " Enter Middle Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.Arc2)
    {
        DrawPtr->OnMouseMove(Point,true);
        DrawPtr->DrawArc(Point,true);            
        ClearAllStates();
        ConsoleState.Arc3 = true;
        CString Instruction = "End Point" + point + " Enter End Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        return true;
    }
     else if (ConsoleState.Arc3)
    {
        DrawPtr->OnMouseMove(Point,true);
        DrawPtr->DrawArc(Point,true);              
        ClearAllStates();
        CString Instruction = "Arc Middle at " + point;
        EnterText(Instruction);
        CreateUndoState();
        return true;
    }
    return false;

}

CPoint UConsole::ParsePoint(CString &Instruction)
{
    int X,Y;
    CPoint Return;
    BOOL isDelta = false;
    BOOL NegativeX = false;
    BOOL NegativeY = false; // for delta coordinates
    BOOL isPolar = false;

    char *ptr = Instruction.GetBuffer(300);
    if (ptr[0] == 'd')
    {
        ptr++;
        isDelta = true;
        // have to check for negatives
        int Neg1 = Instruction.Find('-',0);
        int Neg2 = Instruction.Find('-',Neg1+1);
        int Comma = Instruction.Find(',',0);
        Instruction.Remove('-'); // time to remove it, screws up sscanf

        // figure out if either of the two numbers have a negative sign
        if ((Neg1 > 0) && (Neg1 < Comma))
        {
            NegativeX = true;
			if ((Neg2 > 0) && (Neg2 > Comma))
			{
            NegativeY = true;
			}
        }
        else if ((Neg1 > 0) && (Neg1 > Comma))
        {
            NegativeY = true;
        }            
        // delta point
    }
    else if (ptr[0] == 'p')
    {
        // polar point
        ptr++;
        isPolar = true;
    }

    sscanf(ptr,"(%d,%d)",&X,&Y); 
    if (IsValidNumber(X) && IsValidNumber(Y))
    {
        Return.x = X;
        Return.y = Y;        
    }
    else
    {
        // try the other formating scheme
        sscanf(ptr,"%d,%d",&X,&Y); 
        if (IsValidNumber(X) && IsValidNumber(Y))
        {
            Return.x = X;
            Return.y = Y;            
        }
        else
        {
            // invalid point
            Return.x = -1;
            Return.y = -1;  
            return Return; // quit
        }
    }

    if (isDelta)
    {
        // invert the number if negative
        if (NegativeX)
            Return.x = -Return.x;
        if (NegativeY)
            Return.y = -Return.y;

        Return.x += ConsoleState.LineStart.x;
        Return.y += ConsoleState.LineStart.y;
        if (!(IsValidNumber(Return.x) && IsValidNumber(Return.y)))
        {
            Return.x = -1;
            Return.y = -1;  
            return Return; // quit
        }
    }
    else if (isPolar)
    {
        double Distance = Return.x;
        double Angle = Return.y;
        Return.x = ConsoleState.LineStart.x + (long)(Distance * cos(PI/180.0*Angle));
        Return.y = ConsoleState.LineStart.y - (long)(Distance * sin(PI/180.0*Angle));
        if (!(IsValidNumber(Return.x) && IsValidNumber(Return.y)))
        {
            Return.x = -1;
            Return.y = -1;  
            return Return; // quit
        }
    }

    return Return;


}

void UConsole::CancelCommand()
{
    ClearAllStates();

    CString Log;

 // enter the instruction in the log if valid, and clear the window
    theConsole->ConsoleLog.GetWindowText(Log); 
    Log += Enter + "Cancel";
    theConsole->ConsoleLog.SetWindowText(Log);
    theConsole->ConsoleLog.LineScroll(theConsole->ConsoleLog.GetLineCount());

}

BOOL UConsole::SM_AddDepth(CString &Instruction)
{
     if (ConsoleState.Depth1)
     {
         char tempo[200];
         strcpy(tempo,Instruction.GetBuffer(200));
         int depth = atoi(tempo);
         if ((depth > MINDEPTH) && (depth < MAXDEPTH))
         {
             ClearAllStates();
             ConsoleState.Depth = depth;
             ConsoleState.Depth2 = true;
             Instruction = "(I)nside or (O)utside";
         }
         else
         {
             Instruction = "Invalid Depth, Re-Enter";
         }
         return true;
     }
     else if (ConsoleState.Depth2)
     {
         char tempo[200];
         strcpy(tempo,Instruction.GetBuffer(200));
         if (tempo[0] == 'i')
         {
             ClearAllStates();
             Instruction = "Adding Depth";
             ConsoleState.inSide = true;
             CChildView *Ptr = (CChildView *)ParentPtr;
             CreateUndoState();
             Ptr->QuadTree.DraftingCreateDepth(ConsoleState.Depth,ConsoleState.inSide);
             CreateUndoState();
             
         }
         else if (tempo[0]  == 'o')
         {
             ClearAllStates();
             Instruction = "Adding Depth";
             ConsoleState.inSide = false;
             CChildView *Ptr = (CChildView *)ParentPtr;
             CreateUndoState();
             Ptr->QuadTree.DraftingCreateDepth(ConsoleState.Depth,ConsoleState.inSide);      
             CreateUndoState();
             
         }
         else
         {
             Instruction = "Invalid input: enter (I)nside or (O)utside";
         }
         return true;
     } 

     return false;     

}

BOOL UConsole::isDepthState()
{
     return ConsoleState.Depth1 || ConsoleState.Depth2;

}

BOOL UConsole::isRotateState()
{
    return (ConsoleState.Rotate1 || ConsoleState.Rotate2);
}

BOOL UConsole::SM_Rotate(CString &Instruction)
{
    // time to enter center point
     if (ConsoleState.Rotate1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
          
            ConsoleState.RotateCenter = point;
            ClearAllStates();
            ConsoleState.Rotate2 = true;            
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Center of rotation is " + StartPoint + " Enter rotation angle";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
     }
     else if (ConsoleState.Rotate2)
     {
         char tempo[200];
         strcpy(tempo,Instruction.GetBuffer(200));
         int Angle = atoi(tempo);

         if ((Angle >= 0) && (Angle <= 360))
         {
             DrawPtr->RotateGroup(ConsoleState.RotateCenter,Angle,true);
             Instruction = "Done";
             ClearAllStates();
             CreateUndoState();
         }
         else
         {
             Instruction = "Invalid angle: Enter an angle between 0 and 360";
         }
         return true;
     } 

     return false;     

}

BOOL UConsole::SM_Rotate(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (ConsoleState.Rotate1)
    {      
        ConsoleState.RotateCenter = Point;        
        ClearAllStates();
        ConsoleState.Rotate2 = true;        
        CString Instruction = "Center of rotation is " + point + " Enter rotation angle";
        EnterText(Instruction);
        CreateUndoState();
        return true;
    }
    
    return false;

}

BOOL UConsole::isMoveState()
{
    return ConsoleState.Move1 || ConsoleState.Move2;

}

BOOL UConsole::SM_Move(CPoint Point)
{
    CString Enter,Instruction;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);

    if (isInitialState() || ConsoleState.Move1)
    {      
        ConsoleState.LineStart = Point;
        ClearAllStates();
        ConsoleState.Move2 = true;            
        CString StartPoint;
        StartPoint.Format("(%d,%d)",Point.x,Point.y);
        Instruction = "Start move point is" + StartPoint + " Enter end move point or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        DrawPtr->MoveObjects(Point,true);
        return true;
    }
    else if (ConsoleState.Move2)
    {
        ConsoleState.LineStart = Point;
        ClearAllStates();         
        CString StartPoint;
        StartPoint.Format("(%d,%d)",Point.x,Point.y);
        Instruction = "End move point is" + StartPoint;
        EnterText(Instruction);
        DrawPtr->MoveObjects(Point,true);
        CreateUndoState();
        return true;
    }
    return false;

}

BOOL UConsole::SM_Move(CString &Instruction)
{
     // time to enter center point
     if (ConsoleState.Move1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
          
            ConsoleState.LineStart = point;
            ClearAllStates();
            ConsoleState.Move2 = true;            
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Start move point is" + StartPoint + " Enter end move point or (P)olar p(x,y)/ (D)elta d(x,y)>";
            DrawPtr->MoveObjects(point,true);
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates, enter point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }
     }
     else if (ConsoleState.Move2)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
          
            ConsoleState.LineStart = point;
            ClearAllStates();         
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "End move point is" + StartPoint;
            DrawPtr->MoveObjects(point,true);
            CreateUndoState();
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates, enter point (x,y)or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }
     } 

     return false;     

}

BOOL UConsole::isBumpSensorState()
{
    return ConsoleState.BumpSensor1 || ConsoleState.BumpSensor2 || ConsoleState.BumpSensor3;

}


BOOL UConsole::SM_BumpSensor(CString &Instruction)
{
     if (ConsoleState.BumpSensor1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->AddBumpSensor(point,true); 
            ClearAllStates();
            ConsoleState.BumpSensor2 = true;
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Bump Sensor starting range at " + StartPoint + " Enter Ending Range Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    else if (ConsoleState.BumpSensor2)
    {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->AddBumpSensor(point,true);
            ClearAllStates();
            ConsoleState.BumpSensor3 = true;
            CString EndPoint;
            EndPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Bump Sensor Ending Range at " + EndPoint + " Enter Display Point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
   }
   else if (ConsoleState.BumpSensor3)
   {
        
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)
        {
            DrawPtr->AddBumpSensor(point,true);              
            ClearAllStates();
            CString MiddlePoint;
            MiddlePoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Bump Sensor Diplay Point " + MiddlePoint;
            CreateUndoState();
            return true;
        }           
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }         
    }
    return false;
}

BOOL UConsole::SM_BumpSensor(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.BumpSensor1)
    {      
        ConsoleState.LineStart = Point;
        
        ClearAllStates();
        ConsoleState.BumpSensor2 = true;
        DrawPtr->AddBumpSensor(Point,true); 
        CString Instruction = "Bump Sensor starting range at " + point + " Enter end Range (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.BumpSensor2)
    {
        DrawPtr->AddBumpSensor(Point,true);            
        ClearAllStates();
        ConsoleState.BumpSensor3 = true;
        CString Instruction = "Bump Sensor ending range at" + point + " Enter Display point (x,y) or (P)olar p(x,y)/ (D)elta d(x,y)>";
        EnterText(Instruction);
        return true;
    }
     else if (ConsoleState.BumpSensor3)
    {
        DrawPtr->AddBumpSensor(Point,true);              
        ClearAllStates();
        CString Instruction = "Bump Sensor Display Point at " + point;
        EnterText(Instruction);
        CreateUndoState();
        return true;
    }
    return false;

}

BOOL UConsole::SM_IRSensor(CPoint Point)
{
     CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.IRSensor1)
    {      
        ConsoleState.LineStart = Point;
        
        ClearAllStates();
        ConsoleState.IRSensor2 = true;
        ConsoleState.LineStart = Point;        
        CString Instruction = "IR Sensor Display Point at" + point + " Please enter Minimum Range";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.IRSensor2)
    {
        CString Instruction = "Please type in Minimum Range";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.IRSensor3)
    {
        CString Instruction = "Please type in Maximum Range";
        EnterText(Instruction);
        return true;
    }
    else if (ConsoleState.IRSensor3)
    {
        CString Instruction = "Please type in Beam Angle";
        EnterText(Instruction);
        return true;
    }   
    return false;
}

BOOL UConsole::SM_IRSensor(CString &Instruction)
{
    if (ConsoleState.IRSensor1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            ClearAllStates();
            ConsoleState.IRSensor2 = true;
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "IR Sensor Display Point at" + StartPoint + " Please enter Minimum Range";
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    else if (ConsoleState.IRSensor2)
    {
        long MinRange;
        char *ptr = Instruction.GetBuffer(300);
        sscanf(ptr,"%d",&MinRange); 
        if (MinRange > 0 && MinRange < 10000)        
        {
            ConsoleState.IRMin = MinRange;
            ClearAllStates();
            ConsoleState.IRSensor3 = true;
            CString minrange;
            minrange.Format("%d",MinRange);
            Instruction = "IR Sensor Minimum Range " + minrange + " Enter Maximum Range";
            return true;
        }             
        else
        {
            Instruction = "Minimum Range between 0 and 10000, try again";
            return true;
        }
   }
   else if (ConsoleState.IRSensor3)
   {        
        long MaxRange;
        char *ptr = Instruction.GetBuffer(300);
        sscanf(ptr,"%d",&MaxRange); 
        if (MaxRange < ConsoleState.IRMin)
        {
            CString minrange;
            minrange.Format("%d",ConsoleState.IRMin);
            Instruction = "Maximum Range has to be greater then Minimum Range (" + minrange + ")";
            return true;
        }
        else if (MaxRange > 0 && MaxRange < 10001)        
        {
            ConsoleState.IRMax = MaxRange;
            ClearAllStates();
            ConsoleState.IRSensor4 = true;
            CString maxrange;
            maxrange.Format("%d",MaxRange);
            Instruction = "IR Sensor MaxRange Range " + maxrange + " Enter beam angle";
            return true;
        }             
        else
        {
            Instruction = "MaxRange Range between 0 and 10001, try again";
            return true;
        }
   }
   else if (ConsoleState.IRSensor4)
   {        
        long Angle;
        char *ptr = Instruction.GetBuffer(300);
        sscanf(ptr,"%d",&Angle); 
        if ((0 <= Angle) && (Angle <= 360))
        {
            DrawPtr->AddIRSensor(ConsoleState.LineStart,ConsoleState.IRMin,ConsoleState.IRMax,Angle);              
            ClearAllStates();
            CString angle;
            angle.Format("%d",Angle);
            Instruction = "IR Beam Angle " + angle;
            CreateUndoState();
            return true;
        }           
        else
        {
            Instruction = "Angle must be between 0 and 360, try again";
            return true;
        }         
    }
    return false;
}

BOOL UConsole::SM_SonarSensor(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.SonarSensor1)
    {           
        ClearAllStates(); 
        DrawPtr->AddSonarSensor(Point,true); 
        CString Instruction = "Sonar Sensor Display Point range at " + point;
        EnterText(Instruction);
        return true;
    }
    return false;
}

BOOL UConsole::SM_SonarSensor(CString &Instruction)
{
     if (ConsoleState.SonarSensor1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->AddSonarSensor(point,true); 
            ClearAllStates();
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Sonar Sensor Display Point range at " + StartPoint;
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    return false;
}

BOOL UConsole::SM_RobotPlacement(CPoint Point)
{
    CString Enter,point;

    Enter.Format("%c%c",13,10);

    Point = DrawPtr->ScreentoReal(Point);
    point.Format("(%d,%d)",Point.x,Point.y);


    if (isInitialState() || ConsoleState.RobotPlacement1)
    {           
        ClearAllStates(); 
        DrawPtr->AddRobotPlacement(Point,true); 
        CString Instruction = "Robot Placement at " + point;
        EnterText(Instruction);
        return true;
    }
    return false;
}

BOOL UConsole::SM_RobotPlacement(CString &Instruction)
{
     if (ConsoleState.RobotPlacement1)
     {
        CPoint point = ParsePoint(Instruction);
        if (point.x != -1)        
        {
            ConsoleState.LineStart = point;
            DrawPtr->AddRobotPlacement(point,true); 
            ClearAllStates();
            CString StartPoint;
            StartPoint.Format("(%d,%d)",point.x,point.y);
            Instruction = "Robot Placement at " + StartPoint;
            return true;
        }             
        else
        {
            Instruction = "Invalid Coordinates";
            return true;
        }
    }
    return false;
}




void UConsole::CreateUndoState()
{
    ::PostMessage(ParentPtr->m_hWnd,WM_SAVE_STATE,0,0);
}
