#ifndef AICLOSELOOP_H
#define AICLOSELOOP_H

#define CLMAXSTACK 500 // 500 should be more then enough nodes for a single loop

#define CLMAXLIST 200 // shouldn't need more then this for the close loop list

BOOL CLAddtoStack(unsigned short Node);
BOOL CLAddtoStackP(unsigned short Node);
void CLClearStack(void);

NODE* CLCloseLoop(char TDirection, GPOINT CurrPosition);

// when the second loop, etc is closed, the connection node,
// is cloned, so this sets the cloned node to being the close loop node.
void CLSetCloseLoopNode(NODE* NodePtr);
NODE* CLGetCloseLoopNode(void); // to get the decision node, to be cloned

// when a decision node has a hallway or unknown node connection, it might connect to another
// decision node.  This function does a search during the close loop algorithm.
void CLAlgamateNodes(NODE *NodePtr);

// takes a loop at the heap, and creates a list of nodes, that could possibly be
// used for closing the loop.  This list is then referenced when a search happens to
// see if the loop is being closed
void CLCreateCloseLoopList();

// check if the loop is closed.
BOOL CLIsLoopClosed(char TDirection, short Possibilities[4], GPOINT Location);



#endif