#ifndef AIROUTEPLANNER_H
#define AIROUTEPLANNER_H

#define MAXDISTANCE 60000

void RPReset(void); // reset the shortest path algorithm


struct RPQUEUE
{
	// have to store both nodes, to know in which direction to go
	unsigned short CurrNode;
	unsigned short PrevNode;
};

// queue functions for the shortest path algorithm
BOOL RPInsertinQueue(unsigned short In, unsigned short Prev);
RPQUEUE RPRemovefromQueue(void);

// stack functions for the shortest path
void RPInsertinStack(unsigned short In);

// shortest path algorithm
void RPGenerateShortestPath(unsigned short StartingNode, unsigned short EndingNode);
// generates the shortest path distance to every other node connected to it.
void RPGenerateShortestPath1(unsigned short StartingNode);
// uses the previous generated distance, to form the shortest distance stack,
// that is used for naviagtion
void RPGenerateShortestPath2(unsigned short EndingNode);

// for peaking on the stack
void RPSetupEnum(void);
BOOL RPEnum(unsigned short *Out);
// enum functions, generally for debugging (to draw it), lag of one
void RPSetupEnumD(void);
BOOL RPEnumD(unsigned short *Out);

BOOL RPPopStack(unsigned short *Out);





#endif