#include "stdafx.h"
#include "AIGraphH.h"
#include "AIUtils.h"

// the heap from AIGraph
extern NODE Heap[MAXNODE];

/************************************************************************
* Function UShiftDirectionCtr(char Direction)
*
* PURPOSE
* Utility function for returning a counterclockwise shift in direction.
*************************************************************************/
char UShiftDirectionClk(char Direction)
{

 	if ((Direction & North) != 0)	
 		return East;
 	else if ((Direction & East) != 0)	
 		return South;
 	else if ((Direction & South) != 0)	
 		return West;
 	else if ((Direction & West) != 0)	
 		return North;
 	return North; // default so compiler doesn't give a warning

}

/************************************************************************
* Function UShiftDirectionClk(char Direction)
*
* PURPOSE
* Utility function for returning a clockwise shift in direction.
*************************************************************************/
char UShiftDirectionCtr(char Direction)
{
	if ((Direction & North) != 0)	
		return West;
	else if ((Direction & East) != 0)	
		return North;
	else if ((Direction & South) != 0)	
		return East;
	else if ((Direction & West) != 0)	
		return South;
	return North; // default so compiler doesn't give a warning

}

/************************************************************************
* Function NODE* UGetNode(NODE *NodePtr, char Direction);
*
* PURPOSE
* Utility function for returning a clockwise shift in direction.
*************************************************************************/
NODE* UGetNode(NODE *NodePtr, char Direction)
{

	if (NodePtr == NULL)
		return NULL;
	else if (Direction == North)
	{
		if (NodePtr->LinkN != NULL)		
			return &Heap[NodePtr->LinkN]; 
		else
			return NULL;
	}
	else if (Direction == South)
	{
		if (NodePtr->LinkS != NULL)		
			return &Heap[NodePtr->LinkS]; 
		else
			return NULL;
	}
	else if (Direction == East)
	{
		if (NodePtr->LinkE != NULL)		
			return &Heap[NodePtr->LinkE]; 
		else
			return NULL;
	}
	else if (Direction == West)
	{
		if (NodePtr->LinkW != NULL)		
			return &Heap[NodePtr->LinkW]; 
		else
			return NULL;
	}

	return NULL; // should never get here
}

