// SOpticalMouse.h: interface for the SOpticalMouse class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOPTICALMOUSE_H__31CAAE39_89CB_4B91_B8E1_9DC9EBCBED9F__INCLUDED_)
#define AFX_SOPTICALMOUSE_H__31CAAE39_89CB_4B91_B8E1_9DC9EBCBED9F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"

class SOpticalMouse  
{
public:
	float GetAngle();
	float CurrentAngle;
	ULinearAlgebra LAUtils;
	void IncrementDisplacement(float PrevAngle, float DAngle, float DX, float DY);
	void ClearDisplacement();
	CPoint GetDisplacement();

    #ifdef USEFLOAT
	    float YDisplacement;
	    float XDisplacement;
    #else
        double YDisplacement;
	    double XDisplacement;
    #endif

	float TurningRadius; // in cm
    float TicksperMM;
	SOpticalMouse();
	virtual ~SOpticalMouse();

};

#endif // !defined(AFX_SOPTICALMOUSE_H__31CAAE39_89CB_4B91_B8E1_9DC9EBCBED9F__INCLUDED_)
