// SQuadTree.h: interface for the SQuadTree class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SQUADTREE_H__0E6F9F6A_55F3_4403_BEB9_B3D6743A29DF__INCLUDED_)
#define AFX_SQUADTREE_H__0E6F9F6A_55F3_4403_BEB9_B3D6743A29DF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "UQuadTree.h"
#include "ULinearAlgebra.h"	// Added by ClassView

#define NOCOLLISION -1000000.0

class SQuadTree : public UQuadTree  
{
public:

    struct WallList
    {
        FPoint Start;
        FPoint End;
        FPoint Point3; // for roofs
    };
    // directX functionality
    ObjectListPtr DirectXObjectList;
	void DirectXCreateWallList();    
	BOOL DirectXEnumWallList(WallList &Wall);

    // the simulation is asyncronous to the rendering to a second set of functions and ptr
    // is needed to create a list of objects from the quadtree
    // if not there is conflicts.
    BOOL isOnSim;  // crappy semophore
	int SimCycle;  // So objects are only picked out once, a unique cycle number per cycle is used
    ObjectListPtr SimObjectListPtr; // the list to insert objects
	void SimCreateList(CRect SimBound, TreePtr toSimr); // recursive call
	void SimCreateList(CRect SimBound); // called to create the list
    BOOL SimEnumObjects(ObjectPtr &object); // extracts objects from the list
    void SimAddtoList(TreePtr toSimr); // adds the objects, used only by the recursive simcreatelist
    struct PointList;

    typedef PointList *PointListPtr;

    struct PointList
    {
        FPoint Point;
        PointListPtr Next;
    };

  


    // Collision Detection Functions
  	BOOL DetectCollisionSafetyCheck(FPoint Start, FPoint End);
    FPoint DetectCollision(FPoint ObjectStart, FPoint ObjectEnd, FPoint DeltaStart, FPoint DeltaEnd);
    float DetectCollisionDistance(FPoint ThePoint, FPoint CollisionPoint, FPoint ObjectStart, FPoint ObjectEnd, FPoint DeltaStart, FPoint DeltaEnd);

    // IR Detector Functions
    FPoint DetectCollision(FPoint StartPoint, float Angle, long MaxRange);

    // should/have have been put in ULinearAlgebra functions
  	FRect DetectCollisionFormRectF(FPoint ObjectStart, FPoint ObjectEnd, FPoint DeltaStart, FPoint DeltaEnd);
	CRect DetectCollisionFormRect(FPoint ObjectStart, FPoint ObjectEnd, FPoint DeltaStart, FPoint DeltaEnd);	    
	CRect DetectCollisionFormRect(CPoint Start, CPoint End);
    FRect DetectCollisionFormRect(FPoint Start, FPoint End);

	SQuadTree();
	virtual ~SQuadTree();

};

#endif // !defined(AFX_SQUADTREE_H__0E6F9F6A_55F3_4403_BEB9_B3D6743A29DF__INCLUDED_)
