function [xdelta,C] = ekf(xstate,landobs,deltat,CIn,numlandmarks);



%Measurement noise
RNoise = 0.1;

%Observation noise
noise = 0.1;

C = CIn;


%setup some matrices


%A
A = eye(3+numlandmarks*2);
A(1,1:5) = [1 0 -deltat*sin(xstate(3)) 0 0];
A(2,1:5) = [0 1 deltat*cos(xstate(3)) 0 0];

%W
W = zeros(1,3+numlandmarks*2);
W(1:3) = [1 1 1];
%W = [1 1 1 0 0 0 0];


%Q
Q = zeros(1,3+numlandmarks*2);
Q(1:3) = [noise noise noise];
%Q = [noise,noise,noise,0,0,0,0];

%R
V = eye(numlandmarks*2);
for r = 1:numlandmarks
    R(r*2-1:r*2) = [RNoise,RNoise];
end


%R = [RNoise,RNoise,RNoise,RNoise];
R = V*RNoise;

%make some space for Z
z = zeros(1,numlandmarks*2+3);

%save how it should be stored
%landest = [1 1; 5 2];
RobotRot = xstate(3);



%numlandmarks = 2;
%length = 3+numlandmarks*2;
%C = eye(3+numlandmarks*2)/25;
%xstate = [0 0 0 1 1 5 2];

%init H
H= zeros(numlandmarks*2, numlandmarks);

for i = 1:numlandmarks


% auxiliary values
dx= xstate(2+i*2)  -xstate(1); 
dy= xstate(3+i*2) -xstate(2);
d2= dx^2 + dy^2;
d= sqrt(d2);
xd= dx/d;
yd= dy/d;
xd2= dx/d2;
yd2= dy/d2;


% calculate H
H(1+2*(i-1):2*i,1:3)        = [-xd -yd 0; yd2 -xd2 -1];
H(1+2*(i-1):2*i,4+(i-1)*2:3+(i)*2)   = [ xd  yd;  -yd2  xd2];

% predict z
z(i*2+2:i*2+3)= [d (atan2(dy,dx) - RobotRot)];
end

%predict the covariance matrix
C = A*C*A' + W'*Q;
C;
A;
W;
Q;
W'*Q;


%come up with the invovation
inv1 = (H*C*H'+V*R*V');
%generate the kalman gain
Kt = C*H'*inv(inv1);
H;
V;
R;
inv1;
Kt;

%um I think adding the zeros have to be done
Kt1 = [zeros(numlandmarks*2+3,3), Kt];
Kt;
Kt1;

xdelta= (Kt1*(z-landobs)')';
z;
landobs;
xdelta

C;
%make the new covariance
Cnew = (eye(numlandmarks*2+3) - Kt*H)*C;
C = Cnew;;

Cnew;