// AIPath.h: interface for the AIPath class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AIPATH_H__19AB21A2_C506_4971_8F0F_E90082A82007__INCLUDED_)
#define AFX_AIPATH_H__19AB21A2_C506_4971_8F0F_E90082A82007__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define VISUALC

//////////////////////////////////////////////////////////////////////////
// This class performs the egerstadt algorithms
// to use it perform these steps
// 1) Enter the path (it is fixed) in the constructer of the class
// 2) Call  SetCurrentPoint(FPoint point, float Angle) to set the robots current point
// 3) Call GetNewDelta which returns the angular correctoin, goto 2.
//
// It does this by using the concept of a virtual robot travelling at "d" ahead (2 robot
// widths) of the perpindicular distance of the current robot to the path.  The robot then
// attempts to travel to the virtual robot, and eventually converges to the path.


#ifdef VISUALC
#include "ULinearAlgebra.h"
#else
struct FPoint
{
	long x;
	long y;
};

#endif

#define PATHMAXLENGTH 100

struct LineStruct
{ 
        
        float A;
        float B;
        float C;
        
};


class AIPath  
{
public:

	// main function to be called returns the angle correction
	float GetNewDelta();
	// the other function called from outside, sets the current robot angle and distance
	void SetCurrentPoint(FPoint point, float Angle);

	// used to retreive path points for rendering
	int EnumPathIndex;
	void StartPointEnum();
	bool EnumPathPoints(FPoint &returnPoint, bool &IsCurrentLink);
	
	

private:
	// math utilities
	float GetDistance(FPoint One, FPoint Two); // distance between to points
	FPoint FindIntersection(LineStruct  Line1, LineStruct Line2); // intersection between two lines
	// give a line (for perpindicular slope) and a point form a perpindicular line
	LineStruct PointstoPerpLine(FPoint Start, LineStruct Slope);
	// form a standard line (ax + by + c = 0) with two points.
	LineStruct PointstoLine(FPoint start, FPoint end);
	// finds the next point along a line
	FPoint TraverseLine(float Distance, FPoint StartPoint, FPoint EndPoint);

	// gets the next point along the line
	FPoint GetNextPoint();

	// these store current robot position
	FPoint CurrentPoint;
	float CurrentAngle;

	// different cornering algorithm option
	BOOL CutCorners;

	// the d value (twice the width?)
	float IterationDistance;
	

	int MaxFoward; // maximum foward travelling distance to round the corners nicely

	
public:

	// the path is stored in an array, this is the index for the array
	int CurrentLink;
	FPoint Links[PATHMAXLENGTH]; // the link array
	int NumofLinks;



	AIPath();
	virtual ~AIPath();

#ifdef VISUALC
	// rendering for windows	
	CPen RedPen;
	CPen GreenPen;
	void DirectXRender(VERTEX *&pVertex, FPoint RenderModelCenter, int &VertexCount);
	void GDIRender(CDC &MemDC, FRect Quad, CRect Screen, float SRScale, FPoint RenderModelCenter);

#endif	

};



#endif // !defined(AFX_AIPATH_H__19AB21A2_C506_4971_8F0F_E90082A82007__INCLUDED_)
