// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__11287275_4EC7_436E_A9A9_B641723C020A__INCLUDED_)
#define AFX_CHILDVIEW_H__11287275_4EC7_436E_A9A9_B641723C020A__INCLUDED_

#include "IniFile.h"	// Added by ClassView
#include "SGDIRender.h"	// Added by ClassView
#include "GenericModel.h"	// Added by ClassView
#include "SQuadTree.h"	// Added by ClassView
#include "SSimControl.h" // the control dialog
#include "MessageMap.h"

#include "SDirectx.h"
// standard includes
#include <D3D8.h>
#include "D3DApp.h"
#include "D3DUtil.h"
#include "DXUtil.h"
#include "D3DRes.h"
#include "ULinearAlgebra.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define RENDERSLIDER 100
#define SIMULATIONSLIDER 101

#define BIGRENDERINGSCALE float(0.01)
#define REALRENDERINGSCALE 1

// define an AI
//#define BASICSUBAI
#define EXPLORERAI

#define ROOTDIRECTORY "\\Robocup\\Sim\\"

/////////////////////////////////////////////////////////////////////////////
// CChildView window

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
public:

	// to limit the amount of stats and graph renders to every nth full screen render
	int DebugPaint; // debug
	int DebugPaintPaint;

    struct THREADINFO
    {
        BOOL EndSimThread;
        BOOL EndRenderThread;
        CChildView *ParentPtr;
        float RenderingTime;
        float MaxSimulationTime;
        float SimulationTime;
        float SimsPerSecond; // the amount of simulation to do a second
        float RenderPerSecond; // the amount of renders to do a second.  Only <= make values make sence
        float ActualSimsPerSecond;
        float ActualRenderPerSecond;
        float debug010sleeptime;
        float debug90100sleeptime;
        float SimLagTime;
        float RenderLagTime;
		float SimulationMultiplier; // 1 for one to one simulation
        CWinThread *SimThreadPtr;
        CWinThread *RenderThreadPtr;
    };

    struct OPTIONS
    {
        BOOL E_ZoomEnabled;
        BOOL E_PlaceRobotEnabled;
        int CurrCursor;
        BOOL AI_Enabled;
        BOOL GDIEnabled;
        BOOL DirectXEnabled;
        BOOL DirectX3DMovementEnabled;
            
    };	

    OPTIONS Options;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	float GlobalGetAngle();
	
	GPOINT GlobalPosition;

	// two global functions for cheating position
	GPOINT GlobalGetPosition();
	void GlobalSetZero();

	// Display graph stuff
	BOOL SDisplayGraphValid;
	CRect SDisplayGraphRect;

	// standard linear algebra library
	ULinearAlgebra LAUtils;	

    // one time initiliazation
	void OneTimeInit();

    // enabled the focus to be returned from a dialog box
	LRESULT OnUserSetFocus(WPARAM,LPARAM);

    // enabled loading maps/models from a file
	void LoadDefaultSettings();
	IniFile Settings;

    // The sim control dialog
	LRESULT OnSimOptions(WPARAM, LPARAM);
	SSimControl SimulationControlDLG;

	BOOL Once;
    // the render thread
	static UINT RenderThread(LPVOID lpInfo);

    // a frame pointer, for the directX window
    CWnd *FramePtr;

    // the simulator map
	SQuadTree SMap;

    // handles of cursors
    HCURSOR m_hCursor[16];

	void LoadCursors();
	void ResetOptions();
    // the simulator thread
	THREADINFO ThreadInfo;
	static UINT SimulatorThread(LPVOID lpInfo);

    // the model class
	SGenericModel SModel;
    // the class that handles all of the simulaters rendering
	SGDIRender SRender;

    #ifdef ENABLEDIRECTX
        SDirectX DirectX; // the class that handles all of the directX rendering
    #endif

    virtual ~CChildView();

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg void OnFileOpenmodel();
	afx_msg void OnStartSimulator();
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnEnableZoom();
	afx_msg void OnResetView();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnFileOpenmap();
	afx_msg void OnSimcontrol();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnPlacerobot();
	afx_msg void OnRenderoptions();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void On3dcamera();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSpeedupsim();
	afx_msg void OnSlowdownsim();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnTogglealttexture();
	afx_msg void OnToggleai();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__11287275_4EC7_436E_A9A9_B641723C020A__INCLUDED_)
