// RenderingOptions.cpp : implementation file
//

#include "stdafx.h"
#include "Simulator.h"
#include "RenderingOptions.h"
#include "ChildView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// RenderingOptions dialog


RenderingOptions::RenderingOptions(CWnd* pParent /*=NULL*/)
	: CDialog(RenderingOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(RenderingOptions)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void RenderingOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(RenderingOptions)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(RenderingOptions, CDialog)
	//{{AFX_MSG_MAP(RenderingOptions)
	ON_BN_CLICKED(IDC_GDI, OnGdi)
	ON_BN_CLICKED(IDC_DIRECTX, OnDirectx)
	ON_BN_CLICKED(IDC_CAMARAFIXED, OnCamarafixed)
	ON_BN_CLICKED(IDC_CAMERA3DGAME, OnCamera3dgame)
	ON_BN_CLICKED(IDC_CAMAERACHASE, OnCamaerachase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// RenderingOptions message handlers

void RenderingOptions::OnGdi() 
{
	m_GDIEnabled = true;
    m_DirectXEnabled = false;
    SetCameraOptions();
    Invalidate();
    UpdateWindow();
	
}

void RenderingOptions::OnDirectx() 
{
	m_GDIEnabled = false;
    m_DirectXEnabled = true;
    SetCameraOptions();
    Invalidate();
    UpdateWindow();
	
}

BOOL RenderingOptions::OnInitDialog() 
{
	CDialog::OnInitDialog();


    #ifndef ENABLEDIRECTX
    // disabled directX button if is wasn't compiled with the directX classes
        DisableDirectX();
    #endif

    if (m_GDIEnabled)
    {
        //sets the GDI button as default
        CButton *GDIButton = (CButton *)GetDlgItem(IDC_GDI);
        GDIButton->SetCheck(1);
    }
    else if (m_DirectXEnabled)
    {
        //sets the GDI button as default
        CButton *DirectXButton = (CButton *)GetDlgItem(IDC_DIRECTX);
        DirectXButton->SetCheck(1);
    }

    SetCameraOptions();

    

        
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void RenderingOptions::OnCamarafixed() 
{
	m_CameraType = FixedAngle;
    SetCameraOptions();   
	
}

void RenderingOptions::OnCamera3dgame() 
{
	m_CameraType = Game3D;
    SetCameraOptions();
	
}

void RenderingOptions::OnCamaerachase() 
{
	m_CameraType = Chase;
    SetCameraOptions();
	
}

void RenderingOptions::DisableDirectX()
{
        CWnd *DirectX = GetDlgItem(IDC_DIRECTX);
        DirectX->ModifyStyle(0,WS_DISABLED,0);

        DirectX = GetDlgItem(IDC_CAMARAFIXED);
        DirectX->ModifyStyle(0,WS_DISABLED,0);

        DirectX = GetDlgItem(IDC_CAMERA3DGAME);
        DirectX->ModifyStyle(0,WS_DISABLED,0);

        DirectX = GetDlgItem(IDC_CAMAERACHASE);
        DirectX->ModifyStyle(0,WS_DISABLED,0);

}

// generic function to handle updateing the group of radio buttons automatically
// plus it also will disablem them if directX is disabled.
void RenderingOptions::SetCameraOptions()
{
    if (m_CameraType != FixedAngle)
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMARAFIXED);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(0);
    }
    else
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMARAFIXED);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(1);

    }


    if (m_CameraType != Game3D)
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMERA3DGAME);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(0);
    }
    else
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMERA3DGAME);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(1);
    }

    if (m_CameraType != Chase)
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMAERACHASE);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(0);
    }
    else
    {
        CButton *DirectX = (CButton *)GetDlgItem(IDC_CAMAERACHASE);
        if (m_GDIEnabled)
            DirectX->ModifyStyle(0,WS_DISABLED,0);
        else
            DirectX->ModifyStyle(WS_DISABLED,0,0);
        DirectX->SetCheck(1);
    }

}
