// SBumpSensor.h: interface for the SBumpSensor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SBUMPSENSOR_H__15F55E7F_D230_49E2_82E1_B78638D3381B__INCLUDED_)
#define AFX_SBUMPSENSOR_H__15F55E7F_D230_49E2_82E1_B78638D3381B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"

#define MAXBUMPSENSOR 8
#define RED 1

#define RIGHTFRONT 0x01
#define RIGHTBACK 0x02
#define REARRIGHT 0x04
#define REARLEFT 0x08
#define LEFTFRONT 0x10
#define LEFTBACK 0x20
#define FRONTRIGHT 0x40
#define FRONTLEFT 0x80


class SBumpSensor  
{
public:
	
	FRect FormCollisionRect(int index);
	void ClearBumpSensor();
	ULinearAlgebra LAUtils;

    struct BUMPSENSORTYPE
    {
        FPoint StartRange, EndRange, DisplayPoint;   
        float Angle; // for rendering
        BOOL Valid;
        BOOL isCollided;
    };

    struct MODELINFO
    {
     
       #ifdef USEFLOAT
            float x,y; // position        
            float CurrAngle; // Current Angle
        #else
            double x,y; // position        
            double CurrAngle; // Current Angle
        #endif  
        FPoint Center;      
    };

    // used by the model to communicate its position so the bump sensors
    // could update
	MODELINFO ModelInfo;
	void UpdateModel(MODELINFO ModelInfo);

    // assorted pens
    CPen ColorPens[5];
    COLORREF Colors[5];   

    // up to 8 bump sensors
    BUMPSENSORTYPE BumpSensors[MAXBUMPSENSOR];
    BUMPSENSORTYPE TransformedBumpSensors[MAXBUMPSENSOR];
    BUMPSENSORTYPE TransformedBumpSensorsR[MAXBUMPSENSOR];

    // a collision occured, set bump sensors.
	void SetBumpSensors(FPoint Collision);

    // translates the position of the sensors and places them in the global TransformedBumpSensors structure
    void TranslateSensors();
    void TranslateSensors(FPoint RenderModelCenter); // Render version

    // used to get the information about the bump sensors
	unsigned char GetBumpSensorByte();

    // the renderer
	void GDIRender(CDC &MemDC, FRect Quad, CRect Screen, float SRScale, FPoint RenderModelCenter);

    // these two are used in the initial load
	void LoadBumpSensor(CPoint StartRange, CPoint EndRange, CPoint DisplayPoint, int IDNumber);
	void AdjustforCenter(float Left, float Top);

	SBumpSensor();
	virtual ~SBumpSensor();
   
};

#endif // !defined(AFX_SBUMPSENSOR_H__15F55E7F_D230_49E2_82E1_B78638D3381B__INCLUDED_)
