// BaseObject.cpp: implementation of the BaseObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "BaseObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BaseObject::BaseObject()
{
	m_objectSelected = false;

}

BaseObject::~BaseObject()
{

}

Sphere* BaseObject::GetBoundingSphere()
{
	return &m_BoundingSphere;
}

AABB BaseObject::GetBoundingAABB()
{
	return m_BoundingAABB;

}


// helper funciton
bool BaseObject::IntersectTriangle(Point3 &orig, Point3 &dir, Point3 v0, Point3 v1, Point3 v2)
{
	 // Find vectors for two edges sharing vert0
    Point3 edge1 = v1 - v0;
    Point3 edge2 = v2 - v0;

    // Begin calculating determinant - also used to calculate U parameter
    Point3 pvec = dir^edge2;


    // If determinant is near zero, ray lies in plane of triangle
    double det = Point3::Dot( edge1, pvec );
    if( det < 0.0001f )
        return FALSE;

    // Calculate distance from vert0 to ray origin
    Point3 tvec = orig - v0;

    // Calculate U parameter and test bounds
    double u = Point3::Dot( tvec, pvec );
    if( u < 0.0f || u > det )
        return FALSE;

    // Prepare to test V parameter
    Point3 qvec;
    qvec = tvec^edge1;

    // Calculate V parameter and test bounds
    double v = Point3::Dot( dir, qvec );
    if( v < 0.0f || u + v > det )
        return FALSE;

    // Calculate t, scale parameters, ray intersects triangle
    /**t = D3DXVec3Dot( &edge2, &qvec );
    FLOAT fInvDet = 1.0f / det;
    *t *= fInvDet;
    *u *= fInvDet;
    *v *= fInvDet; */

    return TRUE;

}

// same as above except it returns the intersection point
bool BaseObject::IntersectTriangle(Point3 &orig, Point3 &dir, Point3 v0, Point3 v1, Point3 v2, Point3 &intersection)
{
		 // Find vectors for two edges sharing vert0
    Point3 edge1 = v1 - v0;
    Point3 edge2 = v2 - v0;

	Point3 e1 = v0-v1;
	Point3 e2 = v0-v2;

	Point3 normal = e1^e2;
	double dot = Point3::Dot(normal,dir);

	// the triangle is backfacing, if so return
//	if (dot < 0)
	//	return false;

    // Begin calculating determinant - also used to calculate U parameter
    Point3 pvec = dir^edge2;


    // If determinant is near zero, ray lies in plane of triangle
    double det = Point3::Dot( edge1, pvec );
    if( det < 0.0001f )
        return FALSE;

    // Calculate distance from vert0 to ray origin
    Point3 tvec = orig - v0;

    // Calculate U parameter and test bounds
    double u = Point3::Dot( tvec, pvec );
    if( u < 0.0f || u > det )
        return FALSE;

    // Prepare to test V parameter
    Point3 qvec;
    qvec = tvec^edge1;

    // Calculate V parameter and test bounds
    double v = Point3::Dot( dir, qvec );
    if( v < 0.0f || u + v > det )
        return FALSE;

	double t;
    // Calculate t, scale parameters, ray intersects triangle
    t = Point3::Dot( edge2,qvec );
    double fInvDet = 1.0f / det;
    t *= fInvDet;
   // *u *= fInvDet;
   // *v *= fInvDet;

	intersection = orig + dir*t;

    return TRUE;

}

// same as above except it returns the intersection point
bool BaseObject::IntersectTriangle(Point3 &orig, Point3 &dir, Point3 v0, Point3 v1, Point3 v2, Point3 &intersection, double &t)
{
		 // Find vectors for two edges sharing vert0
    Point3 edge1 = v1 - v0;
    Point3 edge2 = v2 - v0;


	// Begin calculating determinant - also used to calculate U parameter
	Point3 pvec = dir^edge2;
	double det = Point3::Dot( edge1, pvec );

    // If determinant is near zero, ray lies in plane of triangle
	if (det < 0.0001 && det > -0.0001)
		return false;

    // Calculate distance from vert0 to ray origin
    Point3 tvec = orig - v0;

    // Calculate U parameter and test bounds
    double u = Point3::Dot( tvec, pvec );
    if( u < 0.0f || u > det )
       return FALSE;

    // Prepare to test V parameter
    Point3 qvec = tvec^edge1;

    // Calculate V parameter and test bounds
    double v = Point3::Dot( dir, qvec );
    if( v < 0.0f || u + v > det )
        return FALSE;

    // Calculate t, scale parameters, ray intersects triangle
    t = Point3::Dot( edge2,qvec );
    double fInvDet = 1.0f / det;
    t *= fInvDet;
   // *u *= fInvDet;
   // *v *= fInvDet;

	intersection = orig + dir*t;

    return TRUE;

}
