// BaseObject.h: interface for the BaseObject class.
//
// This class is the super class to all objects (pretty much all geometry)
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BASEOBJECT_H__C6F4535B_83B0_45C0_8F47_572956C66D2F__INCLUDED_)
#define AFX_BASEOBJECT_H__C6F4535B_83B0_45C0_8F47_572956C66D2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Bounding volume classes
#include "AABB.h"
#include "Sphere.h"
#include "stddef.h"

class BaseObject  
{
public:
	bool IntersectTriangle(Point3 &orig, Point3 &dir, Point3 v0, Point3 v1, Point3 v2, Point3 &intersection);
	bool IntersectTriangle(Point3 &orig, Point3 &dir, Point3 v0, Point3 v1, Point3 v2, Point3 &intersection, double &t);
	bool IntersectTriangle(Point3& orig, Point3& dir, Point3 v0, Point3 v1, Point3 v2);
	virtual bool RayIntersectObject(Point3 &Org, Point3 &Dir) { return false;}
	virtual bool RayIntersectObject(Point3 &Org, Point3 &Dir, Point3 &intersection) { return false;}
	virtual void GetLightMaps() {};

	AABB GetBoundingAABB();
	Sphere *GetBoundingSphere();
	BaseObject();
	virtual ~BaseObject();
	virtual void DirectXRender(TLNVERTEXSTRUCT *&pVertex, int &VertexCount, int *&pLightmap,int &LightMapCount) {};

	bool m_objectSelected;
	int m_TextureType;

protected:
	Sphere m_BoundingSphere;
	AABB m_BoundingAABB;






};

#endif // !defined(AFX_BASEOBJECT_H__C6F4535B_83B0_45C0_8F47_572956C66D2F__INCLUDED_)
