// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "simulator.h"
#include "ChildView.h"
#include "OctTree.h"
#include "Box.h"
#include "Plane.h"
#include "OmniLight.h"
#include "LightMaps.h"
#include "Profiler.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{

	simThreadInfo.EndSimThread = true;
	simThreadInfo.actualSimsperQuanta = 0;

	theR3DWindow.MainOctTree = &TempGrid;

	OmniLight *light = new OmniLight(Point3(50,50,50),0xffff0000);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(70,70,70),0xff00ff00);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(20,70,20),0xff0000ff);
	theLightMaps.AddLight(light);

	/*light = new OmniLight(Point3(0,0,100),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(0,100,100),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(0,100,0),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(100,0,0),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(100,0,100),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(100,100,100),0xffffffff);
	theLightMaps.AddLight(light);

	light = new OmniLight(Point3(100,100,0),0xffffffff);
	theLightMaps.AddLight(light);*/

//	Box *tBox;

	int Max = 90;
	int Min = 10;

	Point3 T1,T2,T3;
	T1.x = 0; T1.z = 0; T1.y = 0;
	T2.x = 5; T2.z = 5; T2.y = 0;
	T3.x = 5; T3.z = 0; T3.y = 0;

	Plane tempo;
	tempo.GeneratePlane(T1,T2,T3);

	Point3 Dir,Org,Inter;
	Dir.x = 1; Dir.y = 5; Dir.z = 1;
	Org.x = 1; Org.y = 0; Org.z = 1;

	bool Flag = tempo.RayIntersectPlane(Inter,Org,Dir);



/*	for (int ix = 0; ix < 10; ix++)
	{
		Point3 Center;
		Center.x = 80.0*(float)rand()/RAND_MAX + 10;
		Center.y = 80.0*(float)rand()/RAND_MAX + 10;
		Center.z = 80.0*(float)rand()/RAND_MAX + 10;

		float AngleX = 360.0*(float)rand()/RAND_MAX;
		float AngleY = 360.0*(float)rand()/RAND_MAX;
		float AngleZ = 360.0*(float)rand()/RAND_MAX;

		int TextureType = 2*(float)rand()/RAND_MAX;
		if (TextureType == 2)
			TextureType = 1;

		//TextureType = 0;
		//float AngleX = 0;
		//float AngleY = 0;
		//float AngleZ = 0;

		tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Center,TextureType);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		TempGrid.AddObject(tBox);
	}*/

/*	Sphere tSphere;
	Point3 t1,t2,t3;
	t1 = Point3(0,5,0);
	t2 = Point3(0,-1,0);
	tSphere.RayInterect(t1,t2,t3);*/

/*	Box Boxt;
	Boxt.SetParameters(0,0,0,2,2,2,Point3(0,0,0),0);
	Boxt.RayOBBIntersect(t1,t2,t3);*/

	car1 = car2 = NULL;
	


	
}

CChildView::~CChildView()
{
	// kill the thread if it is running
	if (!simThreadInfo.EndSimThread)
	{
		simThreadInfo.EndSimThread = true;
		HANDLE hThread[2];
		hThread[0] = simThreadInfo.SimThreadPtr->m_hThread;

		 // wait for the threads to end
		::WaitForMultipleObjects(1,hThread,true,200);  
	}
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_MBUTTONDOWN()
	ON_COMMAND(ID_SIM_START, OnSimStart)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // do not enable so it does not overright

	int index = theProfiler.getTimeBlockIndex("Rendering");
	theProfiler.startTiming(index);
	theR3DWindow.Render();
	theProfiler.stopTiming(index);
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}


int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;

	theR3DWindow.viewWindow = this;
	
	// TODO: Add your specialized creation code here
	theR3DWindow.Init(FramePtr,CRect(5,5,600,600));

	DynamicObject *tAdd = new DynamicObject;
//	tAdd->init(theR3DWindow.g_pd3dDevice,"d:\\newsim\\simulator\\models\\car.j");
	tAdd->init(theR3DWindow.g_pd3dDevice,"c:\\jproject\\simulator\\models\\car.j");
	tAdd->currLocation = Point3(0,0,40);
	theDOManager.addObject(tAdd);

	car1 = tAdd;

	tAdd = new DynamicObject;
//	tAdd->init(theR3DWindow.g_pd3dDevice,"d:\\newsim\\simulator\\models\\ballmerb.j");
	tAdd->init(theR3DWindow.g_pd3dDevice,"c:\\jproject\\simulator\\models\\capsule1.j");
	tAdd->currLocation = Point3(0,0,0);
	theDOManager.addObject(tAdd);
	car2 = tAdd;
//capsuleb

/*	car1.init(theR3DWindow.g_pd3dDevice,"d:\\newsim\\simulator\\models\\ballmerb.j");
	car1.currLocation = Point3(0,0,0);

	theR3DWindow.car1 = &car1;*/
//	theR3DWindow.car2 = &car2;
//	car1.otherObject = tAdd;
//	car2.otherObject = &car1;*/
	
	return 0;
}

void CChildView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (theR3DWindow.IsClient(point))
	{
		theR3DWindow.OnMouseMove(nFlags,point);
	//	Invalidate(false);
	}
	
	CWnd ::OnMouseMove(nFlags, point);
}

void CChildView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (theR3DWindow.IsClient(point))
		theR3DWindow.OnLButtonDown(nFlags,point);
	
	CWnd ::OnLButtonDown(nFlags, point);
}

void CChildView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	if (theR3DWindow.IsClient(point))
		theR3DWindow.OnRButtonDown(nFlags,point);
	
	CWnd ::OnRButtonDown(nFlags, point);
}

void CChildView::OnMButtonDown(UINT nFlags, CPoint point) 
{
	if (theR3DWindow.IsClient(point))
		theR3DWindow.OnMButtonDown(nFlags,point);
	
	CWnd ::OnMButtonDown(nFlags, point);
}

///////////////////////////////////////////////////////////
// Function SimulatorThread(LPVOID lpInfo)
// 
// PURPOSE
// This is the thread that causes the simulator to run.
// Inputs
//     it is possible to input the time quanta (time the thread averages out executions
//     plus the number of executions per time quanta
// ALGORITHM
// The main formula is as follows
// 	sleepTime = (timeLeft - (averageTime * sLeftPerQuanta))/sLeftPerQuanta;
// it says sheck out how much spair time is avialable for sleeping and divide
// that by the amount of sleep times left then sleep that time  
///////////////////////////////////////////////////////////
UINT CChildView::SimulatorThread(LPVOID lpInfo)
{
    THREADINFO *ThreadInfo = (THREADINFO *)lpInfo;

	LARGE_INTEGER frequency,startTime,endTime,quantaStartTime,currTime;

	int sDoneThisQuanta = 0;  // the total amount of simulation per this time quanta
	int sPerQuanta = ThreadInfo->simsPerQuanta + 1; // simulations per quanta + 1 offset because we are zero based
	int sLeftPerQuanta = sPerQuanta; // sim lefts for this quanta

	double timeQuanta = ThreadInfo->simTimeQuanta; // schedule per seconds now
	double timeLeft = 0.0; // time left for the sim   
	double totalRunTime = 0.0; // total execution time (not sleep time)
	double prevTime,currentTime;
	currentTime = timeQuanta;


	double averageSleepTime = 0; // stat
	double statsSleepTime[100];
	double statsTimeArray[100];

    ::QueryPerformanceFrequency(&frequency); // figure out the frequency

  
    while (!ThreadInfo->EndSimThread)
    {
      
        if (timeLeft <= 0)
        {     

			// compile statistics
			double timeOffsets = 0;
			averageSleepTime = 0;
			for (int ix = 0; ix < sDoneThisQuanta; ix++)
			{
				double tempo = statsTimeArray[ix] - timeQuanta*ix/(sPerQuanta-1);
				if (tempo < 0)
					tempo = -tempo;
				timeOffsets += tempo;

				averageSleepTime+=statsSleepTime[ix];
			}
			timeOffsets = timeOffsets / (sPerQuanta-1);
			averageSleepTime = averageSleepTime/(sPerQuanta-1);


			ThreadInfo->actualSimsperQuanta = sDoneThisQuanta; // store stats
            // time to reset the stats
			sLeftPerQuanta = sPerQuanta;
			timeLeft = timeQuanta;   
			sDoneThisQuanta = 0;
			totalRunTime = 0.0;
			prevTime = currentTime - timeQuanta; // so the first sim this times gets proper delta time
			if (prevTime > 0)
				prevTime = 0;
			currentTime = 0;

			QueryPerformanceCounter(&quantaStartTime);
				
        }   

        ///////////////////////////////////////////////////////////////////
        // Simulator Control                                              /
        ///////////////////////////////////////////////////////////////////

        ::QueryPerformanceCounter(&startTime);

		
		// store start time for error report
        statsTimeArray[sDoneThisQuanta] = (double)(startTime.QuadPart - quantaStartTime.QuadPart)/(double)frequency.QuadPart;

		ThreadInfo->ParentPtr->Invalidate(false);
		double deltaTime = statsTimeArray[sDoneThisQuanta] - prevTime;
		if (deltaTime < 0.01)
		{
			int adf = 0;
		}

	/*	if (!ThreadInfo->ParentPtr->car1.isCollision(ThreadInfo->ParentPtr->car2,deltaTime))
		{
			ThreadInfo->ParentPtr->car1.simulate(deltaTime);
			ThreadInfo->ParentPtr->car2.simulate(deltaTime);
		}
		else
		{
			int blah = 34;
			ThreadInfo->ParentPtr->car1.setSpeed(deltaTime);
			ThreadInfo->ParentPtr->car2.setSpeed(deltaTime);
		}*/

		int index = theProfiler.getTimeBlockIndex("Physics");
		theProfiler.startTiming(index);

//		ASSERT(deltaTime < .3);
		theDOManager.Interate(deltaTime);

	//	ThreadInfo->ParentPtr->car1.simulate(deltaTime);
	//	ThreadInfo->ParentPtr->car2.simulate(deltaTime);
		Point3 collisionPoint;
	/*	if (ThreadInfo->ParentPtr->car1.isEdgeCollision(ThreadInfo->ParentPtr->car2,deltaTime,collisionPoint))
		{
			int blah = 34;
			Beep(50,20);
			ThreadInfo->ParentPtr->theR3DWindow.renderIntersection = true;
			ThreadInfo->ParentPtr->theR3DWindow.collisionPoint = collisionPoint;

		}
		else
		{
			ThreadInfo->ParentPtr->theR3DWindow.renderIntersection = false;
		}*/




	/*	if (ThreadInfo->ParentPtr->car1.isIntersectionQuick(ThreadInfo->ParentPtr->car2))
		{
			int blah = 34;

		}*/

		theProfiler.stopTiming(index);

		prevTime = currentTime;
		// artificial delay
	//	int rand1 = rand();
	//	for (int ix = 0; ix < 1000000+rand1*90; ix++)
	//	{
	//		int asdf;
	//		asdf = 34.2/2.3;
	//	}

		// run sim here
		 sDoneThisQuanta++;
		 sLeftPerQuanta--;

        ::QueryPerformanceCounter(&endTime);
       

        totalRunTime += (double)(endTime.QuadPart-startTime.QuadPart)/(double)frequency.QuadPart;


          ///////////////////////////////////////////////////////////////////
        // Figure out the sleep time                                      /
        ///////////////////////////////////////////////////////////////////

        ::QueryPerformanceCounter(&currTime);
         // update seconds
        double seconds = (float)(currTime.QuadPart - quantaStartTime.QuadPart)/(float)frequency.QuadPart;
		timeLeft = timeQuanta - seconds;
		currentTime = seconds;

		double sleepTime;
		if (sLeftPerQuanta == 1) // offset of 1
		{
			sleepTime = timeLeft;
			timeLeft = -0.1;
		}
		else
		{
			double averageTime = totalRunTime/sDoneThisQuanta;
			// sleepTime = (timeLeft - averageTime)/(sLeftPerQuanta); // figure out how much sleep time to sleep for       
			sleepTime = (timeLeft - (averageTime * sLeftPerQuanta))/sLeftPerQuanta;
		}

		statsSleepTime[sDoneThisQuanta-1] = sleepTime;

		int tTime = (int)(sleepTime*1000); // store time in msec as required by the sleep command

		if (tTime < 0)
			tTime = 0;


		// k time to sleep
		if (tTime < 3)
		tTime = 3; // so we sleep a bit
        Sleep(tTime);    



      //  }            

    }

   // ThreadInfo->EndSimThread = false;

    return 0;
}

void CChildView::OnSimStart() 
{
	if (simThreadInfo.EndSimThread)
	{
		simThreadInfo.EndSimThread = false;
		simThreadInfo.ParentPtr = this;
		simThreadInfo.simsPerQuanta = 30;
		simThreadInfo.simTimeQuanta = 1.0;
		simThreadInfo.actualSimsperQuanta = 0;
		
		simThreadInfo.SimThreadPtr = AfxBeginThread(SimulatorThread,(LPVOID) &simThreadInfo, THREAD_PRIORITY_TIME_CRITICAL);
	}
	else
	{
		// end the thread
		simThreadInfo.actualSimsperQuanta = 0;
		simThreadInfo.EndSimThread = true;
		HANDLE hThread[2];
        hThread[0] = simThreadInfo.SimThreadPtr->m_hThread;

         // wait for the threads to end
        ::WaitForMultipleObjects(1,hThread,true,200);    
	}

	
}



void CChildView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	if (car1 != NULL)
	{
		if (nChar == 'w')
			car1->linearAccel = 10;
		if (nChar == 's')
		{
			car1->linearAccel = 0;
			car1->angularAccel = 0;
		}
		if (nChar == 'x')
			car1->linearAccel = -10;
		if (nChar == 'a')
			car1->angularAccel = -1.5;
		if (nChar == 'd')
			car1->angularAccel = 1.5;
	}

	if (car2 != NULL)
	{

		if (nChar == 'u')
			car2->linearAccel = 10;
		if (nChar == 'j')
		{
			car2->linearAccel = 0;
			car2->angularAccel = 0;
		}
		if (nChar == 'm')
			car2->linearAccel = -10;
		if (nChar == 'h')
			car2->angularAccel = -1.5;
		if (nChar == 'k')
			car2->angularAccel = 1.5;
	}

	// check for profiler data
	if (nChar >= '0' && nChar <= '9')
	{
		theProfiler.selectDisplayItem(nChar -48);
	}
	
	CWnd ::OnChar(nChar, nRepCnt, nFlags);
}
