// DynamicObject.cpp: implementation of the DynamicObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "DynamicObject.h"
#include "profiler.h"
#include "opttritri.c"
#include "Matrix43.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

DynamicObject::DynamicObject()
{
	angularAccel = 0;
	linearAccel = 0;
	yAngle = 0;
	enumCurrIndex = enumCurrIndexO = 0;
	numPhysicsPoints = 0;

	prevLinearAccel = 0;
	hasMoved = false;

//	isCollision(Point3(-4,0,2),Point3(4,0,2),Point3(0,-4,-2),Point3(0,4,-2),Point3(0,0,-4),Point3(0,0,-4),Point3(0,0,3),Point3(0,0,3));

/*	theProfiler.EnterStartTime("jello");
	for (int ix = 0; ix < 1000; ix++)
	{
		isCollision(Point3(-4,1,2),Point3(4,1,2),Point3(1,-4,-2),Point3(1,4,-2),Point3(0,0,-4),Point3(0,0,-4),Point3(0,0,3),Point3(0,0,3));
	}
	theProfiler.EnterEndTime("jello");
	double time = theProfiler.GetExecutionTime("jello");*/
	

}

DynamicObject::~DynamicObject()
{
	delete tPhysicsPoints;
	delete tPrevPhysicsPoints;

}

void DynamicObject::init(LPDIRECT3DDEVICE8 g_pd3dDevice,char *fileName)
{
	// open the model
	Open(g_pd3dDevice,fileName);

	tPhysicsPoints = new Point3[numTotalVertices*(currObject+1)];
	tPrevPhysicsPoints = new Point3[numTotalVertices*(currObject+1)];
	
	// generate bounding volume information
	int total = 0;
	for (int iy = 0; iy <= currObject; iy++)
	{
		for (int ix = 0; ix < numTotalVertices; ix++)
		{
		
			m_BoundingSphere.enumAddVertices(loadVertices[iy][ix]);
			m_BoundingAABB.enumAddVertices(loadVertices[iy][ix]);

			tPrevPhysicsPoints[ix + total] = loadVertices[iy][ix];

		}
		total += ix;
	}

	m_BoundingSphere.FormSphere();
	m_BoundingAABB.FormAABB();

}

void DynamicObject::DirectXRender(LPDIRECT3DDEVICE8 g_pd3dDevice)
{
 //  g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TEXTURE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTOP_DISABLE );
	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTOP_DISABLE );
	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );


	D3DXMATRIX matWorld,yRot;

	D3DXMatrixIdentity( &matWorld);

	D3DXMatrixRotationY(&yRot,(float)yAngle);
	D3DXMatrixTranslation(&matWorld,(float)currLocation.x,(float)currLocation.y,(float)currLocation.z);
	matWorld = yRot*matWorld;
	g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );


	Render(g_pd3dDevice);

	D3DXMatrixIdentity( &matWorld);

	D3DXMatrixIdentity( &matWorld);
    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

}

void DynamicObject::moveTo(Point3 newLocation)
{
	currLocation = newLocation;

}

// obsolete function
void DynamicObject::simulate(double deltaTime)
{
	
	/*theProfiler.EnterStartTime();

	currLocation.x -= linearAccel*deltaTime*cos(yAngle);
	currLocation.z += linearAccel*deltaTime*sin(yAngle);
//	prevLinearAccel = linearAccel*deltaTime;
	yAngle += angularAccel*deltaTime;

			int index = theProfiler.getTimeBlockIndex("Physics1");
		theProfiler.startTiming(index);
	generateMovesCoords();
		theProfiler.stopTiming(index);
		index = theProfiler.getTimeBlockIndex("Physics2");
				theProfiler.startTiming(index);
//	if (isIntersectionQuick(*otherObject))
//	{
//	if (!generateMovesCoords())
//	{
	//		currLocation.x += linearAccel*deltaTime*cos(yAngle);
	//	currLocation.z -= linearAccel*deltaTime*sin(yAngle);
	//		yAngle -= angularAccel*deltaTime;
//	}
	theProfiler.stopTiming(index);
			theProfiler.EnterEndTime();
	double time = theProfiler.GetExecutionTime();*/
}

void DynamicObject::setSpeed(double deltaTime)
{
	prevLinearAccel = linearAccel*deltaTime;

}

/////////////////////////////////////////////////////////////////////
// bool isCollision(DynamicObject &otherObject)
//
// This function does all the work to see if there is a dynamic object collision
//
// 1) Check bounding sphere to see if there is an intersection (do later)
// 2) Get a list of vertices that have the potential to be in a collision
//     (inside velocity expanded circle zone)
// 3) Cast rays of each vertex to see if there is a possibility of a collision
/////////////////////////////////////////////////////////////////////
bool DynamicObject::isCollision(DynamicObject &otherObject, double deltaTime, Point3 &intersection)
{
	Point3 orig,dir;
	Matrix rot;
	MatrixRotationY(rot,yAngle);
	dir.x = -linearAccel*deltaTime;
	prevLinearAccel = linearAccel*deltaTime;
	dir.y = 0;
	dir.z = 0;
	dir = dir*rot;
	dir.Normalize();
	double t;
	int count = 0;

	theProfiler.EnterStartTime("Collision1");

	if (phyAngularAccel == 0 && phyLinearAccel == 0)
		return false;

	// first check which vertices are in the expanded bounding circle of the other object
			double absPrevLinearAccel = prevLinearAccel;
	if (prevLinearAccel < 0)
		prevLinearAccel = -prevLinearAccel;

	double extraExp = 10;

	// get triangles from there end that is close to our object
	int ix = 0;
	double radius2 = otherObject.m_BoundingSphere.m_Radius2 + absPrevLinearAccel + extraExp;
	while (otherObject.enumGetTriangle(u0[ix],u1[ix],u2[ix]))
	{
		
		double d1 = Point3::Hypot2(u0[ix],otherObject.currLocation);
		double d2 = Point3::Hypot2(u1[ix],otherObject.currLocation);
		double d3 = Point3::Hypot2(u2[ix],otherObject.currLocation);
		ASSERT(ix < 2500);
		if (d1 < radius2 || d2 < radius2 || d3 < radius2)
			ix++;
	}
	int otherNumTriangles = ix;

	// now get our vertices to check
	Point3 validVerticesStart[100];
	Point3 validVerticesEnd[100];
	int totalValidVertices = 0;

	double expandedCenter = otherObject.m_BoundingSphere.m_Radius2 + prevLinearAccel*prevLinearAccel + extraExp;
	for (ix = 0; ix < numPhysicsPoints; ix++)
	{
		double hypot2 = Point3::Hypot2(tPhysicsPoints[ix],otherObject.m_BoundingSphere.GetCenter() + otherObject.currLocation);
		if (hypot2 < expandedCenter)
		{
			validVerticesStart[totalValidVertices] = tPrevPhysicsPoints[ix];
 			validVerticesEnd[totalValidVertices] = tPhysicsPoints[ix];
			totalValidVertices++;
		}

	}

	for (ix = 0; ix < totalValidVertices; ix++)
	{
//		int	ix = 0;
		orig = validVerticesStart[ix];
		dir = validVerticesEnd[ix] - validVerticesStart[ix];
		dir.Normalize();

		for (int it = 0; it < otherNumTriangles; it++)
		{
			// k check each vertex-ray of this one against each triangle of the other one
			//otherObject.
			count++;
			
			if (IntersectTriangle(orig,dir,u0[it],u1[it],u2[it],intersection,t))
			{
				double tprevLinearAccel = prevLinearAccel;
				if (prevLinearAccel < 0)
					tprevLinearAccel = -tprevLinearAccel;
				// can't really use t because that is linear only and doesn't take into account the current
				// angle of the object need to use dist
				if (t < tprevLinearAccel && t > 0)
				{
				//	Beep(4000,30); 
					return true;
				}
				else
				{
					double dist = Point3::Hypot2(orig,intersection);
					double dist1 = Point3::Hypot2(validVerticesEnd[ix],validVerticesStart[ix]);
					if (dist < tprevLinearAccel)
					{
						int df = 23;
						return true;
					}
					if (dist < dist1)
					{
						int df = 23;
						return true;
					}
				}

			}
		}
	}

return false;
}

/////////////////////////////////////////////////////////////////////
// bool enumGetTriangle(Point3 &v0, Point3 &v1, Point3 &v2)
//
// Dumps all of the triangles of the object out
// only do the first object for now work on the other ones later
/////////////////////////////////////////////////////////////////////
bool DynamicObject::enumGetTriangle(Point3 &v0, Point3 &v1, Point3 &v2)
{
	if (enumCurrIndex == numFaces[0])
	{
		enumCurrIndex = 0; // zero the triangle count
		return false;
	}
	v0 = tPrevPhysicsPoints[(int)(loadFaces[0][enumCurrIndex].x)];
	v1 = tPrevPhysicsPoints[(int)(loadFaces[0][enumCurrIndex].y)];
	v2 = tPrevPhysicsPoints[(int)(loadFaces[0][enumCurrIndex].z)];

	enumCurrIndex++;
	
	return true;


}


/////////////////////////////////////////////////////////////////////
// int enumNumTriangle()
//
// returns the number of enum triangles
/////////////////////////////////////////////////////////////////////
int DynamicObject::enumNumTriangle()
{
	return numFaces[0];
}


/////////////////////////////////////////////////////////////////////
// void generateMovesCoords()
//
// This function transforms all of the vertices to their transformed versions
// e.g the object has moved and needs new vertices
/////////////////////////////////////////////////////////////////////
bool DynamicObject::generateMovesCoords(double deltaTime, bool forcePrevInput)
{
	Point3 tempCurrLocation = currLocation;
	double tempAngle = yAngle;

		prevRotation = phyAngularAccel*deltaTime;
	tempAngle += prevRotation;
	prevTranslation.x = phyLinearAccel*deltaTime*cos(tempAngle);
	prevTranslation.y = 0;
	prevTranslation.z = phyLinearAccel*deltaTime*sin(tempAngle);






	
	Matrix total,rotY,translation;


	if (forcePrevInput)
	{
		tempAngle = tempAngle - prevRotation + forcedRotation;
		MatrixRotationY(rotY,tempAngle);
		tempCurrLocation.x -= forcedTranslation.x + prevTranslation.x;
		tempCurrLocation.z += forcedTranslation.z + prevTranslation.z;
		MatrixTranslation(translation,tempCurrLocation.x,tempCurrLocation.y,tempCurrLocation.z);
		total = rotY*translation;
	}
	else
	{
		tempCurrLocation.x -= prevTranslation.x;
		tempCurrLocation.z += prevTranslation.z;
		MatrixRotationY(rotY,tempAngle);
		MatrixTranslation(translation,tempCurrLocation.x,tempCurrLocation.y,tempCurrLocation.z);
		total = rotY*translation;
	}




//	theProfiler.EnterStartTime();
	int totalV = 0;
	for (int iy = 0; iy <= currObject; iy++)
	{
		for (int ix = 0; ix < numTotalVertices; ix++)
		{
			tPrevPhysicsPoints[ix + totalV] = tPhysicsPoints[ix + totalV]; // store the old ones
			tPhysicsPoints[ix + totalV] = loadVertices[iy][ix]*total;

		}
		totalV += ix;
	}
	numPhysicsPoints = totalV;


	return true;
}


// the collision of 2 moving edges
// algorithm from Chin-Shyurng Fahn and Jui-Lung Wang
// t2 translation
// p1 = p3
// p2 = p4
// v1 = v3
// v2 = v4
bool DynamicObject::isCollision(Point3 p1, Point3 p2, Point3 p3, Point3 p4, Point3 v1, Point3 v2, Point3 v3, Point3 v4, Point3 &intersectionPoint)
{
	Matrix43 solveIt;
	Point3 v,p;
/*	p = p1;
	p1 = p3;
	p3 = p;
	p = p2;
	p2 = p4;
	p4 = p;
	v = v1;
	v1 = v3;
	v3 = v;
	v = v2;
	v2 = v4;
	v4 = v;*/

	solveIt._11 = (p4.y - p3.y)*(v2.x - v1.x) - (p4.x - p3.x)*(v2.y - v1.y);
	solveIt._12 = (p4.y - p3.y)*(p2.x - p1.x) - (p4.x - p3.x)*(p2.y - p1.y);
	solveIt._13 = (p4.y - p3.y)*v1.x - (p4.x - p3.x)*v1.y;
	solveIt._14 = -((p4.y - p3.y)*(p1.x - p3.x) - (p4.x - p3.x)*(p1.y - p3.y));
	solveIt._21 = (p4.z - p3.z)*(v2.y - v1.y) - (p4.y - p3.y)*(v2.z - v1.z);
	solveIt._22 = (p4.z - p3.z)*(p2.y - p1.y) - (p4.y - p3.y)*(p2.z - p1.z);
	solveIt._23 = (p4.z - p3.z)*v1.y - (p4.y - p3.y)*v1.z;
	solveIt._24 = -((p4.z - p3.z)*(p1.y - p3.y) - (p4.y - p3.y)*(p1.z - p3.z));
	solveIt._31 = (p4.x - p3.x)*(v2.z - v1.z) - (p4.z - p3.z)*(v2.x - v1.x);
	solveIt._32 = (p4.x - p3.x)*(p2.z - p1.z) - (p4.z - p3.z)*(p2.x - p1.x);
	solveIt._33 = (p4.x - p3.x)*v1.z - (p4.z - p3.z)*v1.x;
	solveIt._34 = -((p4.x - p3.x)*(p1.z - p3.z) - (p4.z - p3.z)*(p1.x - p3.x));

	Point3 tp1;
	ASSERT(solveIt.Solve(tp1));

	/*	p = p1;
	p1 = p3;
	p3 = p;
	p = p2;
	p2 = p4;
	p4 = p;
	v = v1;
	v1 = v3;
	v3 = v;
	v = v2;
	v2 = v4;
	v4 = v;*/

	solveIt._11 = (p2.y - p1.y)*(v4.x - v3.x) - (p2.x - p1.x)*(v4.y - v3.y);
	solveIt._12 = (p2.y - p1.y)*(p4.x - p3.x) - (p2.x - p1.x)*(p4.y - p3.y);
	solveIt._13 = (p2.y - p1.y)*v3.x - (p2.x - p1.x)*v3.y;
	solveIt._14 = -((p2.y - p1.y)*(p3.x - p1.x) - (p2.x - p1.x)*(p3.y - p1.y));
	solveIt._21 = (p2.z - p1.z)*(v4.y - v3.y) - (p2.y - p1.y)*(v4.z - v3.z);
	solveIt._22 = (p2.z - p1.z)*(p4.y - p3.y) - (p2.y - p1.y)*(p4.z - p3.z);
	solveIt._23 = (p2.z - p1.z)*v3.y - (p2.y - p1.y)*v3.z;
	solveIt._24 = -((p2.z - p1.z)*(p3.y - p1.y) - (p2.y - p1.y)*(p3.z - p1.z));
	solveIt._31 = (p2.x - p1.x)*(v4.z - v3.z) - (p2.z - p1.z)*(v4.x - v3.x);
	solveIt._32 = (p2.x - p1.x)*(p4.z - p3.z) - (p2.z - p1.z)*(p4.x - p3.x);
	solveIt._33 = (p2.x - p1.x)*v3.z - (p2.z - p1.z)*v3.x;
	solveIt._34 = -((p2.x - p1.x)*(p3.z - p1.z) - (p2.z - p1.z)*(p3.x - p1.x));

	Point3 tp2;
	ASSERT(solveIt.Solve(tp2));

	tp2.Abs();
	tp1.Abs();
	

	double tc = (tp1.z * tp2.z) / (tp1.z + tp2.z);

	Point3 collisionPoint;

	if (tc > 0 && tc < 1)
	{
		// we have a collision figure out where
		double t1 = -(p3.x + v3.x * tc);
		double b1 = p4.x - p3.x + (v4.x - v3.x)*tc;
		double t2 = -(p1.x + v1.x * tc);
		double b2 = p2.x - p1.x + (v2.x - v1.x)*tc;

		double tempo = tp2.y*b1/t1;

		if (b1 != 0 || b2 != 0)
			collisionPoint.x = (t1*b2 - b1*t2)/(b2-b1);
		else
			collisionPoint.x = p1.x + v1.x*tc;//(t1*b2 - b1*t2)/(b2-b1);
		t1 = -(p3.y + v3.y * tc);
		b1 = p4.y - p3.y + (v4.y - v3.y)*tc;
		t2 = -(p1.y + v1.y * tc);
		b2 = p2.y - p1.y + (v2.y - v1.y)*tc;
		if (b1 != 0 || b2 != 0)
			collisionPoint.y = (t1*b2 - b1*t2)/(b2-b1);
		else
			collisionPoint.y = p1.x + v1.x*tc;
	
		t1 = -(p3.z + v3.z * tc);
		b1 = p4.z - p3.z + (v4.z - v3.z)*tc;
		t2 = -(p1.z + v1.z * tc);
		b2 = p2.z - p1.z + (v2.z - v1.z)*tc;
		if (b1 != 0 || b2 != 0)
			collisionPoint.z = (t1*b2 - b1*t2)/(b2-b1);
		else
			collisionPoint.z = p1.z + v1.z*tc;
		collisionPoint.x = - collisionPoint.x;
		collisionPoint.y = - collisionPoint.y;
		collisionPoint.z = - collisionPoint.z;
		
		// check to see if we are on the edges though

		t1 = collisionPoint.z-(p3.z + v3.z * tc);
		b1 = p4.z - p3.z + (v4.z - v3.z)*tc;

		double max,min;

		double minBound = 0;

		bool pass = false;
		bool skip = false;
		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p4.z;
			min = p4.z;
			if (v4.z + p4.z > max)
				max = v4.z + p4.z;
			if (v4.z + p4.z < min)
				min = v4.z + p4.z;
			if (-v4.z + p4.z > max)
				max = v4.z + p4.z;
			if (-v4.z + p4.z < min)
				min = -v4.z + p4.z;
			if (v3.z + p3.z > max)
				max = v3.z + p3.z;
			if (v3.z + p3.z < min)
				min = v3.z + p3.z;
			if (-v3.z + p3.z > max)
				max = -v3.z + p3.z;
			if (-v3.z + p3.z < min)
				min = -v3.z + p3.z;
			if (collisionPoint.z >= min && collisionPoint.z <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}

		t1 = collisionPoint.y-(p3.y + v3.y * tc);
		b1 = p4.y - p3.y + (v4.y - v3.y)*tc;

		
		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p4.y;
			min = p4.y;
			if (v4.y + p4.y > max)
				max = v4.y + p4.y;
			if (v4.y + p4.y < min)
				min = v4.y + p4.y;
			if (-v4.y + p4.y > max)
				max = -v4.y + p4.y;
			if (-v4.y + p4.y < min)
				min = -v4.y + p4.y;
			if (v3.y + p3.y > max)
				max = v3.y + p3.y;
			if (v3.y + p3.y < min)
				min = v3.y + p3.y;
			if (-v3.y + p3.y > max)
				max = -v3.y + p3.y;
			if (-v3.y + p3.y < min)
				min = -v3.y + p3.y;
			if (collisionPoint.y >= min && collisionPoint.y <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}

		t1 = collisionPoint.x-(p3.x + v3.x * tc);
		b1 = p4.x - p3.x + (v4.x - v3.x)*tc;

		
		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p4.x;
			min = p4.x;
			if (v4.x + p4.x > max)
				max = v4.x + p4.x;
			if (v4.x + p4.x < min)
				min = v4.x + p4.x;
			if (-v4.x + p4.x > max)
				max = -v4.x + p4.x;
			if (-v4.x + p4.x < min)
				min = -v4.x + p4.x;
			if (v3.x + p3.x > max)
				max = v3.x + p3.x;
			if (v3.x + p3.x < min)
				min = v3.x + p3.x;
			if (-v3.x + p3.x > max)
				max = -v3.x + p3.x;
			if (-v3.x + p3.x < min)
				min = -v3.x + p3.x;
			if (collisionPoint.x >= min && collisionPoint.x <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}

		t1 = collisionPoint.z-(p1.z + v1.z * tc);
		b1 = p2.z - p1.z + (v2.z - v1.z)*tc;

		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p2.z;
			min = p2.z;
			if (v2.z + p2.z > max)
				max = v2.z + p2.z;
			if (v2.z + p2.z < min)
				min = v2.z + p2.z;
			if (-v2.z + p2.z > max)
				max = -v2.z + p2.z;
			if (-v2.z + p2.z < min)
				min = -v2.z + p2.z;
			if (v1.z + p1.z > max)
				max = v1.z + p1.z;
			if (v1.z + p1.z < min)
				min = v1.z + p1.z;
			if (-v1.z + p1.z > max)
				max = -v1.z + p1.z;
			if (-v1.z + p1.z < min)
				min = -v1.z + p1.z;
			if (collisionPoint.z >= min && collisionPoint.z <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}
	

		t1 = collisionPoint.y-(p1.y + v1.y * tc);
		b1 = p2.y - p1.y + (v2.y - v1.y)*tc;

		
		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p2.y;
			min = p2.y;
			if (v2.y + p2.y > max)
				max = v2.y + p2.y;
			if (v2.y + p2.y < min)
				min = v2.y + p2.y;
			if (-v2.y + p2.y > max)
				max = -v2.y + p2.y;
			if (-v2.y + p2.y < min)
				min = -v2.y + p2.y;
			if (v1.y + p1.y > max)
				max = v1.y + p1.y;
			if (v1.y + p1.y < min)
				min = v1.y + p1.y;
			if (-v1.y + p1.y > max)
				max = -v1.y + p1.y;
			if (-v1.y + p1.y < min)
				min = -v1.y + p1.y;
			if (collisionPoint.y >= min && collisionPoint.y <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}

		t1 = collisionPoint.x-(p1.x + v1.x * tc);
		b1 = p2.x - p1.x + (v2.x - v1.x)*tc;

	
		if (b1 != 0 && !skip)
		{
			double check = t1/b1;
			if (check >= minBound && check <= 1)
				pass = true;
			else
			{
				skip = true;
				pass = false;
			}
		}
		else if (!skip)
		{
			max = p2.x;
			min = p2.x;
			if (v2.x + p2.x > max)
				max = v2.x + p2.x;
			if (v2.x + p2.x < min)
				min = v2.x + p2.x;
			if (-v2.x + p2.x > max)
				max = -v2.x + p2.x;
			if (-v2.x + p2.x < min)
				min = -v2.x + p2.x;
			if (v1.x + p1.x > max)
				max = v1.x + p1.x;
			if (v1.x + p1.x < min)
				min = v1.x + p1.x;
			if (-v1.x + p1.x > max)
				max = -v1.x + p1.x;
			if (-v1.x + p1.x < min)
				min = -v1.x + p1.x;
			if (collisionPoint.x >= min && collisionPoint.x <= max)
				pass = true;
			else
			{
				pass = false;
				skip = true;
			}
		}

		Point3 v0d,v1d,v2d;

		// find the normal of edge
		Point3 normalCP;
		normalCP = collisionPoint;
		normalCP.Normalize();

		if (1)//pass)
		{
		pass = false;
		if (v1.x != 0 || v1.y != 0 || v1.z != 0)
		{

			v0d= p1;
			v1d= p1 + v1;
			v2d= p2;

			Point3 normal = (v0d - v1d)^(v0d - v2d);
			bool yes;
			yes = PointInTriangle(v0d,v1d,collisionPoint,normal);
			yes = PointInTriangle(v1d,v2d,collisionPoint,normal);
			yes = PointInTriangle(v2d,v0d,collisionPoint,normal);

			double one = Point3::Dot(collisionPoint,v0d);
			double two = Point3::Dot(collisionPoint,v1d);
			double three = Point3::Dot(collisionPoint,v2d);
		}

		if (v2.x != 0 || v2.y != 0 || v2.z != 0)
		{

			v0d = p1+v1;
			v1d = p2+v2;
			v2d = p2;

						Point3 normal = (v0d - v1d)^(v0d - v2d);
			bool yes;
			yes = PointInTriangle(v0d,v1d,collisionPoint,normal);
			yes = PointInTriangle(v1d,v2d,collisionPoint,normal);
			yes = PointInTriangle(v2d,v0d,collisionPoint,normal);

			double one = Point3::Dot(collisionPoint,v0d);
			double two = Point3::Dot(collisionPoint,v1d);
			double three = Point3::Dot(collisionPoint,v2d);
		}

		if (v3.x != 0 || v3.y != 0 || v3.z != 0)
		{

			v0d = p3;
			v1d = p3 + v3;
			v2d = p4;

						Point3 normal = (v0d - v1d)^(v0d - v2d);
			int count = 0;
			count += PointInTriangle(v0d,v1d,collisionPoint,normal);
			count += PointInTriangle(v1d,v2d,collisionPoint,normal);
			count += PointInTriangle(v2d,v0d,collisionPoint,normal);

			if (count == 0)
			{
				// take the midpoint of hte traingle and match it up
				Point3 tempo;
				double a = 0.3;
				double b=  0.3;
				double c = 0.4;
				tempo = v0d*a + v1d*b + v2d*c;

				count = 0;

				count += PointInTriangle(v0d,v1d,tempo,normal);
				count += PointInTriangle(v1d,v2d,tempo,normal);
				count += PointInTriangle(v2d,v0d,tempo,normal);


				pass = true;
			}

			Point3 s,e1,e2;

			double one = Point3::Dot(collisionPoint,v0d);
			double two = Point3::Dot(collisionPoint,v1d);
			double three = Point3::Dot(collisionPoint,v2d);
		}

		if (v4.x != 0 || v4.y != 0 || v4.z != 0)
		{

			v0d = p3 + v3;
			v1d = p4+v4;
			v2d = p4;

						Point3 normal = (v0d - v1d)^(v0d - v2d);
			int count = 0;
			count += PointInTriangle(v0d,v1d,collisionPoint,normal);
			count += PointInTriangle(v1d,v2d,collisionPoint,normal);
			count += PointInTriangle(v2d,v0d,collisionPoint,normal);

			if (count == 0)
			{
				// take the midpoint of hte traingle and match it up
				Point3 tempo;
				double a = 0.3;
				double b=  0.3;
				double c = 0.4;
				tempo = v0d*a + v1d*b + v2d*c;

				count = 0;

				count += PointInTriangle(v0d,v1d,tempo,normal);
				count += PointInTriangle(v1d,v2d,tempo,normal);
				count += PointInTriangle(v2d,v0d,tempo,normal);


				pass = true;
			}
			double one = Point3::Dot(collisionPoint,v0d);
			double two = Point3::Dot(collisionPoint,v1d);
			double three = Point3::Dot(collisionPoint,v2d);
		}
		}

		




	





		if (pass)
			int df = 34;

		intersectionPoint = collisionPoint;


		return pass;

	}

	

	return false;
}

bool DynamicObject::isIntersectionQuick(DynamicObject &otherObject)
{
	Point3 v0[2500];
	Point3 v1[2500];
	Point3 v2[2500];
	Point3 u0[2500];
	Point3 u1[2500];
	Point3 u2[2500];

//	theProfiler.EnterStartTime();
					int index = theProfiler.getTimeBlockIndex("Physics3");
		theProfiler.startTiming(index);



	int ix = 0;
	double radius2 = m_BoundingSphere.m_Radius2;
	while (otherObject.enumGetTriangle(v0[ix],v1[ix],v2[ix]))
	{
		double d1 = Point3::Hypot2(v0[ix],currLocation);
		double d2 = Point3::Hypot2(v1[ix],currLocation);
		double d3 = Point3::Hypot2(v2[ix],currLocation);
		ASSERT(ix < 2500);
		if (d1 < radius2 || d2 < radius2 || d3 < radius2)
			ix++;
	}
	int ourNumTriangles = ix;


	ix = 0;
	radius2 = otherObject.m_BoundingSphere.m_Radius2;
	while (enumGetTriangle(u0[ix],u1[ix],u2[ix]))
	{
		
		double d1 = Point3::Hypot2(u0[ix],otherObject.currLocation);
		double d2 = Point3::Hypot2(u1[ix],otherObject.currLocation);
		double d3 = Point3::Hypot2(u2[ix],otherObject.currLocation);
		ASSERT(ix < 2500);
		if (d1 < radius2 || d2 < radius2 || d3 < radius2)
			ix++;
	}
	int otherNumTriangles = ix;

	//	theProfiler.EnterEndTime();
	//		double time = theProfiler.GetExecutionTime();

	theProfiler.stopTiming(index);
	for (ix = 0; ix < ourNumTriangles; ix++)
	{
		for (int iy = 0; iy < otherNumTriangles; iy++)
		{
			float tv0[3];
			float tv1[3];
			float tv2[3];
			float tu0[3];
			float tu1[3];
			float tu2[3];
			tv0[0] = (float)v0[ix].x;
			tv0[1] = (float)v0[ix].y;
			tv0[2] = (float)v0[ix].z;
			tv1[0] = (float)v1[ix].x;
			tv1[1] = (float)v1[ix].y;
			tv1[2] = (float)v1[ix].z;
			tv2[0] = (float)v2[ix].x;
			tv2[1] = (float)v2[ix].y;
			tv2[2] = (float)v2[ix].z;
			tu0[0] = (float)u0[iy].x;
			tu0[1] = (float)u0[iy].y;
			tu0[2] = (float)u0[iy].z;
			tu1[0] = (float)u1[iy].x;
			tu1[1] = (float)u1[iy].y;
			tu1[2] = (float)u1[iy].z;
			tu2[0] = (float)u2[iy].x;
			tu2[1] = (float)u2[iy].y;
			tu2[2] = (float)u2[iy].z;
			if (NoDivTriTriIsect(tv0,tv1,tv2,tu0,tu1,tu2))
			{
				theProfiler.EnterEndTime("quickInter");
				double time = theProfiler.GetExecutionTime("quickInter");
				return true;
			//	Beep(300,10);
			}
		}
	}
	theProfiler.EnterEndTime();
	double time = theProfiler.GetExecutionTime();
	return false;


}

// checks each edge to see if there is a dynamic collision
bool DynamicObject::isEdgeCollision(DynamicObject &otherObject, double deltaTime, Point3 &intersectionPoint)
{
		Point3 v0[2500];
	Point3 v1[2500];
	Point3 v2[2500];
	Point3 u0[2500];
	Point3 u1[2500];
	Point3 u2[2500];

	bool foundCollision = false;
	intersectionPoint.x = 9999999.9;
	intersectionPoint.y = 9999999.9;
	intersectionPoint.z = 9999999.9;

	theProfiler.EnterStartTime("quickInter");
		theProfiler.EnterEndTime("quickInter");
	double time = theProfiler.GetExecutionTime("quickInter");



	int ix = 0;
	double radius2 = m_BoundingSphere.m_Radius2;
	while (otherObject.enumGetTriangle(v0[ix],v1[ix],v2[ix]))
	{
		double d1 = Point3::Hypot2(v0[ix],currLocation);
		double d2 = Point3::Hypot2(v1[ix],currLocation);
		double d3 = Point3::Hypot2(v2[ix],currLocation);
		if (d1 < radius2 || d2 < radius2 || d3 < radius2)
			ix++;
	}
	int ourNumTriangles = ix;


	ix = 0;
	radius2 = otherObject.m_BoundingSphere.m_Radius2;
	while (enumGetTriangle(u0[ix],u1[ix],u2[ix]))
	{
		
		double d1 = Point3::Hypot2(u0[ix],otherObject.currLocation);
		double d2 = Point3::Hypot2(u1[ix],otherObject.currLocation);
		double d3 = Point3::Hypot2(u2[ix],otherObject.currLocation);
		if (d1 < radius2 || d2 < radius2 || d3 < radius2)
			ix++;
	}
	int otherNumTriangles = ix;


	Point3 moveVector;
	Point3 zeroMove;
		
	moveVector.x = linearAccel*deltaTime*cos(yAngle);
	moveVector.z = linearAccel*deltaTime*sin(yAngle);
	moveVector.y = 0;
	zeroMove.x = 0;
	zeroMove.y = 0;
	zeroMove.z = 0;
	Point3 p1,p2,p3,p4;


	for (ix = 0; ix < ourNumTriangles; ix++)
	{
		for (int iz = 0; iz < 3; iz++)
		{
			if (iz == 0)
			{
				p1 = u0[ix];
				p2 = u1[ix];
			}
			else if (iz == 1)
			{
				p1 = u0[ix];
				p2 = u2[ix];
			}
			else
			{
				p1 = u1[ix];
				p2 = u2[ix];
			}
			for (int iy = 0; iy < otherNumTriangles; iy++)
			{		
				for (int it = 0; it < 3; it++)
				{
					if (it == 0)
					{
						p3 = v0[iy];
						p4 = v1[iy];
					}
					else if (it == 1)
					{
						p3 = v0[iy];
						p4 = v2[iy];
					}
					else
					{
						p3 = v1[iy];
						p4 = v2[iy];
					}		
					Point3 tempIntersectionPoint;					
					if (isCollision(p3,p4,p1,p2,zeroMove,zeroMove,moveVector,moveVector,tempIntersectionPoint))
					{
						double d1 = Point3::Hypot(tempIntersectionPoint,this->currLocation);
						double d2 = Point3::Hypot(intersectionPoint,this->currLocation);
						if (d1 < d2)
							intersectionPoint = tempIntersectionPoint;
						foundCollision = true;
					
					}
				}
			}
		}
	}
	return foundCollision;
}

bool DynamicObject::PointInTriangle(Point3 pt1, Point3 pt2, Point3 pt3, Point3 norm)
{
   float testi, testj, testk;
   float dotprod;


   // normal of trinagle
   testi = (((pt2.y - pt1.y)*(pt3.z - pt1.z)) - ((pt3.y - pt1.y)*(pt2.z - pt1.z)));
   testj = (((pt2.z - pt1.z)*(pt3.x - pt1.x)) - ((pt3.z - pt1.z)*(pt2.x - pt1.x)));
   testk = (((pt2.x - pt1.x)*(pt3.y - pt1.y)) - ((pt3.x - pt1.x)*(pt2.y - pt1.y)));

   // Dot product with triangle normal
   dotprod = testi*norm.x + testj*norm.y + testk*norm.z;

   //answer
   if(dotprod < 0) 
	   return true;
   return false;


}

//=======================================================
// MoveObject(double deltaTime)
//
// move object, don't care about collisions
//
// deltaTime is the movement time
// moveback means reverse the movement (e.g collision has occured can't go
// any further
//=======================================================
void DynamicObject::MoveObject(double deltaTime, bool moveBack)
{
	if (moveBack)
	{
		currLocation.x += linearAccel*deltaTime*cos(yAngle);
		currLocation.z -= linearAccel*deltaTime*sin(yAngle);
		yAngle -= angularAccel*deltaTime;
	}
	else
	{
		currLocation.x -= linearAccel*deltaTime*cos(yAngle);
		currLocation.z += linearAccel*deltaTime*sin(yAngle);
		yAngle += angularAccel*deltaTime;
	}

}

// set the values for the physics conversion
void DynamicObject::SetMovement(double linearAccel, double angleAccel)
{
	phyAngularAccel = angleAccel;
	phyLinearAccel = linearAccel;

}

void DynamicObject::GetMovement(Point3 &translation, double &rotation)
{
	translation = prevTranslation;
	rotation = prevRotation;
}

void DynamicObject::SetMovement(Point3 translation, double rotation)
{
	forcedTranslation = translation;
	forcedRotation = rotation;
}
