// LightMaps.cpp: implementation of the LightMaps class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "LightMaps.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

LightMaps theLightMaps;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

LightMaps::LightMaps()
{

}

LightMaps::~LightMaps()
{
	lightList1::iterator curr = lightList.begin();
	lightList1::iterator end = lightList.end();					
	while (curr != end)
	{					
		delete (*curr);
		curr++;
	}

}

void LightMaps::AddLight(GenericLight *theLight)
{
	lightList.push_back(theLight);

}

// creates a light map given 4 vertices, returns the index of the light map index (texture ID)
int LightMaps::CreateLightMap(Point3 &v1, Point3 &v2, Point3 &v3, Point3 &v4)
{
	int textureID;
	int height = 16;
	int width = 16;
	LPDIRECT3DTEXTURE8 ppLightMap;
	D3DLOCKED_RECT LockedRect;
	if (!theVTManager.GetLightMapTexture(height,width,ppLightMap,textureID))
		return -1;

	// k now figure out the light map

	// first thing to do is to figure out which plane to map to.  Get the surface normal
	// and us this information
	Point3 normal;
	Point3 edge1,edge2;
	edge1 = v1 - v2;
	edge2 = v1 - v3;
	normal = edge1^edge2;
	Point3 absNormal;
	absNormal = normal;
	absNormal.Abs();

	float u[4];
	float v[4];
	int flag;
	// get the u and v coords
	if ((absNormal.x > absNormal.y) && (absNormal.x > absNormal.z))
	{
		// map to YZ plane
		u[0] = v1.z;
		v[0] = v1.y;
		u[1] = v2.z;
		v[1] = v2.y;
		u[2] = v3.z;
		v[2] = v3.y;
		u[3] = v4.z;
		v[3] = v4.y;
		flag = 1;

	}
	else if ((absNormal.y > absNormal.z) && (absNormal.y > absNormal.x))
	{
		// map to XZ plane
		u[0] = v1.x;
		v[0] = v1.z;
		u[1] = v2.x;
		v[1] = v2.z;
		u[2] = v3.x;
		v[2] = v3.z;
		u[3] = v4.x;
		v[3] = v4.z;
		flag = 2;
	}
	else
	{
		// map to YX plane
		u[0] = v1.x;
		v[0] = v1.y;
		u[1] = v2.x;
		v[1] = v2.y;
		u[2] = v3.x;
		v[2] = v3.y;
		u[3] = v4.x;
		v[3] = v4.y;
		flag = 3;
	}

	float uMax = u[0];
	float uMin = u[0];
	float vMax = v[0];
	float vMin = v[0];

	// figure out the min and max u and v
	for (int ix = 1; ix < 4; ix++)
	{
		if (u[ix] > uMax)
			uMax = u[ix];
		if (u[ix] < uMin)
			uMin = u[ix];

		if (v[ix] > vMax)
			vMax = v[ix];
		if (v[ix] < vMin)
			vMin = v[ix];
	}

	// now map all the u and v between 0 and 1 as texture coords are

	float uDelta = uMax - uMin;
	float vDelta = vMax - vMin;

	for (ix = 0; ix < 4; ix++)
	{
		u[ix] = (u[ix] - uMin) / uDelta;
		v[ix] = (v[ix] - vMin) / vDelta;
	}

	// get d to form the plane equation
	float Distance = -Point3::Dot(normal,v1);
	Point3 UVVector,Vect1,Vect2;

	// now get the two edge vectors to interpolate the coord of the texture light map
	if (flag == 1)
	{
		if (normal.x > 0)
		{
            int X = - ( normal.y * vMax + normal.z * uMin + Distance ) /
 		normal.x;
            UVVector.x = X;
            UVVector.y = vMax;
            UVVector.z = uMin;
            X = - ( normal.y * vMax + normal.z * uMax + Distance ) /
 		normal.x;
            Vect1.x = X;
            Vect1.y = vMax;
            Vect1.z = uMax;
            X = - ( normal.y * vMin + normal.z * uMin + Distance ) /
 		normal.x;
            Vect2.x = X;
            Vect2.y = vMin;
            Vect2.z = uMin;
		}
		else
		{
			 int X = - ( normal.y * vMax + normal.z * uMax + Distance ) /
 		normal.x;
            UVVector.x = X;
            UVVector.y = vMax;
            UVVector.z = uMax;
            X = - ( normal.y * vMax + normal.z * uMin + Distance ) /
 		normal.x;
            Vect1.x = X;
            Vect1.y = vMax;
            Vect1.z = uMin;
            X = - ( normal.y * vMin + normal.z * uMax + Distance ) /
 		normal.x;
            Vect2.x = X;
            Vect2.y = vMin;
            Vect2.z = uMax;
		}

	}
	else if (flag == 2)
	{	
		if (normal.y > 0)
		{
            int Y = - ( normal.x * uMin + normal.z * vMax + Distance ) /
 		normal.y;
            UVVector.x = uMin;
            UVVector.y = Y;
            UVVector.z = vMax;
            Y = - ( normal.x * uMax + normal.z * vMax + Distance ) /
 		normal.y;
            Vect1.x = uMax;
            Vect1.y = Y;
            Vect1.z = vMax;
            Y = - ( normal.x * uMin + normal.z * vMin + Distance ) /
 		normal.y;
            Vect2.x = uMin;
            Vect2.y = Y;
            Vect2.z = vMin;
		}
		else
		{
			 int Y = - ( normal.x * uMax + normal.z * vMax + Distance ) /
 		normal.y;
            UVVector.x = uMax;
            UVVector.y = Y;
            UVVector.z = vMax;
            Y = - ( normal.x * uMin + normal.z * vMax + Distance ) /
 		normal.y;
            Vect1.x = uMin;
            Vect1.y = Y;
            Vect1.z = vMax;
            Y = - ( normal.x * uMax + normal.z * vMin + Distance ) /
 		normal.y;
            Vect2.x = uMax;
            Vect2.y = Y;
            Vect2.z = vMin;
		}
	}
	else if (flag == 3)
	{
		if (normal.z < 0)
		{
				int Z = - ( normal.x * uMin + normal.y * vMax + Distance ) /
 			normal.z;
				
				UVVector.x = uMin;
				UVVector.y = vMax;
				UVVector.z = Z;
				Z = - ( normal.x * uMax + normal.y * vMax + Distance ) /
 			normal.z;
				Vect1.x = uMax;
				Vect1.y = vMax;
				Vect1.z = Z;
				Z = - ( normal.x * uMin + normal.y * vMin + Distance ) /
 			normal.z;
				Vect2.x = uMin;
				Vect2.y = vMin;
				Vect2.z = Z;
		}
		else
		{
					int Z = - ( normal.x * uMin + normal.y * vMax + Distance ) /
 			normal.z;
				
				UVVector.x = uMax;
				UVVector.y = vMax;
				UVVector.z = Z;
				Z = - ( normal.x * uMin + normal.y * vMax + Distance ) /
 			normal.z;
				Vect1.x = uMin;
				Vect1.y = vMax;
				Vect1.z = Z;
				Z = - ( normal.x * uMax + normal.y * vMin + Distance ) /
 			normal.z;
				Vect2.x = uMax;
				Vect2.y = vMin;
				Vect2.z = Z;
		}

	}

    edge1.x = Vect1.x - UVVector.x;
    edge1.y = Vect1.y - UVVector.y;
    edge1.z = Vect1.z - UVVector.z;
    edge2.x = Vect2.x - UVVector.x;
    edge2.y = Vect2.y - UVVector.y;
    edge2.z = Vect2.z - UVVector.z;

	normal.Normalize();
	if (!FAILED(ppLightMap->LockRect(0,&LockedRect,NULL,D3DLOCK_NOSYSLOCK  )))
	{
		Point3 point,newedge1,newedge2;
		int *pBitMap;
		pBitMap = (int *)(LockedRect.pBits);
		for(int iX = 0; iX < width+1; iX++)		
		{
				for(int iY = 0; iY < height; iY++)	
				{
					float ufactor,vfactor;
					if (flag == 2)
					{
						 vfactor = (iX / (float)width);
						 ufactor = (iY / (float)height);
					}
					else if (flag == 1)
					{
						 vfactor = (( iX) / (float)width);
						 ufactor = ((iY) / (float)height);
					}
					else
					{
						 vfactor = ((iX) / (float)width);
						 ufactor = (iY / (float)height);
					}
					newedge1.x = edge1.x * ufactor;
					newedge1.y = edge1.y * ufactor;
					newedge1.z = edge1.z * ufactor;
					newedge2.x = edge2.x * vfactor;
					newedge2.y = edge2.y * vfactor;
					newedge2.z = edge2.z * vfactor;

					point.x = UVVector.x + newedge2.x + newedge1.x;
					point.y = UVVector.y + newedge2.y + newedge1.y;
					point.z = UVVector.z + newedge2.z + newedge1.z;

					// now that we have the point, calculate the light values and 
					// copy that into the bitmap
					*pBitMap = 0;
					lightList1::iterator curr = lightList.begin();
					lightList1::iterator end = lightList.end();					
					while (curr != end)
					{				
						// first check if the light reaches the object
						*pBitMap +=(*curr)->GetLightColor(point,normal);
						if (*pBitMap != 0)
						{
							Point3 org = point + ((*curr)->m_Location - point)*0.001;
							if (!octTreePtr->RayTraceCollision(org,(*curr)->m_Location))
							{
								int tempo = 34;
							}
							else
							{
								*pBitMap = 0;
								int df = 23;
							}
						}
						curr++;
					}					
					pBitMap++;

				}
				pBitMap = (int *)(LockedRect.pBits) + LockedRect.Pitch*(iX)/4;
		}
		ppLightMap->UnlockRect(0);
	}

	return textureID;
}
