// Matrix.cpp: implementation of the Matrix class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "Matrix.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Matrix::Matrix()
{

}

Matrix::~Matrix()
{

}

Matrix Matrix::operator * ( CONST Matrix& RHS) const
{
	Matrix tempo;

	
	tempo._11 = this->_11*RHS._11 + this->_12*RHS._21 + this->_13*RHS._31 + this->_14*RHS._41;
	tempo._12 = this->_11*RHS._12 + this->_12*RHS._22 + this->_13*RHS._32 + this->_14*RHS._42;
	tempo._13 = this->_11*RHS._13 + this->_12*RHS._23 + this->_13*RHS._33 + this->_14*RHS._43;
	tempo._14 = this->_11*RHS._14 + this->_12*RHS._24 + this->_13*RHS._34 + this->_14*RHS._44;

	tempo._21 = this->_21*RHS._11 + this->_22*RHS._21 + this->_23*RHS._31 + this->_24*RHS._41;
	tempo._22 = this->_21*RHS._12 + this->_22*RHS._22 + this->_23*RHS._32 + this->_24*RHS._42;
	tempo._23 = this->_21*RHS._13 + this->_22*RHS._23 + this->_23*RHS._33 + this->_24*RHS._43;
	tempo._24 = this->_21*RHS._14 + this->_22*RHS._24 + this->_23*RHS._34 + this->_24*RHS._44;

	tempo._31 = this->_31*RHS._11 + this->_32*RHS._21 + this->_33*RHS._31 + this->_34*RHS._41;
	tempo._32 = this->_31*RHS._12 + this->_32*RHS._22 + this->_33*RHS._32 + this->_34*RHS._42;
	tempo._33 = this->_31*RHS._13 + this->_32*RHS._23 + this->_33*RHS._33 + this->_34*RHS._43;
	tempo._34 = this->_31*RHS._14 + this->_32*RHS._24 + this->_33*RHS._34 + this->_34*RHS._44;

	tempo._41 = this->_41*RHS._11 + this->_42*RHS._21 + this->_43*RHS._31 + this->_44*RHS._41;
	tempo._42 = this->_41*RHS._12 + this->_42*RHS._22 + this->_43*RHS._32 + this->_44*RHS._42;
	tempo._43 = this->_41*RHS._13 + this->_42*RHS._23 + this->_43*RHS._33 + this->_44*RHS._43;
	tempo._44 = this->_41*RHS._14 + this->_42*RHS._24 + this->_43*RHS._34 + this->_44*RHS._44;

	return tempo;
}

void MatrixRotationX(Matrix &result, double angle)
{
	result._11 = 1;
	result._21 = result._31 = result._41= 0;
	result._12 = result._42 = 0;
	result._22 = cos(angle);
	result._32 = -sin(angle);
	result._13 = result._43 = 0;
	result._23 = sin(angle);
	result._33 = cos(angle);
	result._44 = 1;
	result._24 = result._34 = result._14 = 0;
}

void MatrixRotationY(Matrix &result, double angle)
{
	result._11 = cos(angle);
	result._31 = sin(angle);
	result._21 = result._41 = 0;
	result._12 = result._32 = result._42 = 0;
	result._22 = 1;
	result._13 = -sin(angle);
	result._33 = cos(angle);
	result._23 = result._43 = 0;
	result._44 = 1;
	result._24 = result._34 = result._14 = 0;
}
void MatrixRotationZ(Matrix &result, double angle)
{
	result._11 = cos(angle);
	result._21 = -sin(angle);
	result._31 = result._41 = 0;
	result._12 = sin(angle);
	result._22 = cos(angle);
	result._32 = result._42 = 0;
	result._13 = result._23 = result._43 = 0;
	result._33 = 1;
	result._44 = 1;
	result._24 = result._34 = result._14 = 0;
}

void MatrixTranslation(Matrix &result, double x, double y, double  z)
{

	result._11 = result._22 = result._33 = result._44 = 1;
	result._41 = x;
	result._42 = y;
	result._43 = z;

	result._21 = result._31 = 0;
	result._12 = result._32 = 0;
	result._13 = result._23 = 0;
	result._14 = result._24 = result._34 = 0;
}
