// Matrix43.cpp: implementation of the Matrix43 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "Matrix43.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Matrix43::Matrix43()
{

}

Matrix43::~Matrix43()
{

}

// matrix is in this form
// _11 _12 _13
// _21 _22 _23
// _31 _32 _33
//
//
bool Matrix43::Solve(Point3 &solution)
{
	Matrix33 bottom;
	bottom._11 = _11;
	bottom._12 = _12;
	bottom._13 = _13;
	bottom._21 = _21;
	bottom._22 = _22;
	bottom._23 = _23;
	bottom._31 = _31;
	bottom._32 = _32;
	bottom._33 = _33;
	double bottomDet = bottom.Determinate();

	// k the matrix might contain 0 as an answer check out for other solutions
	if (bottomDet == 0)
	{
		if ((_11 == 0) &&  (_21 == 0) && (_31 == 0))
		{
			//k get rid of this column, solve a 2 by 2 with the first two
			Matrix23 solveIt;
			int counter = 0;
			if (_12 != 0 || _13 != 0)
			{
				counter++;
				solveIt._11 = _12;
				solveIt._12 = _13;
				solveIt._13 = _14;
			}
			if (_22 != 0 || _23 != 0)
			{
				counter++;
				if (counter == 0)
				{
					solveIt._11 = _22;
					solveIt._12 = _23;
					solveIt._13 = _24;
				}
				else
				{
					solveIt._21 = _22;
					solveIt._22 = _23;
					solveIt._23 = _24;
					if (solveIt.Solve(solution))
					{
						solution.z = solution.y;
						solution.y = solution.x;
						solution.x = 0;
						return true;
					}
					else
						return false;
				}
			}
			else
			{			
				solveIt._21 = _32;
				solveIt._22 = _33;
				solveIt._23 = _34;
				if (solveIt.Solve(solution))
				{
					solution.z = solution.y;
					solution.y = solution.x;
					solution.x = 0;
					return true;
				}
				else
					return false;
			}		
		}	
		else if ((_12 == 0) &&  (_22 == 0) && (_32 == 0))
		{
			//k get rid of this column, solve a 2 by 2 with the first two
			Matrix23 solveIt;
			int counter = 0;
			if (_11 != 0 || _13 != 0)
			{
				counter++;
				solveIt._11 = _11;
				solveIt._12 = _13;
				solveIt._13 = _14;
			}
			if (_21 != 0 || _23 != 0)
			{
				counter++;
				if (counter == 0)
				{
					solveIt._11 = _21;
					solveIt._12 = _23;
					solveIt._13 = _24;
				}
				else
				{
					solveIt._21 = _21;
					solveIt._22 = _23;
					solveIt._23 = _24;
					if (solveIt.Solve(solution))
					{
						solution.z = solution.y;
						solution.y = 0;					
						return true;
					}
					else
						return false;
				}
			}
			else
			{			
				solveIt._21 = _31;
				solveIt._22 = _33;
				solveIt._23 = _34;
				if (solveIt.Solve(solution))
				{
					solution.z = solution.y;
					solution.y = 0;	
					return true;
				}
				else
					return false;
			}		
		}
		else if ((_13 == 0) &&  (_23 == 0) && (_33 == 0))
		{
			//k get rid of this column, solve a 2 by 2 with the first two
			Matrix23 solveIt;
			int counter = 0;
			if (_11 != 0 || _12 != 0)
			{
				counter++;
				solveIt._11 = _11;
				solveIt._12 = _12;
				solveIt._13 = _14;
			}
			if (_21 != 0 || _22 != 0)
			{
				counter++;
				if (counter == 0)
				{
					solveIt._11 = _21;
					solveIt._12 = _22;
					solveIt._13 = _24;
				}
				else
				{
					solveIt._21 = _21;
					solveIt._22 = _22;
					solveIt._23 = _24;
					if (solveIt.Solve(solution))
					{
						solution.z = 0;					
						return true;
					}
					else
						return false;
				}
			}
			else
			{			
				solveIt._21 = _31;
				solveIt._22 = _32;
				solveIt._23 = _34;
				if (solveIt.Solve(solution))
				{
					solution.z = 0;		
					return true;
				}
				else
					return false;
			}		
		}
		else
			return false;
	}


	// k now do the 3 other determinates
	bottom._11 = _14;
	bottom._21 = _24;
	bottom._31 = _34;
	bottom._12 = _12;
	bottom._22 = _22;
	bottom._32 = _32;
	bottom._13 = _13;
	bottom._23 = _23;
	bottom._33 = _33;
	solution.x = bottom.Determinate()/bottomDet;

	bottom._11 = _11;
	bottom._21 = _21;
	bottom._31 = _31;
	bottom._12 = _14;
	bottom._22 = _24;
	bottom._32 = _34;
	bottom._13 = _13;
	bottom._23 = _23;
	bottom._33 = _33;
	solution.y = bottom.Determinate()/bottomDet;

	bottom._11 = _11;
	bottom._21 = _21;
	bottom._31 = _31;
	bottom._12 = _12;
	bottom._22 = _22;
	bottom._32 = _32;
	bottom._13 = _14;
	bottom._23 = _24;
	bottom._33 = _34;
	solution.z = bottom.Determinate()/bottomDet;	

	return true;

}

Matrix23::Matrix23()
{

}

Matrix23::~Matrix23()
{

}

// matrix is in this form
// _11 _12 _13
// _21 _22 _23
// _31 _32 _33
//
//
bool Matrix23::Solve(Point3 &solution)
{
	// use cramers rule to solve it
	double bottomDet = _11*_22 - _12*_21;
	solution.x = 0;
	if (bottomDet == 0)
	{
		// k if there is a column that is non zero just read out the answer
		// otherwise everything is 0
		if ((_11 == 0) && (_21 == 0))
		{
			solution.x = 0;
			if (_12 != 0)
				solution.y = _13/_12;
			else if (_22 != 0)
				solution.y = _23/_22;
			else
				return false;
			return true;
		}
		else
		{
			solution.y = 0;
			if (_11 != 0)
				solution.y = _13/_11;
			else if (_21 != 0)
				solution.y = _23/_21;
			else
				return false;
			return true;
		}
				

	}
	else
	{
		double xdet = _13*_22 - _12*_23;
		double ydet = _11*_23 - _21*_13;
		solution.x = xdet/bottomDet;
		solution.y = ydet/bottomDet;
		return true;
	}

	

}

Matrix33::Matrix33()
{

}

Matrix33::~Matrix33()
{

}

// matrix is in this form
// _11 _12 _13
// _21 _22 _23
// _31 _32 _33
//
//
double Matrix33::Determinate()
{
	double tReturn;
	tReturn = _11*((_22 * _33) - (_23 * _32));
	tReturn -= _12*((_21* _33) - (_31 * _23));
	tReturn += _13*((_21* _32) - (_31 * _22));

	return tReturn;

}

