// Model.h: interface for the Model class.
//
// This class loads a model from the jmesh style of file and loads
// it into an index buffer
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MODEL_H__6B9230C9_1875_4B0D_A0EA_1824D519614C__INCLUDED_)
#define AFX_MODEL_H__6B9230C9_1875_4B0D_A0EA_1824D519614C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include <d3dx8.h>
#include "stddef.h"

struct VERTEXSTRUCT
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
};

// Our custom FVF, which describes our custom vertex structure
#define VERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE )

// defines the token types
enum tokentype {intnum, floatnum, comma, semicolon,geometry
,objectname,filedesc,openbrace,closebrace,texturecoords,texturefilename,endoffile};

#define MAXOBJECTSPERFILE 50
#define CURRENTFILEVERSION 0.01
#define CURRENTFILEVERSIONB 0.02

class Model  
{
public:

	// called to load a file
	void Open(LPDIRECT3DDEVICE8 g_pd3dDevice, const char *fileName);

	// called externally to render
	void Render(LPDIRECT3DDEVICE8 g_pd3dDevice);

	// external closure of file
	void Close(); // memory release

	Model();
	virtual ~Model();

private:

	void Init(); // memory reset

	bool modelValidToRender; // don't want to render if we have nothing

	// the RD (recursive decent) parser functions (in aprox call order
	bool ParseFile(char *buffer);
	bool ParseFileHeader(char *&pBuffer, bool &isText);
	bool ParseFileObject(char *&pBuffer);
	bool ParseFileTextureInfo(char *&pBuffer);
	bool ParseFileGeometry(char *&pBuffer);

	// binary versions
	bool ParseFileTextureInfoB(char *&pBuffer);
	bool ParseFileObjectB(char *&pBuffer);
	bool ParseFileGeometryB(char *&pBuffer);

	bool globalReturnTrue; // so we return on an error, for convienance

	// parsing of text input the workhorse of the RD parser
	bool getNextToken(char *&buffer, char *token, tokentype &type);

	// interal load function
	void InitModel(LPDIRECT3DDEVICE8 g_pd3dDevice, const char *fileName);

	
	// D3D pointers
	LPDIRECT3DVERTEXBUFFER8 g_pVertices;
	LPDIRECT3DINDEXBUFFER8  g_pIndices;
	LPDIRECT3DTEXTURE8 m_pModelTexture[MAXOBJECTSPERFILE];
protected:

	// when loading (parsing the file) these structures are filled
	// and then later loaded into the vertex and index buffers
	// should be retained for the indexed rendering and collision detection
	int numTotalVertices;
	int numTotalFaces;
	int currFaces;
	int numVertices[MAXOBJECTSPERFILE];
	int numFaces[MAXOBJECTSPERFILE];
	Point3 *loadVertices[MAXOBJECTSPERFILE];
	Point3 *loadFaces[MAXOBJECTSPERFILE];
	Point3 *loadTextureCoords[MAXOBJECTSPERFILE];
	int currObject; // for loading
	char *textureFileName[MAXOBJECTSPERFILE];


};

#endif // !defined(AFX_MODEL_H__6B9230C9_1875_4B0D_A0EA_1824D519614C__INCLUDED_)
