// OctTree.h: interface for the OctTree class.
//
// A very ordinary inefficent octTree
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OCTTREE_H__80E52725_9A89_4E90_A877_8861C8462DAF__INCLUDED_)
#define AFX_OCTTREE_H__80E52725_9A89_4E90_A877_8861C8462DAF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "stddef.h"
#include <stack> 
#include <vector>
#include <list>
#include "BaseObject.h"
#include "AABB.h"
#include "Plane.h"


typedef std::list<BaseObject*> ObjectListT;

class OctTree  
{
	typedef class OctNode;
	typedef class OctNode *OctNodePtr;

	class OctNode
	{
		public:
			// 0 is North +Z, 1 is East +X, 2 is South -Z. 3 is West -X
			// 4 is Up +Y 5 is South -Y;
			OctNode *Neighbours[6];

			Plane NeighboursPlanes[6]; // precompute these to save time in the pick/collision detection
			                     // algorithms

			int m_NumofObjects;

			int TraversalFlag; // so we don't traverse twice
			int DebugPickFlag; // temp

			OctNode *Parent;
			// 0 is +X+Z+Y
			// 1 is -X+Z+Y
			// 2 is -X-Z+Y
			// 3 is +X-Z+Y
			// 4 is +X+Z+Y
			// 5 is -X+Z+Y
			// 6 is -X-Z+Y
			// 7 is +X-Z+Y
			OctNode *Children[8];

			FCube Area;

			// need to add objects list
			ObjectListT ObjectList;


			OctNode()
			{
				m_NumofObjects = 0;
				Neighbours[0] = Neighbours[1] = Neighbours[2] = Neighbours[3] 
					= Neighbours[4] = Neighbours[5] = NULL;
				Parent = NULL;
				Children[0] = Children[1] = Children[2] = Children[3]
					= Children[4] = Children[5] = Children[6] = Children[7] = NULL;

				TraversalFlag = 0;
				DebugPickFlag = 0;
			}

	};
public:
	void CreateLightMaps();
	bool RayTraceCollision(Point3 Org, Point3 Dest);
	BaseObject *DebugPickPointer;
	int DebugPickFlag;
	void DebugGetObject(Point3 Org, Point3 Dir);
	void DeleteObjectList(OctNodePtr OctNode);
	bool AddObject(BaseObject *theObject);
	void OctFindNeighbour(OctNodePtr &CurrentNode, int &CurrLevel);
	void OctJoinNeighbours();
	OctNodePtr GetOctNode(Point3 Point, int DepthLevel);
	void DebugRenderFormFace(LINEVERTEX *&pVertex, const Point3 Points[], int &VertexCount, const DWORD &Color);
	void DebugRenderFormCube(LINEVERTEX *&pVertex, const FCube &theCube, int &VertexCount, const DWORD &Color);
	void DebugRenderOctGrid(LINEVERTEX* &pVertex, int &VertexCount);
	void Init();
	OctNodePtr m_Root; // the root of the octtree
	int m_ZPartitions;
	int m_YPartitions;
	int m_XPartitions;

	// a stack is used to construct the oct tree
	struct ConstructOct
	{
		OctNodePtr NodePtr;
		int XSplitsLeft;
		int YSplitsLeft;
		int ZSplitsLeft;
	};

	std::stack<ConstructOct, std::vector<ConstructOct> > ConstructStack;

	OctTree();
	virtual ~OctTree();

};

#endif // !defined(AFX_OCTTREE_H__80E52725_9A89_4E90_A877_8861C8462DAF__INCLUDED_)
