// OmniLight.cpp: implementation of the OmniLight class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "OmniLight.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OmniLight::OmniLight()
{

}

OmniLight::~OmniLight()
{

}

DWORD OmniLight::GetLightColor(Point3 &point, Point3 &planeNormal)
{
	double att = 100;
	double distance = Point3::Hypot(point,m_Location);
	int R = (m_Color & 0x00ff0000) >> 16;
	int G = (m_Color & 0x0000ff00) >> 8;
	int B = m_Color & 0x000000ff;

	Point3 lightVector = point - m_Location;
	lightVector.Normalize();
	double cosAngle = -Point3::Dot(lightVector,planeNormal);
	if (cosAngle < 0)
		return 0;
	double atten = 10*cosAngle/distance;//((att-distance)/att);//*((att-distance)/att);
	if (distance > att)
	{
		R = 0;
		G = 0;
		B = 0;
	}
	else
	{
		R = (int)(R*atten);
		G = (int)(G*atten);
		B = (int)(B*atten);
	}

	return (R << 16 | G << 8 | B);
}

OmniLight::OmniLight(Point3 Location, DWORD Color)
{
	m_Location = Location;
	m_Color = Color;

}
