// Plane.cpp: implementation of the Plane class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "Plane.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Plane::Plane()
{
	A = B = C = D = 0;
}

Plane::~Plane()
{

}

Plane::Plane(Point3 v1, Point3 v2, Point3 v3)
{
	GeneratePlane(v1, v2, v3);
}


/////////////////////////////////////////////////////////
// void GeneratePlane(Point3 v1, Point3 v2, Point3 v3)
//
// Usage:
//   Generate a plane from 3 points
//
// Algorithm
//   Calculate the normal of two vectors (v2 -v1) (v3-v1)
//   The results are A,B,C and D = -Normal*anyPoint
void Plane::GeneratePlane(Point3 v1, Point3 v2, Point3 v3)
{
	Point3 Dir1,Dir2;

	Dir1.x = v2.x - v1.x;
	Dir1.y = v2.y - v1.y;
	Dir1.z = v2.z - v1.z;
	Dir2.x = v3.x - v1.x;
	Dir2.y = v3.y - v1.y;
	Dir2.z = v3.z - v1.z;

	Point3 Normal;
	Normal.x = Dir1.y * Dir2.z - Dir1.z * Dir2.y;
	Normal.y = Dir1.z * Dir2.x - Dir1.x * Dir2.z;
	Normal.z = Dir1.x * Dir2.y - Dir1.y * Dir2.x;

	D = -v1.x*Normal.x + -v1.y*Normal.y + -v1.z*Normal.z;
	A = Normal.x;
	B = Normal.y;
	C = Normal.z;

	// always keep D positive so the comparison routine works
	if (D < 0)
	{
		A = -A;
		B = -B;
		C = -C;
		D = -D;
	}

}


/////////////////////////////////////////////////////////
// Point3 RayIntersectPlane(Point3 O, Point3 D)
//
// Usage:
//   Returns the point of intersection between a ray and plane
//
// Algorithm
// 1) A ray is defined as R0 [X0,Y0,Z0] and RD [X1,Y1,Z1]
//     which can then be made into R(t) = R0 + t*RD
// 2) Solving for it yields
//       A(X0 + Xd * t) + B(Y0 + Yd * t) + (Z0 + Zd * t) + D = 0
//       t = -(AX0 + BY0 + CZ0 + D) / (AXd + BYd + CZd)
//       = -(Pn R0 + D) / (Pn  Rd)
// 3) First compute Pn Rd = Vd. If Vd = 0 then we are parallel and return error
// 4) V0 = -(Pn R0 + D) and compute t = V0 / Vd . 
//       If t < 0 then the ray intersects plane behind origin and we could ignore it
// 5) If still good then calculate the points and return 
//     Pi = [Xi Yi Zi] = [X0 + Xd * t Y0 + Yd * t Z0 + Zd * t]
//
bool Plane::RayIntersectPlane(Point3 &Out, Point3 Org, Point3 Dir)
{
	// 3)
	double Vd = A*Dir.x+B*Dir.y+C*Dir.z;
	if (Vd == 0)
		return false;

	// 4)
	double V0 = -(A*Org.x + B*Org.y + C*Org.z + D);
	double t = V0/Vd;

	if (t < 0)
		return false;

	// 5)
	Out.x = Org.x + t*Dir.x;
	Out.y = Org.y + t*Dir.y;
	Out.z = Org.z + t*Dir.z;

	return true;
}

bool Plane::PointOnPlane(Point3 Point)
{
	double tempo = A*Point.x + B*Point.y + C*Point.z + D;
	if (tempo < 0)
		tempo = -tempo;

	if (tempo < SMALLE)
		return true;

	return false;

}
