// Plane.h: interface for the Plane class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PLANE_H__09B7C334_BAA5_4700_B421_44A4B9ADC447__INCLUDED_)
#define AFX_PLANE_H__09B7C334_BAA5_4700_B421_44A4B9ADC447__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "stddef.h"

#define PLANEERRORVALUE -1 // error value

class Plane  
{
public:
	bool PointOnPlane(Point3 Point);
	bool RayIntersectPlane(Point3 &Out, Point3 Org, Point3 Dir);
	Plane();
	Plane(Point3 v1, Point3 v2, Point3 v3);
	void GeneratePlane(Point3 v1, Point3 v2, Point3 v3);
	virtual ~Plane();

	inline bool operator==(Plane &RHS)
	{
		if (RHS.A == A)
			if (RHS.B == B)
				if (RHS.C == C)
					if (RHS.D == D)
						return true;
		return false;
	}

	
private:
	double A,B,C,D;

};

#endif // !defined(AFX_PLANE_H__09B7C334_BAA5_4700_B421_44A4B9ADC447__INCLUDED_)
