// Profiler.cpp: implementation of the Profiler class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "Profiler.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


Profiler theProfiler; // global

Profiler::Profiler()
{
	 ::QueryPerformanceFrequency(&Frequency);
	 nextFreeBlock = 0; // int blocks to all free
	 addCurrentParent = -1;
	 addPrevBlock = -1;
	 currDisplayBlock = 0;
	 enumIndex = -1;
	 timingOffset = 0.000001;
	 // now register all of the profiler blocks
	 addProfilerBlock("Program",true);
	 addProfilerBlock("Physics",true);
	 addProfilerBlock("Physics1",false);
	 addProfilerBlock("Physics2",false);
	 addProfilerBlock("Physics3",false);
	 closeParentGroup();
	 addProfilerBlock("Rendering",true);
	 addProfilerBlock("Rendering1",false);
	 addProfilerBlock("Rendering2",false);
	 closeParentGroup();
	 closeParentGroup();
}

//=================================================================
// addProfilerBlock(CString name, bool isGroup)
//
// This function adds a profiler block to the list by name.
//
// if isGroup is true it creates a new heiarachy, otherwise it adds
// it to the group
//=================================================================
void Profiler::addProfilerBlock(CString name, bool isGroup)
{
	profilerBlock[maxIndex].currIndex = maxIndex;
	profilerBlock[maxIndex].quantaTime = 0;
	profilerBlock[maxIndex].totalTime = 0;
	profilerBlock[maxIndex].quantaPerRun = 0;
	profilerBlock[maxIndex].name = name;
	profilerBlock[maxIndex].parentIndex = -1;
	profilerBlock[maxIndex].childIndex = -1;
	profilerBlock[maxIndex].siblingIndex = -1;

	if (isGroup)
	{
		if (addCurrentParent != -1)
		{
			if (profilerBlock[addCurrentParent].childIndex == -1)
				profilerBlock[addCurrentParent].childIndex = maxIndex;
			else
			{
				// find the sibling to attach it too
				int tempIndex = profilerBlock[addCurrentParent].childIndex;	
				int trackIndex;
				while (tempIndex != -1)
				{
					trackIndex = tempIndex;
					tempIndex = profilerBlock[tempIndex].siblingIndex;
				}
				profilerBlock[trackIndex].siblingIndex = maxIndex;
			}
		}
		profilerBlock[maxIndex].parentIndex = addCurrentParent;
		addCurrentParent = maxIndex; // make this one the new parent	
	}
	else
	{
		if (addPrevBlock == addCurrentParent)
		{
			// k we are the first sibling
			profilerBlock[maxIndex].parentIndex  = addCurrentParent;
			profilerBlock[addCurrentParent].childIndex = maxIndex; // link to parent			
		}
		else
		{
			// k attach to sibling
			profilerBlock[addPrevBlock].siblingIndex = maxIndex;
			profilerBlock[maxIndex].parentIndex  = addCurrentParent;			
		}
	}
	addPrevBlock = maxIndex;
	maxIndex++;
}

//=================================================================
// closeParentGroup()
//
// This function closes a group
//=================================================================
void Profiler::closeParentGroup()
{
	addCurrentParent = profilerBlock[addCurrentParent].parentIndex;
	// now go down the chain to get the sibling to make into addPrevBlock
	int tempIndex = profilerBlock[addCurrentParent].childIndex;
	tempIndex = profilerBlock[addCurrentParent].siblingIndex;
	addPrevBlock = addCurrentParent; // just in case there are no kids yet
	while (tempIndex != -1)
	{
		addPrevBlock = tempIndex;
		tempIndex = profilerBlock[tempIndex].siblingIndex;
	}
}

//=================================================================
// bool enumProfiler(char *&returnString)
//
// This function goes through the heiarchy group and returns a string which
// can be displayed
//=================================================================
bool Profiler::enumProfiler(char *returnString)
{
	// k start a new profile index
	if (enumIndex == -1)
	{
		sprintf(returnString,"Profile Data, group %s %2.8f",profilerBlock[currDisplayBlock].name,profilerBlock[currDisplayBlock].quantaTime);
		enumIndex = profilerBlock[currDisplayBlock].childIndex;
		profilerBlock[currDisplayBlock].quantaTime = 0;
		profilerBlock[currDisplayBlock].quantaPerRun = 0;
	}
	else
	{
		// k display the current block
		sprintf(returnString,"%s takes up %2.8f time %d times"
			,profilerBlock[enumIndex].name,profilerBlock[enumIndex].quantaTime,profilerBlock[enumIndex].quantaPerRun);
		profilerBlock[enumIndex].quantaTime = 0;
		profilerBlock[enumIndex].quantaPerRun = 0;
		enumIndex = profilerBlock[enumIndex].siblingIndex;
		
	}
	if (enumIndex == -1)
		return false;
	return true;
}

//=================================================================
// void selectDisplayItem(int item)
//
// This function enters an item from the screen and sets it to the current block
//
// note 0 goes back up the heirachy
//=================================================================
void Profiler::selectDisplayItem(int item)
{
	int traverseIndex;
	traverseIndex = profilerBlock[currDisplayBlock].childIndex;

	// go up the heirachy
	if (item == 0)
	{
		// k go up if we can
		if (profilerBlock[currDisplayBlock].parentIndex != -1)
			currDisplayBlock = profilerBlock[currDisplayBlock].parentIndex;
		return;
	}

	// check to make sure something is here
	if (traverseIndex == -1)
		return;

	// ok traverse it and count
	int tCounter = 1;

	while (traverseIndex != -1)
	{
		if (tCounter == item)
		{
			// we have our index, only change if it has children
			if (profilerBlock[traverseIndex].childIndex != -1)
				currDisplayBlock = traverseIndex;			
			return;
		}
		traverseIndex = profilerBlock[traverseIndex].siblingIndex;
		tCounter++;
	}

}



Profiler::~Profiler()
{

}


int Profiler::getTimeBlockIndex(CString name)
{
	for (int ix = 0; ix < maxIndex; ix++)
	{	
		if (name == profilerBlock[ix].name)
		{
			  return ix;			 
		}
	}
	return -1;
}